/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-12-05 21:15:13 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_notes` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `route_url` text DEFAULT NULL COMMENT 'Clean url where the note was created.',
  `route_title` varchar(255) DEFAULT NULL,
  `route_post_id` bigint(20) unsigned DEFAULT NULL COMMENT 'The post id of the route that the note was created on.',
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `element_id` varchar(60) DEFAULT NULL COMMENT 'The Elementor element ID the note is attached to.',
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `author_id` bigint(20) unsigned DEFAULT NULL,
  `author_display_name` varchar(250) DEFAULT NULL COMMENT 'Save the author name when the author was deleted.',
  `status` varchar(20) NOT NULL DEFAULT 'publish',
  `position` text DEFAULT NULL COMMENT 'A JSON string that represents the position of the note inside the element in percentages. e.g. {x:10, y:15}',
  `content` longtext DEFAULT NULL,
  `is_resolved` tinyint(1) NOT NULL DEFAULT 0,
  `is_public` tinyint(1) NOT NULL DEFAULT 1,
  `last_activity_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `route_url_index` (`route_url`(191)),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `parent_id_index` (`parent_id`),
  KEY `author_id_index` (`author_id`),
  KEY `status_index` (`status`),
  KEY `is_resolved_index` (`is_resolved`),
  KEY `is_public_index` (`is_public`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `last_activity_at_index` (`last_activity_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_notes_users_relations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) NOT NULL COMMENT 'The relation type between user and note (e.g mention, watch, read).',
  `note_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`),
  KEY `note_id_index` (`note_id`),
  KEY `user_id_index` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(60) DEFAULT NULL,
  `hash_id` varchar(60) NOT NULL,
  `main_meta_id` bigint(20) unsigned NOT NULL COMMENT 'Id of main field. to represent the main meta field',
  `post_id` bigint(20) unsigned NOT NULL,
  `referer` varchar(500) NOT NULL,
  `referer_title` varchar(300) DEFAULT NULL,
  `element_id` varchar(20) NOT NULL,
  `form_name` varchar(60) NOT NULL,
  `campaign_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip` varchar(46) NOT NULL,
  `user_agent` text NOT NULL,
  `actions_count` int(11) DEFAULT 0,
  `actions_succeeded_count` int(11) DEFAULT 0,
  `status` varchar(20) NOT NULL,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `meta` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash_id_unique_index` (`hash_id`),
  KEY `main_meta_id_index` (`main_meta_id`),
  KEY `hash_id_index` (`hash_id`),
  KEY `type_index` (`type`),
  KEY `post_id_index` (`post_id`),
  KEY `element_id_index` (`element_id`),
  KEY `campaign_id_index` (`campaign_id`),
  KEY `user_id_index` (`user_id`),
  KEY `user_ip_index` (`user_ip`),
  KEY `status_index` (`status`),
  KEY `is_read_index` (`is_read`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`),
  KEY `referer_index` (`referer`(191)),
  KEY `referer_title_index` (`referer_title`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions_actions_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL,
  `action_name` varchar(60) NOT NULL,
  `action_label` varchar(60) DEFAULT NULL,
  `status` varchar(20) NOT NULL,
  `log` text DEFAULT NULL,
  `created_at_gmt` datetime NOT NULL,
  `updated_at_gmt` datetime NOT NULL,
  `created_at` datetime NOT NULL,
  `updated_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `action_name_index` (`action_name`),
  KEY `status_index` (`status`),
  KEY `created_at_gmt_index` (`created_at_gmt`),
  KEY `updated_at_gmt_index` (`updated_at_gmt`),
  KEY `created_at_index` (`created_at`),
  KEY `updated_at_index` (`updated_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_submissions_values` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `submission_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `key` varchar(60) DEFAULT NULL,
  `value` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `submission_id_index` (`submission_id`),
  KEY `key_index` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_draft_submissions` (
  `uuid` char(32) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `form_id` mediumint(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` varchar(45) NOT NULL,
  `source_url` longtext NOT NULL,
  `submission` longtext NOT NULL,
  PRIMARY KEY (`uuid`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_entry` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `post_id` bigint(10) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_starred` tinyint(10) NOT NULL DEFAULT 0,
  `is_read` tinyint(10) NOT NULL DEFAULT 0,
  `ip` varchar(45) NOT NULL,
  `source_url` varchar(200) NOT NULL DEFAULT '',
  `user_agent` varchar(250) NOT NULL DEFAULT '',
  `currency` varchar(5) DEFAULT NULL,
  `payment_status` varchar(15) DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_amount` decimal(19,2) DEFAULT NULL,
  `payment_method` varchar(30) DEFAULT NULL,
  `transaction_id` varchar(50) DEFAULT NULL,
  `is_fulfilled` tinyint(10) DEFAULT NULL,
  `created_by` bigint(10) unsigned DEFAULT NULL,
  `transaction_type` tinyint(10) DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'active',
  `source_id` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `form_id_status` (`form_id`,`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_entry_meta` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL DEFAULT 0,
  `entry_id` bigint(10) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  `item_index` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `entry_id` (`entry_id`),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_entry_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` int(10) unsigned NOT NULL,
  `user_name` varchar(250) DEFAULT NULL,
  `user_id` bigint(10) DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `value` longtext DEFAULT NULL,
  `note_type` varchar(50) DEFAULT NULL,
  `sub_type` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entry_id` (`entry_id`),
  KEY `entry_user_key` (`entry_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_form` (
  `id` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_active` tinyint(10) NOT NULL DEFAULT 1,
  `is_trash` tinyint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_form_meta` (
  `form_id` mediumint(10) unsigned NOT NULL,
  `display_meta` longtext DEFAULT NULL,
  `entries_grid_meta` longtext DEFAULT NULL,
  `confirmations` longtext DEFAULT NULL,
  `notifications` longtext DEFAULT NULL,
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_form_revisions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `display_meta` longtext DEFAULT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_form_view` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` char(15) DEFAULT NULL,
  `count` mediumint(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gf_rest_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=31914 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=266 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`),
  KEY `type_status_author` (`post_type`,`post_status`,`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=102 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2020-01-30 20:48:57", "2020-01-30 20:48:57", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("17", "20240821_astrademo", "45da11e37d42b08a2324_20251205211505", "20", "2025-12-05 21:15:13", "ld-demo", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-05 21:15:05\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:7:\"10.6.24\";s:10:\"VersionPHP\";s:6:\"8.4.15\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:17;s:4:\"Name\";s:18:\"20240821_astrademo\";s:4:\"Hash\";s:35:\"45da11e37d42b08a2324_20251205211505\";s:8:\"NameHash\";s:54:\"20240821_astrademo_45da11e37d42b08a2324_20251205211505\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:64:\"20240821_astrademo_45da11e37d42b08a2324_20251205211505_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.7\";s:6:\"WPUser\";s:7:\"ld-demo\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:66:\"20240821_astrademo_45da11e37d42b08a2324_20251205211505_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:37:\"/home/ldstage/public_html/astra-theme\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:3037;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:13287;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-12-05 21:15:05\";s:7:\"Version\";s:6:\"1.5.14\";s:9:\"VersionWP\";s:3:\"6.9\";s:9:\"VersionDB\";s:7:\"10.6.24\";s:10:\"VersionPHP\";s:6:\"8.4.15\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:18:\"20240821_astrademo\";s:4:\"Hash\";s:35:\"45da11e37d42b08a2324_20251205211505\";s:8:\"NameHash\";s:54:\"20240821_astrademo_45da11e37d42b08a2324_20251205211505\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:72:\"20240821_astrademo_45da11e37d42b08a2324_20251205211505_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:51:\"/home/ldstage/public_html/astra-theme/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:67:\"20240821_astrademo_45da11e37d42b08a2324_20251205211505_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:137:\"/home/ldstage/public_html/astra-theme/wp-content/backups-dup-lite/tmp/20240821_astrademo_45da11e37d42b08a2324_20251205211505_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:46:\"/home/ldstage/public_html/astra-theme/wp-admin\";i:1;s:49:\"/home/ldstage/public_html/astra-theme/wp-includes\";i:2;s:58:\"/home/ldstage/public_html/astra-theme/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:37:\"/home/ldstage/public_html/astra-theme\";i:1;s:37:\"/home/ldstage/public_html/astra-theme\";i:2;s:48:\"/home/ldstage/public_html/astra-theme/wp-content\";i:3;s:56:\"/home/ldstage/public_html/astra-theme/wp-content/uploads\";i:4;s:56:\"/home/ldstage/public_html/astra-theme/wp-content/plugins\";i:5;s:59:\"/home/ldstage/public_html/astra-theme/wp-content/mu-plugins\";i:6;s:55:\"/home/ldstage/public_html/astra-theme/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:69:\"/home/ldstage/public_html/astra-theme/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://stage.myliquis.co/astra-theme", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://stage.myliquis.co/astra-theme", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Astra Demo", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Just another WordPress site", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "brad@liquisdigital.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:132:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:18:\"astra-portfolio/?$\";s:35:\"index.php?post_type=astra-portfolio\";s:48:\"astra-portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=astra-portfolio&feed=$matches[1]\";s:43:\"astra-portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?post_type=astra-portfolio&feed=$matches[1]\";s:35:\"astra-portfolio/page/([0-9]{1,})/?$\";s:53:\"index.php?post_type=astra-portfolio&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:43:\"astra-portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"astra-portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"astra-portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"astra-portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"astra-portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"astra-portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"astra-portfolio/([^/]+)/embed/?$\";s:48:\"index.php?astra-portfolio=$matches[1]&embed=true\";s:36:\"astra-portfolio/([^/]+)/trackback/?$\";s:42:\"index.php?astra-portfolio=$matches[1]&tb=1\";s:56:\"astra-portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?astra-portfolio=$matches[1]&feed=$matches[2]\";s:51:\"astra-portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?astra-portfolio=$matches[1]&feed=$matches[2]\";s:44:\"astra-portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?astra-portfolio=$matches[1]&paged=$matches[2]\";s:51:\"astra-portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?astra-portfolio=$matches[1]&cpage=$matches[2]\";s:40:\"astra-portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?astra-portfolio=$matches[1]&page=$matches[2]\";s:32:\"astra-portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"astra-portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"astra-portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"astra-portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"astra-portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"astra-portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:67:\"astra-portfolio-categories/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?astra-portfolio-categories=$matches[1]&feed=$matches[2]\";s:62:\"astra-portfolio-categories/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?astra-portfolio-categories=$matches[1]&feed=$matches[2]\";s:43:\"astra-portfolio-categories/([^/]+)/embed/?$\";s:59:\"index.php?astra-portfolio-categories=$matches[1]&embed=true\";s:55:\"astra-portfolio-categories/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?astra-portfolio-categories=$matches[1]&paged=$matches[2]\";s:37:\"astra-portfolio-categories/([^/]+)/?$\";s:48:\"index.php?astra-portfolio-categories=$matches[1]\";s:73:\"astra-portfolio-other-categories/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:71:\"index.php?astra-portfolio-other-categories=$matches[1]&feed=$matches[2]\";s:68:\"astra-portfolio-other-categories/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:71:\"index.php?astra-portfolio-other-categories=$matches[1]&feed=$matches[2]\";s:49:\"astra-portfolio-other-categories/([^/]+)/embed/?$\";s:65:\"index.php?astra-portfolio-other-categories=$matches[1]&embed=true\";s:61:\"astra-portfolio-other-categories/([^/]+)/page/?([0-9]{1,})/?$\";s:72:\"index.php?astra-portfolio-other-categories=$matches[1]&paged=$matches[2]\";s:43:\"astra-portfolio-other-categories/([^/]+)/?$\";s:54:\"index.php?astra-portfolio-other-categories=$matches[1]\";s:61:\"astra-portfolio-tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?astra-portfolio-tags=$matches[1]&feed=$matches[2]\";s:56:\"astra-portfolio-tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?astra-portfolio-tags=$matches[1]&feed=$matches[2]\";s:37:\"astra-portfolio-tags/([^/]+)/embed/?$\";s:53:\"index.php?astra-portfolio-tags=$matches[1]&embed=true\";s:49:\"astra-portfolio-tags/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?astra-portfolio-tags=$matches[1]&paged=$matches[2]\";s:31:\"astra-portfolio-tags/([^/]+)/?$\";s:42:\"index.php?astra-portfolio-tags=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:12:{i:0;s:29:\"gravityforms/gravityforms.php\";i:1;s:19:\"akismet/akismet.php\";i:2;s:27:\"astra-addon/astra-addon.php\";i:3;s:35:\"astra-portfolio/astra-portfolio.php\";i:4;s:35:\"astra-pro-sites/astra-pro-sites.php\";i:5;s:33:\"classic-editor/classic-editor.php\";i:6;s:25:\"duplicator/duplicator.php\";i:7;s:31:\"elementor-pro/elementor-pro.php\";i:8;s:23:\"elementor/elementor.php\";i:9;s:56:\"essential-addons-elementor/essential_adons_elementor.php\";i:10;s:65:\"essential-addons-for-elementor-lite/essential_adons_elementor.php\";i:11;s:41:\"ultimate-elementor/ultimate-elementor.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "https://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("40", "template", "astra", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "astra-child", "yes");
INSERT INTO `wp_options` VALUES("933", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("44", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("46", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("47", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("48", "db_version", "60717", "yes");
INSERT INTO `wp_options` VALUES("49", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("51", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("52", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("53", "show_on_front", "posts", "yes");
INSERT INTO `wp_options` VALUES("54", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("55", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("56", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("57", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("59", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("60", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("61", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("62", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("63", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("64", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("65", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("67", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("68", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("69", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("70", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("71", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("72", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("73", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("74", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("75", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("76", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("77", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "widget_text", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("80", "widget_rss", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("81", "uninstall_plugins", "a:1:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}", "no");
INSERT INTO `wp_options` VALUES("82", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("83", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "page_on_front", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("86", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("87", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("88", "site_icon", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("90", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("91", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("92", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("93", "admin_email_lifespan", "1765227876", "yes");
INSERT INTO `wp_options` VALUES("94", "initial_db_version", "45805", "yes");
INSERT INTO `wp_options` VALUES("95", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:70:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:26:\"create_notes_elementor-pro\";b:1;s:24:\"edit_notes_elementor-pro\";b:1;s:26:\"delete_notes_elementor-pro\";b:1;s:24:\"read_notes_elementor-pro\";b:1;s:31:\"edit_others_notes_elementor-pro\";b:1;s:33:\"delete_others_notes_elementor-pro\";b:1;s:39:\"read_others_private_notes_elementor-pro\";b:1;s:26:\"manage_ast_block_templates\";b:1;s:23:\"manage_zip_ai_assistant\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:35:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:23:\"manage_zip_ai_assistant\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("96", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("97", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("98", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("99", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("100", "widget_archives", "a:2:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("101", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("102", "sidebars_widgets", "a:10:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:13:\"header-widget\";a:0:{}s:15:\"footer-widget-1\";a:0:{}s:15:\"footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-1\";a:0:{}s:24:\"advanced-footer-widget-2\";a:0:{}s:24:\"advanced-footer-widget-3\";a:0:{}s:24:\"advanced-footer-widget-4\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("103", "cron", "a:16:{i:1764969477;a:1:{s:17:\"gravityforms_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1764971337;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1764998452;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765010937;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765043547;a:1:{s:27:\"astra_addon_get_addon_usage\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765043602;a:1:{s:29:\"astra_get_knowledge_base_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765047911;a:1:{s:31:\"eael_remove_unused_options_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765054137;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765054152;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765054341;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1765096024;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1765299723;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765469421;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765469537;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1765471388;a:1:{s:24:\"astra_delete_docs_folder\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("17607", "duplicator_notifications", "a:4:{s:6:\"update\";i:1764968641;s:4:\"feed\";a:1:{i:0;a:7:{s:5:\"title\";s:62:\"Last chance to get 60% off Duplicator Pro + free media cleaner\";s:7:\"content\";s:259:\"Green Monday is here! Get up to 60% off Duplicator Pro while we support The Conservation Fund. Your purchase helps protect nature and fight climate change. Ready to manage your sites while keeping your budget (and the planet) green? Claim your discount today.\";s:4:\"type\";s:3:\"any\";s:2:\"id\";i:24;s:3:\"btn\";a:4:{s:8:\"main_url\";s:102:\"https://duplicator.com/pricing/?utm_source=dup-notification&utm_medium=in-plugin-cta&utm_campaign=BF25\";s:9:\"main_text\";s:10:\"Learn More\";s:7:\"alt_url\";N;s:8:\"alt_text\";N;}s:5:\"start\";s:19:\"2025-12-08 00:00:00\";s:3:\"end\";s:19:\"2025-12-09 00:00:00\";}}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "auto");
INSERT INTO `wp_options` VALUES("104", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("121", "theme_mods_twentytwenty", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1580417431;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}", "no");
INSERT INTO `wp_options` VALUES("299", "elementor_custom_icon_sets_config", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("599", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:22:\"brad@liquisdigital.com\";s:7:\"version\";s:5:\"6.7.2\";s:9:\"timestamp\";i:1739317284;}", "off");
INSERT INTO `wp_options` VALUES("1092", "_astra_ext_white_label", "a:1:{s:11:\"astra-sites\";a:2:{s:4:\"name\";s:0:\"\";s:11:\"description\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("1093", "astra-pro-sites-auto-version", "4.4.43", "off");
INSERT INTO `wp_options` VALUES("2608", "_elementor_pro_api_requests_lock", "a:2:{s:11:\"get_version\";i:1764968880;s:16:\"get_license_data\";i:1764968661;}", "yes");
INSERT INTO `wp_options` VALUES("7646", "ai1wm_updater", "a:1:{s:43:\"all-in-one-wp-migration-unlimited-extension\";a:13:{s:4:\"name\";s:19:\"Unlimited Extension\";s:4:\"slug\";s:19:\"unlimited-extension\";s:8:\"homepage\";s:51:\"https://servmask.com/extensions/unlimited-extension\";s:13:\"download_link\";s:29:\"https://servmask.com/purchase\";s:7:\"version\";s:4:\"2.42\";s:6:\"author\";s:8:\"ServMask\";s:15:\"author_homepage\";s:20:\"https://servmask.com\";s:8:\"sections\";a:1:{s:11:\"description\";s:259:\"<ul class=\"description\"><li>Remove the import limit of 512MB</li><li>Lifetime license with lifetime updates</li><li>Use on any number of websites that you own</li><li>Unlimited Extension included</li><li>WP CLI commands</li><li>Premium support</li></ul><br />\";}s:7:\"banners\";a:2:{s:3:\"low\";s:65:\"https://servmask.com/img/products/unlimited-extension-772x250.png\";s:4:\"high\";s:66:\"https://servmask.com/img/products/unlimited-extension-1544x500.png\";}s:5:\"icons\";a:3:{s:2:\"1x\";s:65:\"https://servmask.com/img/products/unlimited-extension-128x128.png\";s:2:\"2x\";s:65:\"https://servmask.com/img/products/unlimited-extension-256x256.png\";s:7:\"default\";s:65:\"https://servmask.com/img/products/unlimited-extension-256x256.png\";}s:6:\"rating\";i:99;s:11:\"num_ratings\";i:309;s:10:\"downloaded\";i:40188;}}", "yes");
INSERT INTO `wp_options` VALUES("753", "_elementor_pro_license_data_fallback", "a:2:{s:7:\"timeout\";i:1674667835;s:5:\"value\";s:197:\"{\"expires\":\"2024-01-02 00:01:31\",\"subscription_id\":9028614,\"success\":true,\"license\":\"valid\",\"subscriptions\":\"enable\",\"features\":[\"template_access_level_20\",\"kit_access_level_20\",\"editor_comments\"]}\";}", "no");
INSERT INTO `wp_options` VALUES("754", "_elementor_pro_license_data", "a:2:{s:7:\"timeout\";i:1674624635;s:5:\"value\";s:197:\"{\"expires\":\"2024-01-02 00:01:31\",\"subscription_id\":9028614,\"success\":true,\"license\":\"valid\",\"subscriptions\":\"enable\",\"features\":[\"template_access_level_20\",\"kit_access_level_20\",\"editor_comments\"]}\";}", "no");
INSERT INTO `wp_options` VALUES("811", "bsf_analytics_optin", "no", "no");
INSERT INTO `wp_options` VALUES("348", "elementor_fonts_manager_font_types", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("349", "elementor_fonts_manager_fonts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("930", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("931", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("932", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("553", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("146", "current_theme", "Liquis Digital Theme", "yes");
INSERT INTO `wp_options` VALUES("147", "theme_mods_astra-child", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO `wp_options` VALUES("148", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("183", "_elementor_installed_time", "1580417551", "yes");
INSERT INTO `wp_options` VALUES("184", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:4:{i:0;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:20472;s:5:\"title\";s:10:\"test ido f\";s:9:\"thumbnail\";s:153:\"https://library.stg.elementor.red/wp-content/uploads/2025/01/png-clipart-logo-harry-potter-literary-series-lord-voldemort-film-harry-potter-thumbnail.png\";s:12:\"tmpl_created\";i:1751356263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.stg.elementor.red/blocks/test-ido-f/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:1;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:19968;s:5:\"title\";s:12:\"Zeyad Test 1\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_2.jpg\";s:12:\"tmpl_created\";i:1670765723;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.stg.elementor.red/blocks/zeyad-test-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:2;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:19494;s:5:\"title\";s:5:\"test2\";s:9:\"thumbnail\";s:83:\"https://library.stg.elementor.red/wp-content/uploads/2022/09/boxking_hero_img_4.jpg\";s:12:\"tmpl_created\";i:1672308146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.stg.elementor.red/blocks/test2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:20;}i:3;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:9631;s:5:\"title\";s:38:\"Slide-in | Sale | Register | Subscribe\";s:9:\"thumbnail\";s:87:\"https://library.stg.elementor.red/wp-content/uploads/2019/01/Slide-in_Sale_small_01.png\";s:12:\"tmpl_created\";i:1660034300;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.stg.elementor.red/popups/slide-in-sale-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:142;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}}}", "off");
INSERT INTO `wp_options` VALUES("31878", "brainstrom_bundled_products", "a:1:{s:15:\"astra-pro-sites\";a:7:{i:0;O:8:\"stdClass\":21:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:20:\"astra-sites-showcase\";s:4:\"init\";s:45:\"astra-sites-showcase/astra-sites-showcase.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:24:\"astra-sites-showcase.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:20:\"Astra Sites Showcase\";s:10:\"short_name\";s:20:\"astra-sites-showcase\";s:7:\"version\";s:5:\"1.0.0\";s:6:\"tested\";s:5:\"4.9.0\";s:4:\"slug\";s:20:\"astra-sites-showcase\";s:13:\"product_image\";s:0:\"\";s:11:\"description\";s:0:\"\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.0.0\";s:12:\"version_beta\";s:0:\"\";s:17:\"download_url_beta\";s:24:\"astra-sites-showcase.zip\";s:6:\"parent\";s:15:\"astra-pro-sites\";s:13:\"changelog_url\";s:0:\"\";}i:1;O:8:\"stdClass\":21:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:10:\"convertpro\";s:4:\"init\";s:25:\"convertpro/convertpro.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:14:\"convertpro.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:11:\"Convert Pro\";s:10:\"short_name\";s:11:\"Convert Pro\";s:7:\"version\";s:5:\"1.8.4\";s:6:\"tested\";s:3:\"6.8\";s:4:\"slug\";s:10:\"convertpro\";s:13:\"product_image\";s:72:\"//support.brainstormforce.com/wp-content/uploads/2018/12/convert-pro.svg\";s:11:\"description\";s:148:\"Convert Pro is an advanced lead generation popup plugin that comes with a drag and drop editor to help you create beautiful popups and opt-in forms.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.8.7\";s:12:\"version_beta\";s:0:\"\";s:17:\"download_url_beta\";s:0:\"\";s:6:\"parent\";s:15:\"astra-pro-sites\";s:13:\"changelog_url\";s:47:\"https://www.convertpro.net/product/convert-pro/\";}i:2;O:8:\"stdClass\":21:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:4:\"uabb\";s:4:\"init\";s:39:\"bb-ultimate-addon/bb-ultimate-addon.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:21:\"bb-ultimate-addon.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:34:\"Ultimate Addons for Beaver Builder\";s:10:\"short_name\";s:22:\"Ultimate Addons for BB\";s:7:\"version\";s:6:\"1.36.7\";s:6:\"tested\";s:3:\"6.8\";s:4:\"slug\";s:17:\"bb-ultimate-addon\";s:13:\"product_image\";s:70:\"//support.brainstormforce.com/wp-content/uploads/2018/10/uabb-logo.svg\";s:11:\"description\";s:132:\"UABB is a premium extension for Beaver Builder that adds 55+ modules, 200+ templates and works on top of any Beaver Builder Package.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:7:\"1.36.14\";s:12:\"version_beta\";s:0:\"\";s:17:\"download_url_beta\";s:0:\"\";s:6:\"parent\";s:15:\"astra-pro-sites\";s:13:\"changelog_url\";s:117:\"https://www.ultimatebeaver.com/whats-new/?utm_source=uabb-pro-dashboard&utm_medium=changelog&utm_campaign=get-license\";}i:3;O:8:\"stdClass\":21:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:11:\"astra-addon\";s:4:\"init\";s:27:\"astra-addon/astra-addon.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:22:\"astra-addon-plugin.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:9:\"Astra Pro\";s:10:\"short_name\";s:9:\"Astra Pro\";s:7:\"version\";s:7:\"4.11.11\";s:6:\"tested\";s:3:\"6.8\";s:4:\"slug\";s:11:\"astra-addon\";s:13:\"product_image\";s:71:\"//support.brainstormforce.com/wp-content/uploads/2018/12/astra-logo.svg\";s:11:\"description\";s:153:\"This plugin is an add-on for the Astra WordPress Theme. It offers premium features & functionalities that enhance your theming experience at next level..\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:7:\"4.11.11\";s:12:\"version_beta\";s:12:\"3.6.0-beta.1\";s:17:\"download_url_beta\";s:27:\"astra-addon-plugin-beta.zip\";s:6:\"parent\";s:15:\"astra-pro-sites\";s:13:\"changelog_url\";s:142:\"https://wpastra.com/changelog/astra-pro-addon/?utm_source=graupi-license-form&utm_medium=astra-pro-addon-changelog&utm_campaign=purchase-astra\";}i:4;O:8:\"stdClass\":21:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:15:\"astra-portfolio\";s:4:\"init\";s:35:\"astra-portfolio/astra-portfolio.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:19:\"astra-portfolio.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:12:\"WP Portfolio\";s:10:\"short_name\";s:12:\"WP Portfolio\";s:7:\"version\";s:6:\"1.13.3\";s:6:\"tested\";s:3:\"6.8\";s:4:\"slug\";s:15:\"astra-portfolio\";s:13:\"product_image\";s:73:\"//support.brainstormforce.com/wp-content/uploads/2019/03/wp-portfolio.svg\";s:11:\"description\";s:92:\"Display the portfolio of Astra Starter Sites & other portfolio items easily on your website.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:6:\"1.13.3\";s:12:\"version_beta\";s:0:\"\";s:17:\"download_url_beta\";s:0:\"\";s:6:\"parent\";s:15:\"astra-pro-sites\";s:13:\"changelog_url\";s:120:\"https://wpportfolio.net/changelog/?utm_source=graupi-license-form&utm_medium=changelog&utm_campaign=purchase-wpportfolio\";}i:5;O:8:\"stdClass\":21:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:2:\"id\";s:4:\"uael\";s:4:\"init\";s:41:\"ultimate-elementor/ultimate-elementor.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:12:\"download_url\";s:22:\"ultimate-elementor.zip\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:29:\"Ultimate Addons for Elementor\";s:10:\"short_name\";s:4:\"UAEL\";s:7:\"version\";s:6:\"1.42.0\";s:6:\"tested\";s:3:\"6.8\";s:4:\"slug\";s:18:\"ultimate-elementor\";s:13:\"product_image\";s:70:\"//support.brainstormforce.com/wp-content/uploads/2018/12/uael-logo.svg\";s:11:\"description\";s:170:\"Ultimate Addons is a premium extension for Elementor that adds 50+ widgets and works on top of any Elementor Package (Free, Pro). You can use it with any WordPress theme.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:6:\"1.42.0\";s:12:\"version_beta\";s:0:\"\";s:17:\"download_url_beta\";s:0:\"\";s:6:\"parent\";s:15:\"astra-pro-sites\";s:13:\"changelog_url\";s:122:\"https://ultimateelementor.com/whats-new/?utm_source=graupi-updater&utm_medium=changelog-link&utm_campaign=graupi-changelog\";}i:6;O:8:\"stdClass\":21:{s:15:\"licence_require\";s:5:\"false\";s:22:\"licence_require_update\";s:0:\"\";s:19:\"must_have_extension\";s:5:\"false\";s:4:\"init\";s:27:\"spectra-pro/spectra-pro.php\";s:6:\"author\";s:16:\"Brainstorm Force\";s:2:\"id\";s:11:\"spectra-pro\";s:12:\"download_url\";s:0:\"\";s:4:\"type\";s:6:\"plugin\";s:4:\"name\";s:11:\"Spectra Pro\";s:10:\"short_name\";s:11:\"Spectra Pro\";s:7:\"version\";s:5:\"1.2.2\";s:6:\"tested\";s:5:\"6.8.1\";s:4:\"slug\";s:11:\"spectra-pro\";s:13:\"product_image\";s:68:\"//support.brainstormforce.com/wp-content/uploads/2023/06/spectra.svg\";s:11:\"description\";s:100:\"Enhance Spectra with new features and blocks, as well as extended functionality for existing blocks.\";s:8:\"in_house\";s:4:\"true\";s:6:\"remote\";s:5:\"1.2.8\";s:12:\"version_beta\";s:0:\"\";s:17:\"download_url_beta\";s:0:\"\";s:6:\"parent\";s:15:\"astra-pro-sites\";s:13:\"changelog_url\";s:126:\"https://wpspectra.com/whats-new/?utm_source=graupi-license-form&utm_medium=spectra-pro-changelog&utm_campaign=purchase-spectra\";}}}", "auto");
INSERT INTO `wp_options` VALUES("180", "elementor_version", "3.33.3", "yes");
INSERT INTO `wp_options` VALUES("182", "uael-version", "1.42.0", "yes");
INSERT INTO `wp_options` VALUES("149", "astra-settings", "a:174:{s:18:\"theme-auto-version\";s:7:\"4.11.16\";s:22:\"is_theme_queue_running\";b:0;s:24:\"astra-addon-auto-version\";s:7:\"4.11.11\";s:22:\"is_addon_queue_running\";b:0;s:33:\"_astra_pb_compatibility_completed\";b:1;s:28:\"is_astra_addon_queue_running\";b:0;s:41:\"header-main-rt-section-button-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:35:\"ele-default-color-typo-setting-comp\";b:0;s:34:\"can-update-theme-tablet-breakpoint\";b:0;s:27:\"gtn-full-wide-image-grp-css\";b:0;s:34:\"can-update-addon-tablet-breakpoint\";b:0;s:18:\"global-btn-woo-css\";b:0;s:27:\"gtn-full-wide-grp-cover-css\";b:0;s:31:\"guntenberg-core-blocks-comp-css\";b:0;s:39:\"guntenberg-media-text-block-padding-css\";b:0;s:24:\"is-header-footer-builder\";b:0;s:28:\"header-footer-builder-notice\";b:0;s:36:\"guntenberg-button-pattern-compat-css\";b:0;s:26:\"can-update-astra-icons-svg\";b:0;s:17:\"is-flex-based-css\";b:0;s:54:\"can-update-page-header-compatibility-to-header-builder\";b:1;s:35:\"can-support-widget-and-editor-fonts\";b:0;s:36:\"can-reflect-cart-color-in-old-header\";b:0;s:30:\"add-outline-cart-bg-new-header\";b:0;s:41:\"remove-header-sections-deps-in-new-header\";b:0;s:35:\"support-swap-mobile-header-sections\";b:0;s:44:\"sticky-header-default-site-title-tagline-css\";b:0;s:29:\"can-remove-logo-max-width-css\";b:0;s:33:\"transparent-header-default-border\";b:0;s:27:\"btn-default-padding-updated\";b:0;s:23:\"underline-content-links\";b:0;s:20:\"support-block-editor\";b:0;s:34:\"support-footer-widget-right-margin\";b:0;s:31:\"remove-elementor-toc-margin-css\";b:0;s:28:\"remove-widget-design-options\";b:0;s:29:\"astra-zero-font-size-case-css\";b:0;s:32:\"unset-builder-elements-underline\";b:0;s:27:\"support-global-color-format\";b:0;s:22:\"footer-copyright-color\";s:7:\"#3a3a3a\";s:20:\"improve-gb-editor-ui\";b:0;s:29:\"breadcrumb-separator-selector\";s:7:\"unicode\";s:42:\"apply-content-background-fullwidth-layouts\";b:0;s:19:\"blocks-legacy-setup\";b:1;s:12:\"wp-blocks-ui\";s:6:\"legacy\";s:19:\"shop-button-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:33:\"astra-product-gallery-layout-flag\";b:0;s:33:\"astra-woocommerce-cart-icons-flag\";b:0;s:22:\"shop-toolbar-structure\";a:2:{i:0;s:7:\"results\";i:1;s:7:\"sorting\";}s:37:\"shop-toolbar-structure-with-hiddenset\";a:4:{s:7:\"results\";b:1;s:7:\"filters\";b:0;s:7:\"sorting\";b:1;s:9:\"easy_view\";b:0;}s:22:\"modern-ecommerce-setup\";b:0;s:32:\"customizer-default-layout-update\";b:0;s:15:\"wp-blocks-v2-ui\";b:0;s:33:\"single-product-breadcrumb-disable\";b:1;s:29:\"woo-header-cart-label-display\";s:33:\"Cart/{cart_total_currency_symbol}\";s:12:\"border-color\";s:7:\"#dddddd\";s:22:\"woo-show-password-icon\";b:0;s:19:\"woo-shop-style-flag\";b:1;s:31:\"can-update-variant-active-style\";b:0;s:32:\"addon-dynamic-customizer-support\";b:1;s:32:\"astra-old-global-sidebar-default\";b:0;s:28:\"spectra-gutenberg-compat-css\";b:0;s:20:\"dynamic-blog-layouts\";b:0;s:32:\"theme-dynamic-customizer-support\";b:1;s:44:\"ast-dynamic-single-astra-portfolio-structure\";a:2:{i:0;s:40:\"ast-dynamic-single-astra-portfolio-image\";i:1;s:40:\"ast-dynamic-single-astra-portfolio-title\";}s:43:\"ast-dynamic-single-astra-portfolio-metadata\";a:2:{i:0;s:8:\"comments\";i:1;s:6:\"author\";}s:33:\"ast-archive-astra-portfolio-title\";b:1;s:32:\"ast-single-astra-portfolio-title\";b:1;s:53:\"ast-dynamic-archive-astra-portfolio-banner-image-type\";s:4:\"none\";s:52:\"ast-dynamic-archive-astra-portfolio-banner-custom-bg\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:53:\"ast-dynamic-archive-astra-portfolio-title-font-family\";s:0:\"\";s:51:\"ast-dynamic-archive-astra-portfolio-title-font-size\";a:6:{s:7:\"desktop\";i:40;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:53:\"ast-dynamic-archive-astra-portfolio-title-font-weight\";s:0:\"\";s:53:\"ast-dynamic-archive-astra-portfolio-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:54:\"ast-dynamic-archive-astra-portfolio-banner-title-color\";s:0:\"\";s:53:\"ast-dynamic-archive-astra-portfolio-banner-text-color\";s:0:\"\";s:53:\"ast-dynamic-single-astra-portfolio-banner-title-color\";s:0:\"\";s:52:\"ast-dynamic-single-astra-portfolio-title-font-family\";s:0:\"\";s:50:\"ast-dynamic-single-astra-portfolio-title-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:52:\"ast-dynamic-single-astra-portfolio-title-font-weight\";s:0:\"\";s:52:\"ast-dynamic-single-astra-portfolio-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"ast-dynamic-single-post-structure\";a:3:{i:0;s:29:\"ast-dynamic-single-post-image\";i:1;s:29:\"ast-dynamic-single-post-title\";i:2;s:28:\"ast-dynamic-single-post-meta\";}s:32:\"ast-dynamic-single-post-taxonomy\";s:8:\"category\";s:32:\"ast-dynamic-single-post-metadata\";a:3:{i:0;s:8:\"comments\";i:1;s:32:\"ast-dynamic-single-post-taxonomy\";i:2;s:6:\"author\";}s:22:\"ast-archive-post-title\";b:1;s:21:\"ast-single-post-title\";b:1;s:42:\"ast-dynamic-archive-post-banner-image-type\";s:4:\"none\";s:41:\"ast-dynamic-archive-post-banner-custom-bg\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:42:\"ast-dynamic-archive-post-title-font-family\";s:0:\"\";s:40:\"ast-dynamic-archive-post-title-font-size\";a:6:{s:7:\"desktop\";i:40;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:42:\"ast-dynamic-archive-post-title-font-weight\";s:0:\"\";s:42:\"ast-dynamic-archive-post-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:43:\"ast-dynamic-archive-post-banner-title-color\";s:0:\"\";s:42:\"ast-dynamic-archive-post-banner-text-color\";s:0:\"\";s:42:\"ast-dynamic-single-post-banner-title-color\";s:0:\"\";s:41:\"ast-dynamic-single-post-title-font-family\";s:0:\"\";s:39:\"ast-dynamic-single-post-title-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:41:\"ast-dynamic-single-post-title-font-weight\";s:0:\"\";s:41:\"ast-dynamic-single-post-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:33:\"ast-dynamic-single-page-structure\";a:2:{i:0;s:29:\"ast-dynamic-single-page-image\";i:1;s:29:\"ast-dynamic-single-page-title\";}s:32:\"ast-dynamic-single-page-metadata\";a:2:{i:0;s:8:\"comments\";i:1;s:6:\"author\";}s:22:\"ast-archive-page-title\";b:1;s:21:\"ast-single-page-title\";b:1;s:42:\"ast-dynamic-archive-page-banner-image-type\";s:4:\"none\";s:41:\"ast-dynamic-archive-page-banner-custom-bg\";a:3:{s:7:\"desktop\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"tablet\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}s:6:\"mobile\";a:11:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";s:15:\"background-type\";s:0:\"\";s:16:\"background-media\";s:0:\"\";s:12:\"overlay-type\";s:0:\"\";s:13:\"overlay-color\";s:0:\"\";s:16:\"overlay-gradient\";s:0:\"\";}}s:42:\"ast-dynamic-archive-page-title-font-family\";s:0:\"\";s:40:\"ast-dynamic-archive-page-title-font-size\";a:6:{s:7:\"desktop\";i:40;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:42:\"ast-dynamic-archive-page-title-font-weight\";s:0:\"\";s:42:\"ast-dynamic-archive-page-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:43:\"ast-dynamic-archive-page-banner-title-color\";s:0:\"\";s:42:\"ast-dynamic-archive-page-banner-text-color\";s:0:\"\";s:42:\"ast-dynamic-single-page-banner-title-color\";s:0:\"\";s:41:\"ast-dynamic-single-page-title-font-family\";s:0:\"\";s:39:\"ast-dynamic-single-page-title-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:41:\"ast-dynamic-single-page-title-font-weight\";s:0:\"\";s:41:\"ast-dynamic-single-page-title-font-extras\";a:6:{s:11:\"line-height\";s:0:\"\";s:16:\"line-height-unit\";s:2:\"em\";s:14:\"letter-spacing\";s:0:\"\";s:19:\"letter-spacing-unit\";s:2:\"px\";s:14:\"text-transform\";s:0:\"\";s:15:\"text-decoration\";s:0:\"\";}s:31:\"archive-download-content-layout\";s:7:\"default\";s:31:\"archive-download-sidebar-layout\";s:10:\"no-sidebar\";s:30:\"single-download-content-layout\";s:7:\"default\";s:30:\"single-download-sidebar-layout\";s:7:\"default\";s:19:\"enable-scroll-to-id\";b:0;s:20:\"scroll-to-top-enable\";b:0;s:25:\"update-default-color-typo\";b:0;s:22:\"v4-block-editor-compat\";b:0;s:23:\"v4-1-0-update-migration\";b:1;s:27:\"single-product-payment-list\";a:1:{s:5:\"items\";a:4:{i:0;a:6:{s:2:\"id\";s:8:\"item-100\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:4:\"icon\";s:7:\"cc-visa\";s:5:\"image\";s:0:\"\";s:5:\"label\";s:4:\"Visa\";}i:1;a:6:{s:2:\"id\";s:8:\"item-101\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:4:\"icon\";s:13:\"cc-mastercard\";s:5:\"image\";s:0:\"\";s:5:\"label\";s:10:\"Mastercard\";}i:2;a:6:{s:2:\"id\";s:8:\"item-102\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:4:\"icon\";s:7:\"cc-amex\";s:5:\"image\";s:0:\"\";s:5:\"label\";s:4:\"Amex\";}i:3;a:6:{s:2:\"id\";s:8:\"item-103\";s:7:\"enabled\";b:1;s:6:\"source\";s:4:\"icon\";s:4:\"icon\";s:11:\"cc-discover\";s:5:\"image\";s:0:\"\";s:5:\"label\";s:8:\"Discover\";}}}s:27:\"woo_support_global_settings\";b:1;s:23:\"v4-1-4-update-migration\";b:1;s:37:\"apply-modern-layout-sale-badge-styles\";b:0;s:27:\"list-block-vertical-spacing\";b:0;s:25:\"fullwidth_sidebar_support\";b:0;s:23:\"v4-2-0-update-migration\";b:1;s:29:\"v4-2-2-core-form-btns-styling\";b:0;s:22:\"v4-4-0-backward-option\";b:0;s:33:\"update-default-spacing-for-header\";b:0;s:39:\"restrict-banner-layout-with-page-header\";b:0;s:22:\"v4-5-0-backward-option\";b:0;s:26:\"scndry-btn-default-padding\";b:0;s:22:\"v4-6-0-backward-option\";b:0;s:19:\"blog-post-structure\";a:5:{i:0;s:5:\"image\";i:1;s:5:\"title\";i:2;s:10:\"title-meta\";i:3;s:7:\"excerpt\";i:4;s:9:\"read-more\";}s:39:\"ast-sub-section-author-box-border-width\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:40:\"ast-sub-section-author-box-border-radius\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:39:\"ast-sub-section-author-box-border-color\";s:0:\"\";s:28:\"single-content-images-shadow\";b:0;s:21:\"ast-font-style-update\";b:0;s:22:\"v4-6-2-backward-option\";b:0;s:20:\"btn-stylings-upgrade\";b:0;s:24:\"elementor-headings-style\";b:1;s:33:\"elementor-container-padding-style\";b:1;s:14:\"font-extras-h1\";a:2:{s:11:\"line-height\";s:3:\"1.4\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-extras-h2\";a:2:{s:11:\"line-height\";s:3:\"1.3\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-extras-h3\";a:2:{s:11:\"line-height\";s:3:\"1.3\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-extras-h4\";a:2:{s:11:\"line-height\";s:3:\"1.2\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-extras-h5\";a:2:{s:11:\"line-height\";s:3:\"1.2\";s:16:\"line-height-unit\";s:2:\"em\";}s:14:\"font-extras-h6\";a:2:{s:11:\"line-height\";s:4:\"1.25\";s:16:\"line-height-unit\";s:2:\"em\";}s:34:\"global-headings-line-height-update\";b:1;s:37:\"site-builder-templates-headings-space\";b:0;s:37:\"single_posts_pages_heading_clear_none\";b:0;s:21:\"elementor-btn-styling\";b:1;s:52:\"remove_single_posts_navigation_mobile_device_padding\";b:1;s:27:\"enable-4-6-14-compatibility\";b:0;s:33:\"hiding_social_share_icon_position\";b:0;s:24:\"heading-widget-font-size\";b:0;s:26:\"enable-4-8-0-compatibility\";b:0;s:22:\"v4-8-2-backward-option\";b:0;s:26:\"enable-4-8-4-compatibility\";b:0;s:37:\"astra-heading-font-size-compatibility\";b:0;s:26:\"enable-4-8-9-compatibility\";b:0;s:20:\"off-canvas-move-body\";b:1;s:16:\"star-rating-comp\";b:0;s:22:\"v4-9-0-backward-option\";b:0;s:11:\"v4-9-2-comp\";b:0;s:18:\"load_more_btn_comp\";b:0;s:16:\"btn-consist-comp\";b:0;s:28:\"enable-4-11-12-compatibility\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("152", "astra-theme-old-setup", "1", "yes");
INSERT INTO `wp_options` VALUES("157", "bsf_force_check_extensions", "", "off");
INSERT INTO `wp_options` VALUES("158", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("159", "brainstrom_products", "a:2:{s:7:\"plugins\";a:4:{s:11:\"astra-addon\";a:32:{s:2:\"id\";s:11:\"astra-addon\";s:4:\"name\";s:9:\"Astra Pro\";s:4:\"slug\";s:11:\"astra-addon\";s:10:\"short_name\";s:0:\"\";s:11:\"description\";s:153:\"This plugin is an add-on for the Astra WordPress Theme. It offers premium features & functionalities that enhance your theming experience at next level..\";s:7:\"version\";s:7:\"4.11.11\";s:12:\"download_url\";s:22:\"astra-addon-plugin.zip\";s:12:\"version_beta\";s:12:\"3.6.0-beta.1\";s:17:\"download_url_beta\";s:27:\"astra-addon-plugin-beta.zip\";s:6:\"tested\";s:3:\"6.8\";s:14:\"privacy_policy\";s:134:\"https://store.brainstormforce.com/privacy-policy/?utm_source=graupi-license-form&utm_medium=privacy-policy&utm_campaign=purchase-astra\";s:16:\"terms_conditions\";s:146:\"https://store.brainstormforce.com/terms-and-conditions/?utm_source=graupi-license-form&utm_medium=terms-and-conditions&utm_campaign=purchase-astra\";s:12:\"purchase_url\";s:126:\"https://wpastra.com/pricing/?utm_source=graupi-license-form&utm_medium=graupi-license-invalidation&utm_campaign=purchase-astra\";s:13:\"changelog_url\";s:142:\"https://wpastra.com/changelog/astra-pro-addon/?utm_source=graupi-license-form&utm_medium=astra-pro-addon-changelog&utm_campaign=purchase-astra\";s:4:\"type\";s:6:\"plugin\";s:8:\"in_house\";s:4:\"true\";s:9:\"on_market\";s:5:\"false\";s:15:\"is_product_free\";s:5:\"false\";s:14:\"has-extensions\";s:4:\"true\";s:13:\"support_forum\";s:130:\"https://wpastra.com/support/submit-a-ticket/?utm_source=graupi-license-form&utm_medium=submit-a-ticket&utm_campaign=purchase-astra\";s:25:\"after_registration_action\";s:0:\"\";s:13:\"product_image\";s:71:\"//support.brainstormforce.com/wp-content/uploads/2018/12/astra-logo.svg\";s:32:\"show_on_register_licence_listing\";s:5:\"false\";s:15:\"show_on_listing\";s:5:\"false\";s:13:\"is_support_on\";s:4:\"true\";s:14:\"envato_item_id\";s:0:\"\";s:8:\"template\";s:27:\"astra-addon/astra-addon.php\";s:6:\"remote\";s:7:\"4.11.11\";s:12:\"purchase_key\";s:32:\"3fef2fb49176b75324263189a6e95311\";s:6:\"status\";s:10:\"registered\";s:7:\"message\";s:31:\"License successfully validated!\";s:12:\"product_name\";s:9:\"Astra Pro\";}s:4:\"uael\";a:32:{s:2:\"id\";s:4:\"uael\";s:4:\"name\";s:29:\"Ultimate Addons for Elementor\";s:4:\"slug\";s:18:\"ultimate-elementor\";s:10:\"short_name\";s:0:\"\";s:11:\"description\";s:170:\"Ultimate Addons is a premium extension for Elementor that adds 50+ widgets and works on top of any Elementor Package (Free, Pro). You can use it with any WordPress theme.\";s:7:\"version\";s:6:\"1.42.0\";s:12:\"download_url\";s:22:\"ultimate-elementor.zip\";s:12:\"version_beta\";s:0:\"\";s:17:\"download_url_beta\";s:0:\"\";s:6:\"tested\";s:3:\"6.8\";s:14:\"privacy_policy\";s:133:\"https://store.brainstormforce.com/privacy-policy/?utm_source=graupi-license-form&utm_medium=privacy-policy&utm_campaign=uael-purchase\";s:16:\"terms_conditions\";s:145:\"https://store.brainstormforce.com/terms-and-conditions/?utm_source=graupi-license-form&utm_medium=terms-and-conditions&utm_campaign=uael-purchase\";s:12:\"purchase_url\";s:119:\"http://ultimateelementor.com/pricing/?utm_source=license-form&utm_medium=uael-purchase&utm_campaign=graupi-license-form\";s:13:\"changelog_url\";s:122:\"https://ultimateelementor.com/whats-new/?utm_source=graupi-updater&utm_medium=changelog-link&utm_campaign=graupi-changelog\";s:4:\"type\";s:6:\"plugin\";s:8:\"in_house\";s:4:\"true\";s:9:\"on_market\";s:5:\"false\";s:15:\"is_product_free\";s:5:\"false\";s:14:\"has-extensions\";s:5:\"false\";s:13:\"support_forum\";s:134:\"http://ultimateelementor.com/support/submit-a-ticket/?utm_source=license-form&utm_medium=support-form&utm_campaign=graupi-license-form\";s:25:\"after_registration_action\";s:0:\"\";s:13:\"product_image\";s:70:\"//support.brainstormforce.com/wp-content/uploads/2018/12/uael-logo.svg\";s:32:\"show_on_register_licence_listing\";s:5:\"false\";s:15:\"show_on_listing\";s:5:\"false\";s:13:\"is_support_on\";s:4:\"true\";s:14:\"envato_item_id\";s:0:\"\";s:8:\"template\";s:41:\"ultimate-elementor/ultimate-elementor.php\";s:6:\"remote\";s:6:\"1.42.0\";s:12:\"purchase_key\";s:32:\"6f7112c19d4e0fa1750c7f4700fd6c1e\";s:6:\"status\";s:10:\"registered\";s:7:\"message\";s:31:\"License successfully validated!\";s:12:\"product_name\";s:33:\"Ultimate Addons for Elementor Pro\";}s:15:\"astra-portfolio\";a:32:{s:2:\"id\";s:15:\"astra-portfolio\";s:4:\"name\";s:12:\"WP Portfolio\";s:4:\"slug\";s:15:\"astra-portfolio\";s:10:\"short_name\";s:0:\"\";s:11:\"description\";s:92:\"Display the portfolio of Astra Starter Sites & other portfolio items easily on your website.\";s:7:\"version\";s:6:\"1.13.3\";s:12:\"download_url\";s:19:\"astra-portfolio.zip\";s:12:\"version_beta\";s:0:\"\";s:17:\"download_url_beta\";s:0:\"\";s:6:\"tested\";s:3:\"6.8\";s:14:\"privacy_policy\";s:140:\"https://store.brainstormforce.com/privacy-policy/?utm_source=graupi-license-form&utm_medium=privacy-policy&utm_campaign=purchase-wpportfolio\";s:16:\"terms_conditions\";s:152:\"https://store.brainstormforce.com/terms-and-conditions/?utm_source=graupi-license-form&utm_medium=terms-and-conditions&utm_campaign=purchase-wpportfolio\";s:12:\"purchase_url\";s:117:\"https://wpportfolio.net/pricing/?utm_source=graupi-license-form&utm_medium=purchase&utm_campaign=purchase-wpportfolio\";s:13:\"changelog_url\";s:120:\"https://wpportfolio.net/changelog/?utm_source=graupi-license-form&utm_medium=changelog&utm_campaign=purchase-wpportfolio\";s:4:\"type\";s:6:\"plugin\";s:8:\"in_house\";s:4:\"true\";s:9:\"on_market\";s:5:\"false\";s:15:\"is_product_free\";s:5:\"false\";s:14:\"has-extensions\";s:5:\"false\";s:13:\"support_forum\";s:140:\"https://wpportfolio.net/support/submit-a-ticket/?utm_source=graupi-license-form&utm_medium=submit-a-ticket&utm_campaign=purchase-wpportfolio\";s:25:\"after_registration_action\";s:0:\"\";s:13:\"product_image\";s:73:\"//support.brainstormforce.com/wp-content/uploads/2019/03/wp-portfolio.svg\";s:32:\"show_on_register_licence_listing\";s:5:\"false\";s:15:\"show_on_listing\";s:5:\"false\";s:13:\"is_support_on\";s:4:\"true\";s:14:\"envato_item_id\";s:0:\"\";s:8:\"template\";s:35:\"astra-portfolio/astra-portfolio.php\";s:6:\"remote\";s:6:\"1.13.3\";s:12:\"purchase_key\";s:32:\"288fd61a9380fbfec4b33ac44f2b9e1d\";s:6:\"status\";s:10:\"registered\";s:7:\"message\";s:31:\"License successfully validated!\";s:12:\"product_name\";s:12:\"WP Portfolio\";}s:15:\"astra-pro-sites\";a:32:{s:2:\"id\";s:15:\"astra-pro-sites\";s:4:\"name\";s:15:\"Astra Pro Sites\";s:4:\"slug\";s:15:\"astra-pro-sites\";s:10:\"short_name\";s:0:\"\";s:11:\"description\";s:263:\"Starter Templates is all in one solution for complete starter sites, single page templates, blocks & images. This plugin offers the premium library of ready templates & provides quick access to beautiful Pixabay images that can be imported in your website easily.\";s:7:\"version\";s:6:\"4.4.43\";s:12:\"download_url\";s:23:\"astra-premium-sites.zip\";s:12:\"version_beta\";s:0:\"\";s:17:\"download_url_beta\";s:0:\"\";s:6:\"tested\";s:3:\"6.2\";s:14:\"privacy_policy\";s:134:\"https://store.brainstormforce.com/privacy-policy/?utm_source=graupi-license-form&utm_medium=privacy-policy&utm_campaign=purchase-astra\";s:16:\"terms_conditions\";s:146:\"https://store.brainstormforce.com/terms-and-conditions/?utm_source=graupi-license-form&utm_medium=terms-and-conditions&utm_campaign=purchase-astra\";s:12:\"purchase_url\";s:120:\"https://wpastra.com/ready-websites/?utm_source=graupi-license-form&utm_medium=ready-websites&utm_campaign=purchase-astra\";s:13:\"changelog_url\";s:141:\"https://wpastra.com/changelog/astra-sites-plugin/?utm_source=graupi-license-form&utm_medium=astra-sites-changelog&utm_campaign=purchase-astra\";s:4:\"type\";s:6:\"plugin\";s:8:\"in_house\";s:4:\"true\";s:9:\"on_market\";s:5:\"false\";s:15:\"is_product_free\";s:5:\"false\";s:14:\"has-extensions\";s:4:\"true\";s:13:\"support_forum\";s:130:\"https://wpastra.com/support/submit-a-ticket/?utm_source=graupi-license-form&utm_medium=submit-a-ticket&utm_campaign=purchase-astra\";s:25:\"after_registration_action\";s:0:\"\";s:13:\"product_image\";s:65:\"//support.brainstormforce.com/wp-content/uploads/2021/05/icon.svg\";s:32:\"show_on_register_licence_listing\";s:5:\"false\";s:15:\"show_on_listing\";s:5:\"false\";s:13:\"is_support_on\";s:5:\"false\";s:14:\"envato_item_id\";s:0:\"\";s:8:\"template\";s:35:\"astra-pro-sites/astra-pro-sites.php\";s:6:\"remote\";s:6:\"4.4.43\";s:12:\"purchase_key\";s:32:\"933e3dfc38742677e8ddd595ea9ee81d\";s:6:\"status\";s:10:\"registered\";s:7:\"message\";s:31:\"License successfully validated!\";s:12:\"product_name\";s:25:\"Premium Starter Templates\";}}s:6:\"themes\";a:1:{s:5:\"astra\";a:32:{s:2:\"id\";s:5:\"astra\";s:4:\"name\";s:5:\"Astra\";s:4:\"slug\";s:5:\"astra\";s:10:\"short_name\";s:0:\"\";s:11:\"description\";s:145:\"Astra is fast, fully customizable & beautiful WordPress theme suitable for blog, personal portfolio, business website and WooCommerce storefront.\";s:7:\"version\";s:7:\"4.11.16\";s:12:\"download_url\";s:15:\"astra-1.4.9.zip\";s:12:\"version_beta\";s:0:\"\";s:17:\"download_url_beta\";s:14:\"astra-beta.zip\";s:6:\"tested\";s:3:\"5.2\";s:14:\"privacy_policy\";s:0:\"\";s:16:\"terms_conditions\";s:0:\"\";s:12:\"purchase_url\";s:0:\"\";s:13:\"changelog_url\";s:0:\"\";s:4:\"type\";s:5:\"theme\";s:8:\"in_house\";s:4:\"true\";s:9:\"on_market\";s:5:\"false\";s:15:\"is_product_free\";s:4:\"true\";s:14:\"has-extensions\";s:5:\"false\";s:13:\"support_forum\";s:0:\"\";s:25:\"after_registration_action\";s:0:\"\";s:13:\"product_image\";s:71:\"//support.brainstormforce.com/wp-content/uploads/2018/12/astra-logo.svg\";s:32:\"show_on_register_licence_listing\";s:5:\"false\";s:15:\"show_on_listing\";s:4:\"true\";s:13:\"is_support_on\";s:4:\"true\";s:14:\"envato_item_id\";s:0:\"\";s:8:\"template\";s:5:\"astra\";s:6:\"remote\";s:5:\"0.0.1\";s:12:\"purchase_key\";s:0:\"\";s:6:\"status\";s:10:\"registered\";s:7:\"message\";s:0:\"\";s:12:\"product_name\";s:5:\"Astra\";}}}", "yes");
INSERT INTO `wp_options` VALUES("160", "bsf_local_transient", "1594771644", "yes");
INSERT INTO `wp_options` VALUES("163", "bsf-updater-version", "1.29.12", "yes");
INSERT INTO `wp_options` VALUES("165", "bsf_local_transient_bundled", "1594413163", "yes");
INSERT INTO `wp_options` VALUES("170", "bsf_skip_braisntorm_menu", "1", "no");
INSERT INTO `wp_options` VALUES("227", "astra-portfolio-auto-version", "1.13.3", "yes");
INSERT INTO `wp_options` VALUES("228", "astra_portfolio_batch_excluded_sites", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("229", "astra-portfolio-settings", "a:3:{s:8:\"par-page\";s:2:\"15\";s:10:\"grid-style\";s:7:\"default\";s:8:\"per-page\";s:2:\"15\";}", "yes");
INSERT INTO `wp_options` VALUES("863", "bsf_last_update_check", "1764968642", "yes");
INSERT INTO `wp_options` VALUES("250", "gform_version_info", "a:12:{s:12:\"is_valid_key\";b:1;s:6:\"reason\";s:0:\"\";s:7:\"version\";s:8:\"2.9.23.2\";s:3:\"url\";s:188:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/releases/gravityforms_2.9.23.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=ByjMVG79quLdPf7I86s0XF40Ou8%3D\";s:15:\"expiration_time\";i:1775750400;s:9:\"offerings\";a:72:{s:12:\"gravityforms\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:8:\"2.9.23.2\";s:14:\"version_latest\";s:8:\"2.9.23.2\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:188:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/releases/gravityforms_2.9.23.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=ByjMVG79quLdPf7I86s0XF40Ou8%3D\";s:10:\"url_latest\";s:188:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/releases/gravityforms_2.9.23.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=ByjMVG79quLdPf7I86s0XF40Ou8%3D\";}s:10:\"gravitycrm\";a:4:{s:12:\"is_available\";b:0;s:7:\"version\";s:0:\"\";s:14:\"version_latest\";s:0:\"\";s:20:\"minimum_requirements\";a:0:{}}s:21:\"gravityforms2checkout\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.4.0\";s:14:\"version_latest\";s:5:\"2.4.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/2checkout/gravityforms2checkout_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=%2B0irUHI9A3enqCf3axGCdfydlak%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/2checkout/gravityforms2checkout_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=%2B0irUHI9A3enqCf3axGCdfydlak%3D\";}s:26:\"gravityformsactivecampaign\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.2.0\";s:14:\"version_latest\";s:5:\"2.2.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:216:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/activecampaign/gravityformsactivecampaign_2.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=8S3S7%2FnRtAmu%2BUAPAkszVpKf4fI%3D\";s:10:\"url_latest\";s:216:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/activecampaign/gravityformsactivecampaign_2.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=8S3S7%2FnRtAmu%2BUAPAkszVpKf4fI%3D\";}s:32:\"gravityformsadvancedpostcreation\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.5.0\";s:14:\"version_latest\";s:5:\"1.5.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:224:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/advancedpostcreation/gravityformsadvancedpostcreation_1.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=bACHiESo8hvfvtW3VtLN6TE7X1Y%3D\";s:10:\"url_latest\";s:224:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/advancedpostcreation/gravityformsadvancedpostcreation_1.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=bACHiESo8hvfvtW3VtLN6TE7X1Y%3D\";}s:20:\"gravityformsagilecrm\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.6.0\";s:14:\"version_latest\";s:5:\"1.6.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/agilecrm/gravityformsagilecrm_1.6.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=bBDaGA6DQPrSUiu6cuyREhf5PQI%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/agilecrm/gravityformsagilecrm_1.6.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=bBDaGA6DQPrSUiu6cuyREhf5PQI%3D\";}s:19:\"gravityformsakismet\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.1.0\";s:14:\"version_latest\";s:5:\"1.1.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/akismet/gravityformsakismet_1.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=ehSYK4XeGwQ2TNffF%2BxMcuO62Ng%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/akismet/gravityformsakismet_1.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=ehSYK4XeGwQ2TNffF%2BxMcuO62Ng%3D\";}s:24:\"gravityformsauthorizenet\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:4:\"2.11\";s:14:\"version_latest\";s:4:\"2.11\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:207:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/authorizenet/gravityformsauthorizenet_2.11.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=sGa8xv51cbs169dYpS5KZdT9Zxs%3D\";s:10:\"url_latest\";s:207:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/authorizenet/gravityformsauthorizenet_2.11.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=sGa8xv51cbs169dYpS5KZdT9Zxs%3D\";}s:18:\"gravityformsaweber\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.2.0\";s:14:\"version_latest\";s:5:\"4.2.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/aweber/gravityformsaweber_4.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=cNgP3O4uW0ftmuh58Gan6mrA3J4%3D\";s:10:\"url_latest\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/aweber/gravityformsaweber_4.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=cNgP3O4uW0ftmuh58Gan6mrA3J4%3D\";}s:21:\"gravityformsbatchbook\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.3\";s:14:\"version_latest\";s:3:\"1.3\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/batchbook/gravityformsbatchbook_1.3.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=iSC3zN9h8bvi352erF6ZH3RsKcU%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/batchbook/gravityformsbatchbook_1.3.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=iSC3zN9h8bvi352erF6ZH3RsKcU%3D\";}s:18:\"gravityformsbreeze\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.7.0\";s:14:\"version_latest\";s:5:\"1.7.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/breeze/gravityformsbreeze_1.7.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=OsNxk5m4DcpELsgHhvP80N3%2F5Zs%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/breeze/gravityformsbreeze_1.7.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=OsNxk5m4DcpELsgHhvP80N3%2F5Zs%3D\";}s:17:\"gravityformsbrevo\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.0.0\";s:14:\"version_latest\";s:5:\"1.0.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/brevo/gravityformsbrevo_1.0.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=KlBWlLAEv4d871UJbHbiFJmYdxI%3D\";s:10:\"url_latest\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/brevo/gravityformsbrevo_1.0.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=KlBWlLAEv4d871UJbHbiFJmYdxI%3D\";}s:27:\"gravityformscampaignmonitor\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.1.0\";s:14:\"version_latest\";s:5:\"4.1.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:214:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/campaignmonitor/gravityformscampaignmonitor_4.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=ciSmpZoppCshQdHXHF9rFwRjTac%3D\";s:10:\"url_latest\";s:214:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/campaignmonitor/gravityformscampaignmonitor_4.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=ciSmpZoppCshQdHXHF9rFwRjTac%3D\";}s:20:\"gravityformscampfire\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.1\";s:14:\"version_latest\";s:5:\"1.2.2\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/campfire/gravityformscampfire_1.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=DATb01lTbnD32EUM7i1QLVjJh%2FE%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/campfire/gravityformscampfire_1.2.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=X8Dk1lLU1rPaFxs9i1ElnxLpSlM%3D\";}s:22:\"gravityformscapsulecrm\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/capsulecrm/gravityformscapsulecrm_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=1ONO4UuH47xMI%2FFWpU9t0RU4i2w%3D\";s:10:\"url_latest\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/capsulecrm/gravityformscapsulecrm_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=1ONO4UuH47xMI%2FFWpU9t0RU4i2w%3D\";}s:26:\"gravityformschainedselects\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:214:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/chainedselects/gravityformschainedselects_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=f5rCuINqkT%2BYgidTxjbJVzOtUYU%3D\";s:10:\"url_latest\";s:214:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/chainedselects/gravityformschainedselects_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=f5rCuINqkT%2BYgidTxjbJVzOtUYU%3D\";}s:23:\"gravityformscleverreach\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.9.0\";s:14:\"version_latest\";s:5:\"1.9.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/cleverreach/gravityformscleverreach_1.9.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=8rJiFDMvKdcson5ZLGRLiK6rjSY%3D\";s:10:\"url_latest\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/cleverreach/gravityformscleverreach_1.9.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=8rJiFDMvKdcson5ZLGRLiK6rjSY%3D\";}s:15:\"gravityformscli\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:0:\"\";s:14:\"version_latest\";s:3:\"1.7\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:0:\"\";s:10:\"url_latest\";s:190:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/cli/gravityformscli_1.7.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=cO%2F9Dz0zSKNKzWkhV4AG7vWXND4%3D\";}s:27:\"gravityformsconstantcontact\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:216:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/constantcontact/gravityformsconstantcontact_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=eXiU%2Bp3PXe0UwmLGkQQhmWzJvs4%3D\";s:10:\"url_latest\";s:216:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/constantcontact/gravityformsconstantcontact_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=eXiU%2Bp3PXe0UwmLGkQQhmWzJvs4%3D\";}s:31:\"gravityformsconversationalforms\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.6.0\";s:14:\"version_latest\";s:5:\"1.6.3\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:224:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/conversationalforms/gravityformsconversationalforms_1.6.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=n2pRb3j%2FlJlpDDAjTtbXMjTeaQc%3D\";s:10:\"url_latest\";s:224:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/conversationalforms/gravityformsconversationalforms_1.6.3.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=yoQCY66YVvP%2FXTx4cnOGDDVahWs%3D\";}s:22:\"gravityformsconvertkit\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.2.0\";s:14:\"version_latest\";s:5:\"1.2.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/convertkit/gravityformsconvertkit_1.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=uJrN3uv4jVLg7Wkphgss62QRMQ0%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/convertkit/gravityformsconvertkit_1.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=uJrN3uv4jVLg7Wkphgss62QRMQ0%3D\";}s:19:\"gravityformscoupons\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"3.5.0\";s:14:\"version_latest\";s:5:\"3.5.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/coupons/gravityformscoupons_3.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=Y3CUMZSR%2B5bRxK33MBUDrO0G5ns%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/coupons/gravityformscoupons_3.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=Y3CUMZSR%2B5bRxK33MBUDrO0G5ns%3D\";}s:17:\"gravityformsdebug\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:0:\"\";s:14:\"version_latest\";s:10:\"1.0.beta12\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:0:\"\";s:10:\"url_latest\";s:201:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/debug/gravityformsdebug_1.0.beta12.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=pZSBNzhZamzvo8jrMFeKHAx%2BFg0%3D\";}s:19:\"gravityformsdropbox\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"3.3.0\";s:14:\"version_latest\";s:7:\"3.3.0.2\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/dropbox/gravityformsdropbox_3.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=UI2B7wuNGB%2BZzA4Ko%2Bcn%2B%2BVUzKs%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/dropbox/gravityformsdropbox_3.3.0.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=olX0HPRAB1efjH2hPUJ%2FRt74Dx4%3D\";}s:24:\"gravityformsemailoctopus\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.4.0\";s:14:\"version_latest\";s:5:\"1.4.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:210:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/emailoctopus/gravityformsemailoctopus_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=EP8Jjiew76ThWMCoNok%2F6RvciPU%3D\";s:10:\"url_latest\";s:210:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/emailoctopus/gravityformsemailoctopus_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=EP8Jjiew76ThWMCoNok%2F6RvciPU%3D\";}s:16:\"gravityformsemma\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/emma/gravityformsemma_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=MYG4DMN5nTTNABqpoP%2FLs6rAveg%3D\";s:10:\"url_latest\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/emma/gravityformsemma_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=MYG4DMN5nTTNABqpoP%2FLs6rAveg%3D\";}s:22:\"gravityformsfreshbooks\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"2.8\";s:14:\"version_latest\";s:3:\"2.8\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/freshbooks/gravityformsfreshbooks_2.8.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=AGm65Tt%2Fl3cWwC9x8PUEVhW7JYc%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/freshbooks/gravityformsfreshbooks_2.8.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=AGm65Tt%2Fl3cWwC9x8PUEVhW7JYc%3D\";}s:23:\"gravityformsgeolocation\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.5.0\";s:14:\"version_latest\";s:5:\"1.5.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/geolocation/gravityformsgeolocation_1.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=0ZDT8tGAGyEy9j9o%2BjR2ZSaJIvs%3D\";s:10:\"url_latest\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/geolocation/gravityformsgeolocation_1.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=0ZDT8tGAGyEy9j9o%2BjR2ZSaJIvs%3D\";}s:23:\"gravityformsgetresponse\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.9.0\";s:14:\"version_latest\";s:5:\"1.9.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/getresponse/gravityformsgetresponse_1.9.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=aqBZmAWnwP5YOG%2Fvm37Sa6LdoNQ%3D\";s:10:\"url_latest\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/getresponse/gravityformsgetresponse_1.9.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=aqBZmAWnwP5YOG%2Fvm37Sa6LdoNQ%3D\";}s:27:\"gravityformsgoogleanalytics\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.4.0\";s:14:\"version_latest\";s:5:\"2.4.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:214:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/googleanalytics/gravityformsgoogleanalytics_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=xpbHin9fQgXqeVUT20hJFZOp82g%3D\";s:10:\"url_latest\";s:214:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/googleanalytics/gravityformsgoogleanalytics_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=xpbHin9fQgXqeVUT20hJFZOp82g%3D\";}s:21:\"gravityformsgutenberg\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:10:\"1.0-rc-1.4\";s:14:\"version_latest\";s:10:\"1.0-rc-1.5\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:207:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/gutenberg/gravityformsgutenberg_1.0-rc-1.4.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=ibueKgHVD1N41XELY62phiPcIb8%3D\";s:10:\"url_latest\";s:211:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/gutenberg/gravityformsgutenberg_1.0-rc-1.5.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=A%2BuxYdBUaU%2B4af6kgRWFDlAG1mA%3D\";}s:21:\"gravityformshelpscout\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.4.0\";s:14:\"version_latest\";s:7:\"2.4.0.2\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/helpscout/gravityformshelpscout_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=1I5X0lCMba1exGMlmlHWzDuZ9AM%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/helpscout/gravityformshelpscout_2.4.0.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=QCR9ox9nHQ7U9EnHdljk3hXNqSI%3D\";}s:20:\"gravityformshighrise\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.3\";s:14:\"version_latest\";s:3:\"1.3\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/highrise/gravityformshighrise_1.3.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=YXNmEEBUGaLo5atTSZ0nFkl6fnI%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/highrise/gravityformshighrise_1.3.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=YXNmEEBUGaLo5atTSZ0nFkl6fnI%3D\";}s:19:\"gravityformshipchat\";a:4:{s:12:\"is_available\";b:0;s:7:\"version\";s:3:\"1.2\";s:14:\"version_latest\";s:3:\"1.2\";s:20:\"minimum_requirements\";a:0:{}}s:19:\"gravityformshubspot\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.3.0\";s:14:\"version_latest\";s:5:\"2.3.2\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/hubspot/gravityformshubspot_2.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=e9unmZfRN0pXisgH%2BCO%2FATb91CI%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/hubspot/gravityformshubspot_2.3.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=46HqWwQ48jDQfrvmcbBso6YqT3w%3D\";}s:20:\"gravityformsicontact\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/icontact/gravityformsicontact_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=2vkgzKF2dt2vn9XXl8OvVcdGPzw%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/icontact/gravityformsicontact_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=2vkgzKF2dt2vn9XXl8OvVcdGPzw%3D\";}s:19:\"gravityformslogging\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.3\";s:14:\"version_latest\";s:5:\"1.3.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/logging/gravityformslogging_1.3.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=2uT3z3lg14mkzA4ZWlSrOCVCiH8%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/logging/gravityformslogging_1.3.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=7G2wVcC5w2UuL1HwAI1HKGGlBEo%3D\";}s:19:\"gravityformsmadmimi\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.5.0\";s:14:\"version_latest\";s:5:\"1.5.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/madmimi/gravityformsmadmimi_1.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=U8SIXlMNFb0f5ZJ5LI2h9c%2FCKbs%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/madmimi/gravityformsmadmimi_1.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=U8SIXlMNFb0f5ZJ5LI2h9c%2FCKbs%3D\";}s:21:\"gravityformsmailchimp\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"5.7.0\";s:14:\"version_latest\";s:5:\"5.7.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mailchimp/gravityformsmailchimp_5.7.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=3NY7ygmcHbBGTlXqEhGRBzRs2BI%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mailchimp/gravityformsmailchimp_5.7.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=T0q5dKqdlADeFKVM9JrivosG%2F1c%3D\";}s:22:\"gravityformsmailerlite\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.1.0\";s:14:\"version_latest\";s:5:\"1.1.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mailerlite/gravityformsmailerlite_1.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=%2FjUP1XDPEB8MbPgT6mQmfJM4B%2FM%3D\";s:10:\"url_latest\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mailerlite/gravityformsmailerlite_1.1.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=m0ajDqCPk%2BhPRlzJofJJlY0s7Cs%3D\";}s:19:\"gravityformsmailgun\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.4.0\";s:14:\"version_latest\";s:5:\"1.4.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mailgun/gravityformsmailgun_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=TpC1HC68TUWZ02Wtrv%2Fg5w%2FZKck%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mailgun/gravityformsmailgun_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=TpC1HC68TUWZ02Wtrv%2Fg5w%2FZKck%3D\";}s:22:\"gravityformsmoderation\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.3.0\";s:14:\"version_latest\";s:5:\"1.3.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/moderation/gravityformsmoderation_1.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=snE%2BUjoM3zOHLDecg%2FgDYYLJjzc%3D\";s:10:\"url_latest\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/moderation/gravityformsmoderation_1.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=snE%2BUjoM3zOHLDecg%2FgDYYLJjzc%3D\";}s:18:\"gravityformsmollie\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mollie/gravityformsmollie_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=%2FkalbVyvR2ES4%2BlcnenuU0jQlCM%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mollie/gravityformsmollie_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=%2FkalbVyvR2ES4%2BlcnenuU0jQlCM%3D\";}s:26:\"gravityformspartialentries\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:216:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/partialentries/gravityformspartialentries_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=vc0bD4rucFQ%2BBvdbmEhrXzpe%2Fnc%3D\";s:10:\"url_latest\";s:214:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/partialentries/gravityformspartialentries_1.8.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=h%2BjAYRY9YNsJ7U0uZGBE7Vj8QDg%3D\";}s:18:\"gravityformspaypal\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"3.5\";s:14:\"version_latest\";s:3:\"3.5\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/paypal/gravityformspaypal_3.5.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=V%2F1yt8gxnl0ufjmjT9FZ4m2C2DM%3D\";s:10:\"url_latest\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/paypal/gravityformspaypal_3.5.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=V%2F1yt8gxnl0ufjmjT9FZ4m2C2DM%3D\";}s:33:\"gravityformspaypalexpresscheckout\";a:3:{s:12:\"is_available\";b:0;s:7:\"version\";s:0:\"\";s:14:\"version_latest\";s:0:\"\";}s:29:\"gravityformspaypalpaymentspro\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"2.7\";s:14:\"version_latest\";s:3:\"2.7\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:216:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/paypalpaymentspro/gravityformspaypalpaymentspro_2.7.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=HMDmCffCWgJQDPvSt41UhRTzjRc%3D\";s:10:\"url_latest\";s:216:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/paypalpaymentspro/gravityformspaypalpaymentspro_2.7.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=HMDmCffCWgJQDPvSt41UhRTzjRc%3D\";}s:21:\"gravityformspaypalpro\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.1\";s:14:\"version_latest\";s:5:\"1.8.4\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/paypalpro/gravityformspaypalpro_1.8.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=lhUtUVVA9V0VZrzj8movv%2FIvvaE%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/paypalpro/gravityformspaypalpro_1.8.4.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=bC2CXBf%2FsVbFa6QbDCAud2whpqw%3D\";}s:20:\"gravityformspicatcha\";a:4:{s:12:\"is_available\";b:0;s:7:\"version\";s:3:\"2.0\";s:14:\"version_latest\";s:3:\"2.0\";s:20:\"minimum_requirements\";a:0:{}}s:16:\"gravityformspipe\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.4.0\";s:14:\"version_latest\";s:5:\"1.4.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/pipe/gravityformspipe_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=JdKVPggMS37vnRJfg4V%2FeOax5mg%3D\";s:10:\"url_latest\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/pipe/gravityformspipe_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=JdKVPggMS37vnRJfg4V%2FeOax5mg%3D\";}s:17:\"gravityformspolls\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.4.0\";s:14:\"version_latest\";s:5:\"4.4.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/polls/gravityformspolls_4.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=CVDWJdgyG%2Bj%2B9ptzKES9jBsy0ZE%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/polls/gravityformspolls_4.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=CVDWJdgyG%2Bj%2B9ptzKES9jBsy0ZE%3D\";}s:20:\"gravityformspostmark\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.4.0\";s:14:\"version_latest\";s:5:\"1.4.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/postmark/gravityformspostmark_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=43q0BTyonE2ZtyNrOhKUnPJCkqM%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/postmark/gravityformspostmark_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=43q0BTyonE2ZtyNrOhKUnPJCkqM%3D\";}s:16:\"gravityformsppcp\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.0.0\";s:14:\"version_latest\";s:7:\"4.0.0.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:192:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/ppcp/gravityformsppcp_4.0.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=rb1K2KWIvzHpifr3RU3mYF4lLAI%3D\";s:10:\"url_latest\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/ppcp/gravityformsppcp_4.0.0.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=E7Yc9fzzYaMJMcFJjHWZzf1Ylqk%3D\";}s:16:\"gravityformsquiz\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.3.0\";s:14:\"version_latest\";s:5:\"4.3.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/quiz/gravityformsquiz_4.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=kK%2FjiHIqOY0qN%2BIwJDdJdusTs1w%3D\";s:10:\"url_latest\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/quiz/gravityformsquiz_4.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=kK%2FjiHIqOY0qN%2BIwJDdJdusTs1w%3D\";}s:21:\"gravityformsrecaptcha\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.1.0\";s:14:\"version_latest\";s:5:\"2.1.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/recaptcha/gravityformsrecaptcha_2.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=w8At4gP4876MjS8TYuLZcWtqNOM%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/recaptcha/gravityformsrecaptcha_2.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=w8At4gP4876MjS8TYuLZcWtqNOM%3D\";}s:19:\"gravityformsrestapi\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:10:\"2.0-beta-2\";s:14:\"version_latest\";s:10:\"2.0-beta-2\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:203:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/restapi/gravityformsrestapi_2.0-beta-2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=kLVbQBAShbExtFRbj4lgdDD6gys%3D\";s:10:\"url_latest\";s:203:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/restapi/gravityformsrestapi_2.0-beta-2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=kLVbQBAShbExtFRbj4lgdDD6gys%3D\";}s:22:\"gravityformssalesforce\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.1.0\";s:14:\"version_latest\";s:5:\"1.1.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/salesforce/gravityformssalesforce_1.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=paZBZSvDj3DXtVwMx2F7Egz1urs%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/salesforce/gravityformssalesforce_1.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=paZBZSvDj3DXtVwMx2F7Egz1urs%3D\";}s:20:\"gravityformssendgrid\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.6.0\";s:14:\"version_latest\";s:5:\"1.6.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/sendgrid/gravityformssendgrid_1.6.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=gFwToa5o0LzSX%2FD%2B33xUtF3V3aU%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/sendgrid/gravityformssendgrid_1.6.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=gFwToa5o0LzSX%2FD%2B33xUtF3V3aU%3D\";}s:21:\"gravityformssignature\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.9.0\";s:14:\"version_latest\";s:5:\"4.9.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/signature/gravityformssignature_4.9.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=yvzqwYEwgENv8300FrmrThcNzDU%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/signature/gravityformssignature_4.9.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=1IlyLShYYudZ%2BCuDtI0GAR7pbT0%3D\";}s:17:\"gravityformsslack\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.2.0\";s:14:\"version_latest\";s:5:\"2.2.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/slack/gravityformsslack_2.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=B%2Fxn0557kMtH6VqG9ea9gOwAAqM%3D\";s:10:\"url_latest\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/slack/gravityformsslack_2.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=B%2Fxn0557kMtH6VqG9ea9gOwAAqM%3D\";}s:18:\"gravityformssquare\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.5.0\";s:14:\"version_latest\";s:5:\"2.5.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/square/gravityformssquare_2.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=s5GJZRcbo286iFmNi2oMvE0r%2Fz8%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/square/gravityformssquare_2.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=s5GJZRcbo286iFmNi2oMvE0r%2Fz8%3D\";}s:18:\"gravityformsstripe\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:7:\"6.0.1.0\";s:14:\"version_latest\";s:7:\"6.0.1.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/stripe/gravityformsstripe_6.0.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=y7AAhrWWbXvCHfNvEOWIn0uPGjw%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/stripe/gravityformsstripe_6.0.1.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=szAjbg1uwnlfCO6DgTnDWqltzmg%3D\";}s:18:\"gravityformssurvey\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.2.1\";s:14:\"version_latest\";s:5:\"4.2.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/survey/gravityformssurvey_4.2.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=gofeLllSoFNx657mQPiRoSEfbz8%3D\";s:10:\"url_latest\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/survey/gravityformssurvey_4.2.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=gofeLllSoFNx657mQPiRoSEfbz8%3D\";}s:18:\"gravityformstrello\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.2.0\";s:14:\"version_latest\";s:7:\"2.2.0.2\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/trello/gravityformstrello_2.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=xUdgb2awFN6HVmH2T3frvAlnotw%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/trello/gravityformstrello_2.2.0.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=qPSrBummWHw3Lh%2FrlLS%2F7avCRFQ%3D\";}s:21:\"gravityformsturnstile\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.4.0\";s:14:\"version_latest\";s:5:\"1.4.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/turnstile/gravityformsturnstile_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=PCzltXAY65yB4xVAgHJR68VLeUM%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/turnstile/gravityformsturnstile_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=PCzltXAY65yB4xVAgHJR68VLeUM%3D\";}s:18:\"gravityformstwilio\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"3.1.0\";s:14:\"version_latest\";s:5:\"3.1.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/twilio/gravityformstwilio_3.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=WjIJOPzPNGqZUkcifBJMaYViORI%3D\";s:10:\"url_latest\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/twilio/gravityformstwilio_3.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=WjIJOPzPNGqZUkcifBJMaYViORI%3D\";}s:28:\"gravityformsuserregistration\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"5.4.0\";s:14:\"version_latest\";s:5:\"5.4.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:216:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/userregistration/gravityformsuserregistration_5.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=T0rbRWRo18lz9jAawlmMtCM0b1Q%3D\";s:10:\"url_latest\";s:216:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/userregistration/gravityformsuserregistration_5.4.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=1rnpSezBnb15vlQqFuh32E2W7dk%3D\";}s:20:\"gravityformswebhooks\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.7.0\";s:14:\"version_latest\";s:5:\"1.7.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/webhooks/gravityformswebhooks_1.7.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=DhZW3xdUf6mjg03nBDo2dWXfbA4%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/webhooks/gravityformswebhooks_1.7.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=DhZW3xdUf6mjg03nBDo2dWXfbA4%3D\";}s:18:\"gravityformszapier\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.5.1\";s:14:\"version_latest\";s:5:\"4.5.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/zapier/gravityformszapier_4.5.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=RH1EmfxvxdyYjEkoxRXFY%2F4hg4Y%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/zapier/gravityformszapier_4.5.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=RH1EmfxvxdyYjEkoxRXFY%2F4hg4Y%3D\";}s:19:\"gravityformszohocrm\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.4.0\";s:14:\"version_latest\";s:7:\"2.4.0.2\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/zohocrm/gravityformszohocrm_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=Z4uE3rPKgFI4II96Whv2tWqh92o%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/zohocrm/gravityformszohocrm_2.4.0.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=6n7M%2FNpSAlR6kL5fChRdEVcviPk%3D\";}s:11:\"gravitysmtp\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.1.1\";s:14:\"version_latest\";s:5:\"2.1.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:185:\"https://s3.dualstack.us-east-1.amazonaws.com/gravitysmtp/releases/gravitysmtp_2.1.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=RP%2FqzXYuPKOo3zlg4hl5jNItDhk%3D\";s:10:\"url_latest\";s:185:\"https://s3.dualstack.us-east-1.amazonaws.com/gravitysmtp/releases/gravitysmtp_2.1.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=RP%2FqzXYuPKOo3zlg4hl5jNItDhk%3D\";}s:7:\"testing\";a:4:{s:12:\"is_available\";b:0;s:7:\"version\";s:0:\"\";s:14:\"version_latest\";s:5:\"1.www\";s:20:\"minimum_requirements\";a:0:{}}}s:9:\"is_active\";s:1:\"1\";s:12:\"product_code\";s:5:\"GFDEV\";s:12:\"date_created\";s:19:\"2012-03-05 16:47:11\";s:14:\"version_latest\";s:8:\"2.9.23.2\";s:10:\"url_latest\";s:188:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/releases/gravityforms_2.9.23.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1765096027&Signature=ByjMVG79quLdPf7I86s0XF40Ou8%3D\";s:9:\"timestamp\";i:1764923227;}", "off");
INSERT INTO `wp_options` VALUES("1062", "elementor_active_kit", "22", "yes");
INSERT INTO `wp_options` VALUES("1063", "elementor_install_history", "a:66:{s:6:\"3.0.10\";i:1614722631;s:6:\"3.0.12\";i:1603748585;s:6:\"3.0.13\";i:1605302984;s:6:\"3.0.14\";i:1606778749;s:6:\"3.0.16\";i:1611161360;s:5:\"3.1.1\";i:1613170707;s:5:\"3.1.2\";i:1614722632;s:5:\"3.1.4\";i:1616692771;s:5:\"3.2.1\";i:1628800172;s:5:\"3.3.1\";i:1628800173;s:5:\"3.3.6\";i:1630108271;s:5:\"3.3.8\";i:1638378444;s:5:\"3.4.2\";i:1630108273;s:5:\"3.4.4\";i:1631921127;s:5:\"3.4.8\";i:1638378445;s:5:\"3.5.2\";i:1644941539;s:5:\"3.5.3\";i:1642525325;s:5:\"3.5.5\";i:1644941540;s:5:\"3.5.6\";i:1647889594;s:5:\"3.6.1\";i:1648142343;s:5:\"3.6.2\";i:1649791136;s:5:\"3.6.4\";i:1652482009;s:5:\"3.6.5\";i:1652482010;s:5:\"3.6.6\";i:1655765565;s:5:\"3.7.0\";i:1654708840;s:5:\"3.7.1\";i:1655765564;s:5:\"3.7.2\";i:1661295779;s:5:\"3.7.3\";i:1662508398;s:5:\"3.7.4\";i:1662508399;s:5:\"3.7.5\";i:1663178826;s:5:\"3.7.6\";i:1674581444;s:5:\"3.7.7\";i:1674581445;s:6:\"3.10.1\";i:1674582749;s:6:\"3.10.2\";i:1679002482;s:6:\"3.11.5\";i:1679002634;s:6:\"3.11.6\";i:1683240238;s:6:\"3.12.2\";i:1683240240;s:6:\"3.12.3\";i:1685559258;s:6:\"3.13.2\";i:1687384899;s:6:\"3.13.4\";i:1685559259;s:6:\"3.14.0\";i:1687384901;s:6:\"3.15.1\";i:1694538207;s:6:\"3.15.3\";i:1693348388;s:6:\"3.16.0\";i:1694538209;s:6:\"3.16.4\";i:1695679381;s:6:\"3.20.1\";i:1710441794;s:6:\"3.20.3\";i:1712008883;s:6:\"3.21.5\";i:1715901594;s:6:\"3.21.8\";i:1716920441;s:6:\"3.23.4\";i:1723135115;s:7:\"3.25.10\";i:1732570946;s:6:\"3.26.3\";i:1735837280;s:6:\"3.26.4\";i:1737128300;s:6:\"3.26.5\";i:1737128334;s:6:\"3.27.2\";i:1738347868;s:6:\"3.27.6\";i:1741023411;s:6:\"3.28.0\";i:1742574839;s:6:\"3.28.1\";i:1743260616;s:6:\"3.28.3\";i:1743611940;s:6:\"3.28.4\";i:1747325095;s:6:\"3.29.1\";i:1748899671;s:6:\"3.31.2\";i:1755296402;s:6:\"3.31.3\";i:1757094862;s:6:\"3.32.1\";i:1758146771;s:6:\"3.32.4\";i:1760130970;s:6:\"3.33.3\";i:1764968715;}", "yes");
INSERT INTO `wp_options` VALUES("3640", "gf_rest_api_db_version", "2.9.23.2", "yes");
INSERT INTO `wp_options` VALUES("185", "elementor_remote_info_feed_data", "a:3:{i:0;a:5:{s:5:\"title\";s:76:\"Introducing Elementor 3.32: Transitions, Transform, Size Variables, and More\";s:7:\"excerpt\";s:250:\"Elementor 3.32 is here, accelerating Editor V4 Alpha with transform controls and layered transitions, system-wide Size Variables and streamlined class management. This release empowers you to build more consistent, dynamic, and professional websites.\";s:7:\"created\";i:1759243152;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:138:\"https://elementor.com/blog/elementor-332-v4-transform-transitions/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:1;a:5:{s:5:\"title\";s:70:\"Introducing Elementor 3.31: New Editor V4 Variables, Filters, and More\";s:7:\"excerpt\";s:294:\"Elementor 3.31 is here, pushing Editor V4 forward with powerful design system enhancements and modern visual styling tools. From Variables and Filters to smarter editing workflows and semantic markup, this version makes it easier than ever to design beautiful, performant, and accessible sites.\";s:7:\"created\";i:1755094220;s:5:\"badge\";s:3:\"NEW\";s:3:\"url\";s:140:\"https://elementor.com/blog/elementor-331-v4-alpha-variables-filters/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}i:2;a:5:{s:5:\"title\";s:67:\"What Is an MCP? The AI Breakthrough Web Creators Shouldn’t Ignore\";s:7:\"excerpt\";s:143:\"Discover how Model Context Protocol (MCP) is shaping AI-tool interaction and redefining how pro web creators build, manage, and scale websites.\";s:7:\"created\";i:1754310811;s:5:\"badge\";s:0:\"\";s:3:\"url\";s:130:\"https://elementor.com/blog/mcp-explained-for-web-creators/?utm_source=wp-overview-widget&utm_medium=wp-dash&utm_campaign=news-feed\";}}", "off");
INSERT INTO `wp_options` VALUES("190", "elementor_pro_version", "3.31.2", "yes");
INSERT INTO `wp_options` VALUES("191", "widget_elementor-library", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("192", "_elementor_pro_installed_time", "1580417744", "yes");
INSERT INTO `wp_options` VALUES("235", "astra_parent_page_url", "http://stage.myliquis.co/astra-theme/wp-admin/edit.php?post_type=astra-portfolio&#038;page=astra-portfolio&#038;action=general", "yes");
INSERT INTO `wp_options` VALUES("193", "elementor_connect_site_key", "a644686b77ce04136a33df3643e4d488", "yes");
INSERT INTO `wp_options` VALUES("194", "elementor_allow_tracking", "yes", "yes");
INSERT INTO `wp_options` VALUES("195", "elementor_tracker_last_send", "1764836720", "yes");
INSERT INTO `wp_options` VALUES("196", "elementor_pro_license_key", "e66ec99597a1897bd232112cd9511241", "yes");
INSERT INTO `wp_options` VALUES("1268", "astra_sites_import_data", "a:42:{s:2:\"id\";i:34012;s:4:\"date\";s:19:\"2019-10-14T12:23:15\";s:8:\"date_gmt\";s:19:\"2019-10-14T06:53:15\";s:4:\"guid\";a:1:{s:8:\"rendered\";s:60:\"https://websitedemos.net/?post_type=astra-sites&#038;p=34012\";}s:8:\"modified\";s:19:\"2020-06-25T16:03:12\";s:12:\"modified_gmt\";s:19:\"2020-06-25T10:33:12\";s:4:\"slug\";s:10:\"pet-care-2\";s:6:\"status\";s:7:\"publish\";s:4:\"type\";s:11:\"astra-sites\";s:4:\"link\";s:47:\"https://websitedemos.net/astra-site/pet-care-2/\";s:5:\"title\";a:1:{s:8:\"rendered\";s:8:\"Pet Care\";}s:7:\"content\";a:2:{s:8:\"rendered\";s:0:\"\";s:9:\"protected\";b:0;}s:6:\"author\";i:34;s:14:\"featured_media\";i:43662;s:8:\"template\";s:0:\"\";s:19:\"astra-site-category\";a:1:{i:0;i:27;}s:16:\"astra-sites-type\";a:1:{i:0;i:40;}s:23:\"astra-site-page-builder\";a:1:{i:0;i:33;}s:15:\"astra-sites-tag\";a:5:{i:0;i:1021;i:1;i:374;i:2;i:372;i:3;i:371;i:4;i:373;}s:10:\"yoast_head\";s:2372:\"<!-- This site is optimized with the Yoast SEO plugin v15.2.1 - https://yoast.com/wordpress/plugins/seo/ -->\n<title>Pet Care - Website Demos</title>\n<meta name=\"robots\" content=\"index, follow, max-snippet:-1, max-image-preview:large, max-video-preview:-1\" />\n<link rel=\"canonical\" href=\"https://websitedemos.net/astra-site/pet-care-2/\" />\n<meta property=\"og:locale\" content=\"en_US\" />\n<meta property=\"og:type\" content=\"article\" />\n<meta property=\"og:title\" content=\"Pet Care - Website Demos\" />\n<meta property=\"og:url\" content=\"https://websitedemos.net/astra-site/pet-care-2/\" />\n<meta property=\"og:site_name\" content=\"Website Demos\" />\n<meta property=\"article:author\" content=\"rishabhm\" />\n<meta property=\"article:modified_time\" content=\"2020-06-25T10:33:12+00:00\" />\n<meta property=\"og:image\" content=\"https://websitedemos.net/wp-content/uploads/2020/01/pet-care-home.jpg\" />\n	<meta property=\"og:image:width\" content=\"1200\" />\n	<meta property=\"og:image:height\" content=\"5594\" />\n<meta name=\"twitter:card\" content=\"summary\" />\n<meta name=\"twitter:label1\" content=\"Written by\">\n	<meta name=\"twitter:data1\" content=\"rishabhm\">\n<script type=\"application/ld+json\" class=\"yoast-schema-graph\">{\"@context\":\"https://schema.org\",\"@graph\":[{\"@type\":\"WebSite\",\"@id\":\"https://websitedemos.net/#website\",\"url\":\"https://websitedemos.net/\",\"name\":\"Website Demos\",\"description\":\"The Fastest, Lightweight Ready Websites\",\"potentialAction\":[{\"@type\":\"SearchAction\",\"target\":\"https://websitedemos.net/?s={search_term_string}\",\"query-input\":\"required name=search_term_string\"}],\"inLanguage\":\"en-US\"},{\"@type\":\"ImageObject\",\"@id\":\"https://websitedemos.net/astra-site/pet-care-2/#primaryimage\",\"inLanguage\":\"en-US\",\"url\":\"https://websitedemos.net/wp-content/uploads/2020/01/pet-care-home.jpg\",\"width\":1200,\"height\":5594},{\"@type\":\"WebPage\",\"@id\":\"https://websitedemos.net/astra-site/pet-care-2/#webpage\",\"url\":\"https://websitedemos.net/astra-site/pet-care-2/\",\"name\":\"Pet Care - Website Demos\",\"isPartOf\":{\"@id\":\"https://websitedemos.net/#website\"},\"primaryImageOfPage\":{\"@id\":\"https://websitedemos.net/astra-site/pet-care-2/#primaryimage\"},\"datePublished\":\"2019-10-14T06:53:15+00:00\",\"dateModified\":\"2020-06-25T10:33:12+00:00\",\"inLanguage\":\"en-US\",\"potentialAction\":[{\"@type\":\"ReadAction\",\"target\":[\"https://websitedemos.net/astra-site/pet-care-2/\"]}]}]}</script>\n<!-- / Yoast SEO plugin. -->\";s:15:\"astra-site-type\";s:7:\"premium\";s:20:\"astra-site-thumbnail\";s:78:\"https://websitedemos.net/wp-content/uploads/2020/01/pet-care-home-400x1865.jpg\";s:16:\"required-plugins\";a:4:{i:0;a:3:{s:4:\"slug\";s:9:\"elementor\";s:4:\"init\";s:23:\"elementor/elementor.php\";s:4:\"name\";s:9:\"Elementor\";}i:1;a:3:{s:4:\"slug\";s:23:\"header-footer-elementor\";s:4:\"init\";s:51:\"header-footer-elementor/header-footer-elementor.php\";s:4:\"name\";s:35:\"Elementor - Header, Footer & Blocks\";}i:2;a:3:{s:4:\"slug\";s:18:\"ultimate-elementor\";s:4:\"init\";s:41:\"ultimate-elementor/ultimate-elementor.php\";s:4:\"name\";s:29:\"Ultimate Addons for Elementor\";}i:3;a:3:{s:4:\"slug\";s:12:\"wpforms-lite\";s:4:\"init\";s:24:\"wpforms-lite/wpforms.php\";s:4:\"name\";s:12:\"WPForms Lite\";}}s:14:\"astra-site-url\";s:30:\"//websitedemos.net/pet-care-04\";s:26:\"astra-site-open-in-new-tab\";s:1:\"0\";s:23:\"astra-site-widgets-data\";s:197:\"{\"sidebar-1\":{\"search-2\":{\"title\":\"\"},\"recent-posts-2\":{\"title\":\"\",\"number\":5},\"archives-2\":{\"title\":\"\",\"count\":0,\"dropdown\":0},\"categories-2\":{\"title\":\"\",\"count\":0,\"hierarchical\":0,\"dropdown\":0}}}\";s:26:\"astra-site-customizer-data\";a:2:{s:14:\"astra-settings\";a:249:{s:26:\"blog-single-post-structure\";a:2:{i:0;s:12:\"single-image\";i:1;s:17:\"single-title-meta\";}s:17:\"blog-single-width\";s:6:\"custom\";s:21:\"blog-single-max-width\";i:1000;s:16:\"blog-single-meta\";a:3:{i:0;s:8:\"comments\";i:1;s:8:\"category\";i:2;s:6:\"author\";}s:19:\"blog-post-structure\";a:2:{i:0;s:5:\"image\";i:1;s:10:\"title-meta\";}s:10:\"blog-width\";s:7:\"default\";s:14:\"blog-max-width\";i:1200;s:17:\"blog-post-content\";s:7:\"excerpt\";s:9:\"blog-meta\";a:3:{i:0;s:8:\"comments\";i:1;s:8:\"category\";i:2;s:6:\"author\";}s:10:\"text-color\";s:7:\"#000823\";s:10:\"link-color\";s:7:\"#597c7a\";s:11:\"theme-color\";s:7:\"#597c7a\";s:12:\"link-h-color\";s:7:\"#000823\";s:24:\"footer-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:12:\"footer-color\";s:7:\"#000823\";s:17:\"footer-link-color\";s:17:\"rgba(0,8,35,0.74)\";s:19:\"footer-link-h-color\";s:7:\"#000823\";s:28:\"footer-adv-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:21:\"footer-adv-text-color\";s:0:\"\";s:21:\"footer-adv-link-color\";s:0:\"\";s:23:\"footer-adv-link-h-color\";s:0:\"\";s:26:\"footer-adv-wgt-title-color\";s:0:\"\";s:12:\"button-color\";s:7:\"#ffffff\";s:14:\"button-h-color\";s:7:\"#ffffff\";s:15:\"button-bg-color\";s:7:\"#597c7a\";s:17:\"button-bg-h-color\";s:7:\"#000000\";s:20:\"theme-button-padding\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"13\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"13\";s:4:\"left\";s:2:\"30\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:13:\"button-radius\";i:0;s:37:\"theme-button-border-group-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:17:\"footer-sml-layout\";s:19:\"footer-sml-layout-1\";s:20:\"footer-sml-section-1\";s:6:\"custom\";s:27:\"footer-sml-section-1-credit\";s:93:\"Copyright © [current_year] [site_title] | Powered by [site_title] | <a href=\"#\"\n>Credits</a>\";s:20:\"footer-sml-section-2\";s:0:\"\";s:27:\"footer-sml-section-2-credit\";s:72:\"Copyright &copy; [current_year] [site_title] | Powered by [theme_author]\";s:27:\"footer-sml-dist-equal-align\";b:1;s:18:\"footer-sml-divider\";i:0;s:24:\"footer-sml-divider-color\";s:7:\"#7a7a7a\";s:19:\"footer-layout-width\";s:7:\"content\";s:22:\"ast-header-retina-logo\";s:93:\"https://websitedemos.net/alex46/wp-content/uploads/sites/487/2019/08/logo-retina-free-img.png\";s:21:\"ast-header-logo-width\";s:0:\"\";s:32:\"ast-header-responsive-logo-width\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:18:\"display-site-title\";b:0;s:20:\"display-site-tagline\";i:0;s:17:\"logo-title-inline\";i:1;s:19:\"disable-primary-nav\";b:0;s:14:\"header-layouts\";s:20:\"header-main-layout-2\";s:22:\"header-main-rt-section\";s:4:\"none\";s:27:\"header-display-outside-menu\";b:0;s:27:\"header-main-rt-section-html\";s:27:\"<button>Contact Us</button>\";s:34:\"header-main-rt-section-button-text\";s:6:\"Button\";s:34:\"header-main-rt-section-button-link\";s:23:\"https://www.wpastra.com\";s:41:\"header-main-rt-section-button-link-option\";a:3:{s:3:\"url\";s:23:\"https://www.wpastra.com\";s:7:\"new_tab\";b:0;s:8:\"link_rel\";s:0:\"\";}s:35:\"header-main-rt-section-button-style\";s:12:\"theme-button\";s:40:\"header-main-rt-section-button-text-color\";s:0:\"\";s:40:\"header-main-rt-section-button-back-color\";s:0:\"\";s:42:\"header-main-rt-section-button-text-h-color\";s:0:\"\";s:42:\"header-main-rt-section-button-back-h-color\";s:0:\"\";s:37:\"header-main-rt-section-button-padding\";a:3:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}}s:41:\"header-main-rt-section-button-border-size\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:15:\"header-main-sep\";i:0;s:21:\"header-main-sep-color\";s:0:\"\";s:24:\"header-main-layout-width\";s:7:\"content\";s:22:\"primary-submenu-border\";a:4:{s:3:\"top\";s:1:\"2\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:27:\"primary-submenu-item-border\";b:0;s:23:\"primary-submenu-b-color\";s:0:\"\";s:28:\"primary-submenu-item-b-color\";s:7:\"#5e5e5e\";s:33:\"primary-header-button-font-family\";s:7:\"inherit\";s:33:\"primary-header-button-font-weight\";s:7:\"inherit\";s:31:\"primary-header-button-font-size\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:36:\"primary-header-button-text-transform\";s:0:\"\";s:33:\"primary-header-button-line-height\";i:1;s:36:\"primary-header-button-letter-spacing\";s:0:\"\";s:22:\"header-main-menu-label\";s:0:\"\";s:22:\"header-main-menu-align\";s:5:\"stack\";s:39:\"header-main-submenu-container-animation\";s:4:\"fade\";s:24:\"mobile-header-breakpoint\";s:0:\"\";s:18:\"mobile-header-logo\";s:0:\"\";s:24:\"mobile-header-logo-width\";s:0:\"\";s:11:\"site-layout\";s:21:\"ast-full-width-layout\";s:18:\"site-content-width\";i:1200;s:37:\"site-layout-outside-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:19:\"site-content-layout\";s:15:\"boxed-container\";s:26:\"single-page-content-layout\";s:7:\"default\";s:26:\"single-post-content-layout\";s:7:\"default\";s:27:\"archive-post-content-layout\";s:7:\"default\";s:16:\"body-font-family\";s:23:\"\'Open Sans\', sans-serif\";s:17:\"body-font-variant\";s:0:\"\";s:16:\"body-font-weight\";s:3:\"400\";s:14:\"font-size-body\";a:6:{s:7:\"desktop\";s:2:\"15\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:16:\"body-line-height\";s:0:\"\";s:18:\"para-margin-bottom\";s:0:\"\";s:19:\"body-text-transform\";s:0:\"\";s:20:\"headings-font-family\";s:24:\"\'Montserrat\', sans-serif\";s:20:\"headings-font-weight\";s:3:\"800\";s:23:\"headings-text-transform\";s:0:\"\";s:20:\"headings-line-height\";s:0:\"\";s:20:\"font-size-site-title\";a:6:{s:7:\"desktop\";i:35;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:22:\"font-size-site-tagline\";a:6:{s:7:\"desktop\";i:15;s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"font-size-entry-title\";a:6:{s:7:\"desktop\";s:2:\"28\";s:6:\"tablet\";s:2:\"24\";s:6:\"mobile\";s:2:\"15\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:31:\"font-size-archive-summary-title\";a:6:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"font-size-page-title\";a:6:{s:7:\"desktop\";s:2:\"26\";s:6:\"tablet\";s:2:\"20\";s:6:\"mobile\";s:2:\"16\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h1\";a:6:{s:7:\"desktop\";s:3:\"120\";s:6:\"tablet\";s:2:\"90\";s:6:\"mobile\";s:2:\"60\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h2\";a:6:{s:7:\"desktop\";s:3:\"110\";s:6:\"tablet\";s:2:\"60\";s:6:\"mobile\";s:2:\"40\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h3\";a:6:{s:7:\"desktop\";s:2:\"35\";s:6:\"tablet\";s:2:\"30\";s:6:\"mobile\";s:2:\"30\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h4\";a:6:{s:7:\"desktop\";s:2:\"26\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h5\";a:6:{s:7:\"desktop\";s:2:\"24\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:12:\"font-size-h6\";a:6:{s:7:\"desktop\";s:2:\"15\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:19:\"site-sidebar-layout\";s:10:\"no-sidebar\";s:18:\"site-sidebar-width\";i:30;s:26:\"single-page-sidebar-layout\";s:7:\"default\";s:26:\"single-post-sidebar-layout\";s:10:\"no-sidebar\";s:27:\"archive-post-sidebar-layout\";s:13:\"right-sidebar\";s:10:\"footer-adv\";s:8:\"disabled\";s:23:\"footer-adv-border-width\";s:0:\"\";s:23:\"footer-adv-border-color\";s:7:\"#7a7a7a\";s:30:\"mobile-header-toggle-btn-style\";s:4:\"fill\";s:23:\"hide-custom-menu-mobile\";i:1;s:27:\"mobile-header-toggle-target\";s:4:\"icon\";s:23:\"transparent-header-logo\";s:99:\"https://websitedemos.net/pet-care-04/wp-content/uploads/sites/487/2019/08/logo-regular-free-img.png\";s:30:\"transparent-header-retina-logo\";s:98:\"https://websitedemos.net/pet-care-04/wp-content/uploads/sites/487/2019/08/logo-retina-free-img.png\";s:26:\"different-transparent-logo\";b:1;s:33:\"different-transparent-retina-logo\";b:1;s:29:\"transparent-header-logo-width\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:25:\"transparent-header-enable\";i:0;s:34:\"transparent-header-disable-archive\";i:1;s:45:\"transparent-header-disable-latest-posts-index\";i:1;s:29:\"transparent-header-on-devices\";s:4:\"both\";s:27:\"transparent-header-main-sep\";i:0;s:33:\"transparent-header-main-sep-color\";s:0:\"\";s:27:\"transparent-header-bg-color\";s:0:\"\";s:35:\"transparent-header-color-site-title\";s:0:\"\";s:37:\"transparent-header-color-h-site-title\";s:0:\"\";s:25:\"transparent-menu-bg-color\";s:0:\"\";s:22:\"transparent-menu-color\";s:0:\"\";s:24:\"transparent-menu-h-color\";s:0:\"\";s:28:\"transparent-submenu-bg-color\";s:0:\"\";s:25:\"transparent-submenu-color\";s:0:\"\";s:27:\"transparent-submenu-h-color\";s:0:\"\";s:38:\"transparent-header-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:46:\"transparent-header-color-site-title-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:48:\"transparent-header-color-h-site-title-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"transparent-menu-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"transparent-menu-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:35:\"transparent-menu-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:39:\"transparent-submenu-bg-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:36:\"transparent-submenu-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:38:\"transparent-submenu-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:49:\"transparent-content-section-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:49:\"transparent-content-section-link-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:51:\"transparent-content-section-link-h-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:22:\"breadcrumb-font-family\";s:7:\"inherit\";s:22:\"breadcrumb-font-weight\";s:7:\"inherit\";s:25:\"breadcrumb-text-transform\";s:0:\"\";s:32:\"breadcrumb-text-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:34:\"breadcrumb-active-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:33:\"breadcrumb-hover-color-responsive\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:26:\"breadcrumb-separator-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:19:\"breadcrumb-bg-color\";a:3:{s:7:\"desktop\";s:0:\"\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:18:\"breadcrumb-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:8:\"h1-color\";s:0:\"\";s:8:\"h2-color\";s:0:\"\";s:8:\"h3-color\";s:0:\"\";s:8:\"h4-color\";s:0:\"\";s:8:\"h5-color\";s:0:\"\";s:8:\"h6-color\";s:0:\"\";s:14:\"font-family-h1\";s:7:\"inherit\";s:14:\"font-weight-h1\";s:7:\"inherit\";s:17:\"text-transform-h1\";s:0:\"\";s:14:\"line-height-h1\";s:0:\"\";s:14:\"font-family-h2\";s:7:\"inherit\";s:14:\"font-weight-h2\";s:7:\"inherit\";s:17:\"text-transform-h2\";s:0:\"\";s:14:\"line-height-h2\";s:0:\"\";s:14:\"font-family-h3\";s:7:\"inherit\";s:14:\"font-weight-h3\";s:7:\"inherit\";s:17:\"text-transform-h3\";s:0:\"\";s:14:\"line-height-h3\";s:0:\"\";s:18:\"font-weight-button\";s:7:\"inherit\";s:18:\"font-family-button\";s:21:\"\'Raleway\', sans-serif\";s:16:\"font-size-button\";a:6:{s:7:\"desktop\";s:2:\"15\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"text-transform-button\";s:9:\"uppercase\";s:21:\"theme-btn-line-height\";i:1;s:24:\"theme-btn-letter-spacing\";s:0:\"\";s:38:\"header-main-rt-section-search-box-type\";s:12:\"slide-search\";s:38:\"below-header-section-2-search-box-type\";s:12:\"slide-search\";s:38:\"below-header-section-1-search-box-type\";s:12:\"slide-search\";s:38:\"above-header-section-1-search-box-type\";s:12:\"slide-search\";s:38:\"above-header-section-2-search-box-type\";s:12:\"slide-search\";s:24:\"astra-addon-auto-version\";s:5:\"2.5.1\";s:18:\"theme-auto-version\";s:5:\"2.5.0\";s:21:\"different-retina-logo\";b:1;s:36:\"mobile-header-toggle-btn-style-color\";s:7:\"#597c7a\";s:38:\"mobile-header-toggle-btn-border-radius\";i:5;s:24:\"header-bg-obj-responsive\";a:3:{s:7:\"desktop\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"tablet\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:6:\"mobile\";a:6:{s:16:\"background-color\";s:0:\"\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}}s:25:\"container-outside-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:3:\"1.5\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:3:\"1.5\";s:4:\"left\";s:1:\"0\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"px\";}s:24:\"container-inside-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:3:\"1.5\";s:5:\"right\";s:4:\"2.14\";s:6:\"bottom\";s:3:\"1.5\";s:4:\"left\";s:4:\"2.14\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:3:\"1.5\";s:5:\"right\";s:1:\"1\";s:6:\"bottom\";s:3:\"1.5\";s:4:\"left\";s:1:\"1\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"em\";s:11:\"mobile-unit\";s:2:\"em\";}s:14:\"header-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:20:\"primary-menu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:1:\"0\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:2:\"25\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:2:\"25\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"mobile-header-menu-all-border\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:23:\"primary-submenu-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:21:\"site-identity-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:2:\"20\";s:4:\"left\";s:2:\"13\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:2:\"15\";s:4:\"left\";s:3:\"013\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:14:\"font-family-h6\";s:7:\"inherit\";s:14:\"font-weight-h6\";s:6:\"normal\";s:17:\"text-transform-h6\";s:0:\"\";s:16:\"button-v-padding\";i:10;s:16:\"button-h-padding\";i:30;s:13:\"footer-bg-obj\";a:6:{s:16:\"background-color\";s:7:\"#ffffff\";s:16:\"background-image\";s:0:\"\";s:17:\"background-repeat\";s:6:\"repeat\";s:19:\"background-position\";s:13:\"center center\";s:15:\"background-size\";s:4:\"auto\";s:21:\"background-attachment\";s:6:\"scroll\";}s:24:\"font-family-primary-menu\";s:7:\"inherit\";s:22:\"font-size-primary-menu\";a:6:{s:7:\"desktop\";s:2:\"15\";s:6:\"tablet\";s:2:\"24\";s:6:\"mobile\";s:2:\"15\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"text-transform-primary-menu\";s:9:\"uppercase\";s:29:\"primary-menu-color-responsive\";a:3:{s:7:\"desktop\";s:16:\"rgba(0,8,35,0.5)\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"primary-menu-h-color-responsive\";a:3:{s:7:\"desktop\";s:7:\"#597c7a\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:31:\"primary-menu-a-color-responsive\";a:3:{s:7:\"desktop\";s:7:\"#000823\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";}s:24:\"font-weight-primary-menu\";s:3:\"700\";s:17:\"mobile-menu-style\";s:10:\"fullscreen\";s:33:\"_astra_pb_compatibility_completed\";b:1;s:9:\"blog-grid\";s:1:\"1\";s:27:\"blog-featured-image-padding\";b:0;s:18:\"blog-excerpt-count\";i:25;s:20:\"blog-space-bet-posts\";b:1;s:24:\"blog-post-inside-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"30\";s:5:\"right\";s:2:\"30\";s:6:\"bottom\";s:2:\"30\";s:4:\"left\";s:2:\"30\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"15\";s:5:\"right\";s:2:\"15\";s:6:\"bottom\";s:2:\"15\";s:4:\"left\";s:2:\"15\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:29:\"single-featured-image-padding\";b:1;s:26:\"single-post-inside-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:2:\"80\";s:5:\"right\";s:2:\"80\";s:6:\"bottom\";s:2:\"80\";s:4:\"left\";s:2:\"80\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:2:\"50\";s:5:\"right\";s:2:\"50\";s:6:\"bottom\";s:2:\"50\";s:4:\"left\";s:2:\"50\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"15\";s:5:\"right\";s:2:\"15\";s:6:\"bottom\";s:2:\"15\";s:4:\"left\";s:2:\"15\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:27:\"single-post-outside-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:2:\"20\";s:5:\"right\";s:2:\"10\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:2:\"10\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:25:\"blog-post-outside-spacing\";a:6:{s:7:\"desktop\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"tablet\";a:4:{s:3:\"top\";s:0:\"\";s:5:\"right\";s:0:\"\";s:6:\"bottom\";s:0:\"\";s:4:\"left\";s:0:\"\";}s:6:\"mobile\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:2:\"10\";s:6:\"bottom\";s:2:\"10\";s:4:\"left\";s:2:\"10\";}s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"sidebar-widget-title-color\";s:7:\"#597c7a\";s:18:\"sidebar-text-color\";s:7:\"#3a3a3a\";s:18:\"sidebar-link-color\";s:7:\"#3a3a3a\";s:20:\"sidebar-link-h-color\";s:7:\"#597c7a\";s:24:\"font-size-widget-content\";a:6:{s:7:\"desktop\";s:2:\"15\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"line-height-widget-content\";s:4:\"1.85\";s:15:\"ast-author-info\";b:1;s:11:\"blog-layout\";s:13:\"blog-layout-1\";s:13:\"blog-date-box\";b:1;s:19:\"blog-date-box-style\";s:6:\"square\";s:21:\"headings-font-variant\";s:0:\"\";s:24:\"font-size-footer-content\";a:6:{s:7:\"desktop\";s:2:\"13\";s:6:\"tablet\";s:0:\"\";s:6:\"mobile\";s:0:\"\";s:12:\"desktop-unit\";s:2:\"px\";s:11:\"tablet-unit\";s:2:\"px\";s:11:\"mobile-unit\";s:2:\"px\";}s:26:\"font-weight-footer-content\";s:6:\"normal\";s:29:\"text-transform-footer-content\";s:9:\"uppercase\";s:25:\"submenu-open-below-header\";b:0;s:22:\"is_addon_queue_running\";b:1;s:18:\"heading-base-color\";s:7:\"#000823\";s:38:\"theme-button-border-group-border-color\";s:0:\"\";s:40:\"theme-button-border-group-border-h-color\";s:0:\"\";s:28:\"is_astra_addon_queue_running\";b:0;s:35:\"ele-default-color-typo-setting-comp\";b:0;s:22:\"is_theme_queue_running\";b:0;s:27:\"gtn-full-wide-image-grp-css\";b:0;s:27:\"gtn-full-wide-grp-cover-css\";b:0;}s:10:\"custom-css\";s:0:\"\";}s:23:\"astra-site-options-data\";a:49:{s:30:\"woocommerce_product_attributes\";a:0:{}s:28:\"woocommerce_product_cat_list\";a:0:{}s:23:\"woocommerce_product_cat\";a:0:{}s:11:\"custom_logo\";s:99:\"https://websitedemos.net/pet-care-04/wp-content/uploads/sites/487/2019/08/logo-regular-free-img.png\";s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";s:4:\"menu\";}s:13:\"show_on_front\";s:4:\"page\";s:13:\"page_on_front\";s:4:\"Home\";s:14:\"page_for_posts\";s:0:\"\";s:25:\"_fl_builder_enabled_icons\";N;s:27:\"_fl_builder_enabled_modules\";N;s:22:\"_fl_builder_post_types\";N;s:25:\"_fl_builder_color_presets\";N;s:20:\"_fl_builder_services\";N;s:20:\"_fl_builder_settings\";N;s:23:\"_fl_builder_user_access\";N;s:29:\"_fl_builder_enabled_templates\";N;s:25:\"elementor_container_width\";s:4:\"1200\";s:21:\"elementor_cpt_support\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:26:\"elementor_css_print_method\";s:8:\"external\";s:31:\"elementor_default_generic_fonts\";s:10:\"Sans-serif\";s:31:\"elementor_disable_color_schemes\";s:3:\"yes\";s:36:\"elementor_disable_typography_schemes\";s:3:\"yes\";s:28:\"elementor_editor_break_lines\";s:0:\"\";s:28:\"elementor_exclude_user_roles\";N;s:31:\"elementor_global_image_lightbox\";s:3:\"yes\";s:29:\"elementor_page_title_selector\";s:0:\"\";s:22:\"elementor_scheme_color\";a:4:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";}s:30:\"elementor_scheme_color-picker]\";a:8:{i:1;s:7:\"#597c7a\";i:2;s:7:\"#597c7a\";i:3;s:7:\"#597c7a\";i:4;s:7:\"#597c7a\";i:5;s:7:\"#597c7a\";i:6;s:7:\"#597c7a\";i:7;s:7:\"#000823\";i:8;s:7:\"#ffffff\";}s:27:\"elementor_scheme_typography\";a:4:{i:1;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"600\";}i:2;a:2:{s:11:\"font_family\";s:11:\"Roboto Slab\";s:11:\"font_weight\";s:3:\"400\";}i:3;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"400\";}i:4;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"500\";}}s:31:\"elementor_space_between_widgets\";s:0:\"\";s:37:\"elementor_stretched_section_container\";s:0:\"\";s:23:\"elementor_load_fa4_shim\";s:3:\"yes\";s:20:\"elementor_active_kit\";s:3:\"583\";s:27:\"woocommerce_shop_page_title\";s:0:\"\";s:27:\"woocommerce_cart_page_title\";s:0:\"\";s:31:\"woocommerce_checkout_page_title\";s:0:\"\";s:32:\"woocommerce_myaccount_page_title\";s:0:\"\";s:35:\"woocommerce_edit_address_page_title\";s:0:\"\";s:33:\"woocommerce_view_order_page_title\";s:0:\"\";s:38:\"woocommerce_change_password_page_title\";s:0:\"\";s:29:\"woocommerce_logout_page_title\";s:0:\"\";s:33:\"woocommerce_enable_guest_checkout\";N;s:42:\"woocommerce_enable_checkout_login_reminder\";N;s:49:\"woocommerce_enable_signup_and_login_from_checkout\";s:2:\"no\";s:41:\"woocommerce_enable_myaccount_registration\";s:2:\"no\";s:42:\"woocommerce_registration_generate_username\";s:2:\"no\";s:16:\"wpforms_settings\";a:3:{s:11:\"disable-css\";s:1:\"2\";s:13:\"global-assets\";b:0;s:4:\"gdpr\";b:0;}s:29:\"learndash_settings_theme_ld30\";N;s:33:\"learndash_settings_courses_themes\";N;}s:19:\"astra-site-wxr-path\";s:67:\"https://websitedemos.net/wp-content/uploads/astra-sites/487/wxr.xml\";s:20:\"astra-site-give-path\";s:0:\"\";s:24:\"astra-enabled-extensions\";a:19:{s:14:\"advanced-hooks\";s:0:\"\";s:8:\"blog-pro\";s:0:\"\";s:21:\"colors-and-background\";s:0:\"\";s:15:\"advanced-footer\";s:0:\"\";s:13:\"mobile-header\";s:0:\"\";s:15:\"header-sections\";s:0:\"\";s:9:\"lifterlms\";s:0:\"\";s:9:\"learndash\";s:0:\"\";s:16:\"advanced-headers\";s:0:\"\";s:12:\"site-layouts\";s:0:\"\";s:7:\"spacing\";s:0:\"\";s:13:\"sticky-header\";s:0:\"\";s:13:\"scroll-to-top\";s:0:\"\";s:18:\"transparent-header\";s:0:\"\";s:10:\"typography\";s:0:\"\";s:11:\"woocommerce\";s:0:\"\";s:3:\"edd\";s:0:\"\";s:8:\"nav-menu\";s:0:\"\";s:3:\"all\";s:3:\"all\";}s:16:\"astra-custom-404\";s:0:\"\";s:18:\"featured-image-url\";s:69:\"https://websitedemos.net/wp-content/uploads/2020/01/pet-care-home.jpg\";s:26:\"astra-woocommerce-csv-path\";s:0:\"\";s:23:\"astra-post-data-mapping\";a:4:{s:19:\"astra-advanced-hook\";a:0:{}s:16:\"astra_adv_header\";a:0:{}s:10:\"give_forms\";a:0:{}s:16:\"ld_landing_pages\";a:0:{}}s:23:\"astra-site-wpforms-path\";s:72:\"https://websitedemos.net/wp-content/uploads/astra-sites/487/wpforms.json\";s:25:\"astra-site-cartflows-path\";s:0:\"\";s:27:\"astra-site-taxonomy-mapping\";a:1:{s:4:\"post\";a:1:{s:8:\"category\";a:1:{i:0;a:2:{s:2:\"id\";i:27;s:4:\"slug\";s:11:\"pet-sitting\";}}}}s:20:\"astra-site-parent-id\";i:992;s:14:\"license-status\";s:5:\"valid\";s:12:\"request_time\";d:0.8626010417938232421875;s:6:\"_links\";a:10:{s:4:\"self\";a:1:{i:0;a:1:{s:4:\"href\";s:56:\"https://websitedemos.net/wp-json/wp/v2/astra-sites/34012\";}}s:10:\"collection\";a:1:{i:0;a:1:{s:4:\"href\";s:50:\"https://websitedemos.net/wp-json/wp/v2/astra-sites\";}}s:5:\"about\";a:1:{i:0;a:1:{s:4:\"href\";s:56:\"https://websitedemos.net/wp-json/wp/v2/types/astra-sites\";}}s:6:\"author\";a:1:{i:0;a:2:{s:10:\"embeddable\";b:1;s:4:\"href\";s:47:\"https://websitedemos.net/wp-json/wp/v2/users/34\";}}s:15:\"version-history\";a:1:{i:0;a:2:{s:5:\"count\";i:1;s:4:\"href\";s:66:\"https://websitedemos.net/wp-json/wp/v2/astra-sites/34012/revisions\";}}s:19:\"predecessor-version\";a:1:{i:0;a:2:{s:2:\"id\";i:34018;s:4:\"href\";s:72:\"https://websitedemos.net/wp-json/wp/v2/astra-sites/34012/revisions/34018\";}}s:16:\"wp:featuredmedia\";a:1:{i:0;a:2:{s:10:\"embeddable\";b:1;s:4:\"href\";s:50:\"https://websitedemos.net/wp-json/wp/v2/media/43662\";}}s:13:\"wp:attachment\";a:1:{i:0;a:1:{s:4:\"href\";s:57:\"https://websitedemos.net/wp-json/wp/v2/media?parent=34012\";}}s:7:\"wp:term\";a:4:{i:0;a:3:{s:8:\"taxonomy\";s:19:\"astra-site-category\";s:10:\"embeddable\";b:1;s:4:\"href\";s:69:\"https://websitedemos.net/wp-json/wp/v2/astra-site-category?post=34012\";}i:1;a:3:{s:8:\"taxonomy\";s:16:\"astra-sites-type\";s:10:\"embeddable\";b:1;s:4:\"href\";s:66:\"https://websitedemos.net/wp-json/wp/v2/astra-sites-type?post=34012\";}i:2;a:3:{s:8:\"taxonomy\";s:23:\"astra-site-page-builder\";s:10:\"embeddable\";b:1;s:4:\"href\";s:73:\"https://websitedemos.net/wp-json/wp/v2/astra-site-page-builder?post=34012\";}i:3;a:3:{s:8:\"taxonomy\";s:15:\"astra-sites-tag\";s:10:\"embeddable\";b:1;s:4:\"href\";s:65:\"https://websitedemos.net/wp-json/wp/v2/astra-sites-tag?post=34012\";}}s:6:\"curies\";a:1:{i:0;a:3:{s:4:\"name\";s:2:\"wp\";s:4:\"href\";s:23:\"https://api.w.org/{rel}\";s:9:\"templated\";b:1;}}}}", "yes");
INSERT INTO `wp_options` VALUES("1265", "astra_sites_settings", "a:2:{s:12:\"page_builder\";s:9:\"elementor\";s:20:\"dismiss_ai_promotion\";s:4:\"true\";}", "off");
INSERT INTO `wp_options` VALUES("258", "rg_gforms_key", "e2981f6e2b4d6c4ee5b305350eb81010", "yes");
INSERT INTO `wp_options` VALUES("259", "gf_site_key", "ecabea5e-436e-44e2-b3b8-b309bb05edf8", "yes");
INSERT INTO `wp_options` VALUES("260", "gf_site_secret", "8e679819-3366-4fea-8b74-fcd6ee459b96", "yes");
INSERT INTO `wp_options` VALUES("380", "elementor_log", "a:42:{s:32:\"dd203a8aa22a547d671d1a0da0af37c8\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-03 18:51:52\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-03 18:51:52\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"b085d23a612622f8237ec9c4d39527a9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-03 18:51:52\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:48:\"Elementor Pro/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-03 18:51:52\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:48:\"Elementor Pro/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"fb50e44b69443f2ba7b5989679490d00\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-03 18:51:52\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor Pro/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-03 18:51:52\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:50:\"Elementor Pro/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"0ca1762479337c64aa80b4f021eb845b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-03 18:51:52\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-03 18:51:52\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"38cd0c6c0654bf973dffdfb1ce827ee9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-03 18:51:52\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-03 18:51:52\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.1\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"58f9ccff6d19f54b1107457d32c75f6b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-15 22:20:01\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.1\";s:2:\"to\";s:6:\"3.31.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-15 22:20:01\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.1\";s:2:\"to\";s:6:\"3.31.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"bb92a4ab24a60fcc04dd7e4437b721ed\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-15 22:20:01\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.29.1\";s:2:\"to\";s:6:\"3.31.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-15 22:20:01\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.29.1\";s:2:\"to\";s:6:\"3.31.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"623d4a52228ae6b9e2df5812637ef532\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-15 22:20:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-15 22:20:02\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"elementor-pro::elementor_pro_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"5b408d63bc1fa785af64b074141cb6b7\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-15 22:20:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:48:\"Elementor Pro/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-15 22:20:02\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:48:\"Elementor Pro/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"52b1fc377a9fee8fd1275824fa5aeb15\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-15 22:20:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor Pro/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-15 22:20:02\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:50:\"Elementor Pro/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"77fc06b7dbb4d86c716b112f908b954d\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-15 22:20:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:70:\"Elementor Pro/Upgrades - _v_3_30_0_post_navigation_inline_icons Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-15 22:20:02\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:70:\"Elementor Pro/Upgrades - _v_3_30_0_post_navigation_inline_icons Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"91e10260c327313abed97d7903d13ef7\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-15 22:20:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:72:\"Elementor Pro/Upgrades - _v_3_30_0_post_navigation_inline_icons Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-15 22:20:02\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:72:\"Elementor Pro/Upgrades - _v_3_30_0_post_navigation_inline_icons Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"57896331566e6f1ccd6713e7a844c7ec\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-15 22:20:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.29.1\";s:2:\"to\";s:6:\"3.31.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-15 22:20:02\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.29.1\";s:2:\"to\";s:6:\"3.31.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"ed77dcff6025e413e1da414b6f587d98\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-15 22:20:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-15 22:20:02\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"51c3bf0acbf1345ab98e8c52097e48f2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-15 22:20:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-15 22:20:02\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"fd9007c1fd40e015b46e89f1b16b249f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-15 22:20:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.29.1\";s:2:\"to\";s:6:\"3.31.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-15 22:20:02\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:13:\"Elementor Pro\";s:4:\"from\";s:6:\"3.29.1\";s:2:\"to\";s:6:\"3.31.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"37b2e46b6d9aec987f262d6c7bf8723c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-15 22:20:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-15 22:20:02\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"c0b3506d368c1c73217cdbaf9b613d2b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-08-15 22:20:02\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.1\";s:2:\"to\";s:6:\"3.31.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-08-15 22:20:02\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.29.1\";s:2:\"to\";s:6:\"3.31.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"782c3e657601cd3d0b3f2d307b7a127c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-05 17:54:22\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-05 17:54:22\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"4083a6ae8c978bc8c391011fd267d0d4\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-05 17:54:22\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-05 17:54:22\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"6af179dcef7a284dba7bc21db681893c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-05 17:54:22\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-05 17:54:22\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"0afee813832915cfbc81a8b567d740b1\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-05 17:54:22\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.2\";s:2:\"to\";s:6:\"3.31.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-05 17:54:22\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.2\";s:2:\"to\";s:6:\"3.31.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"8c685fa87a7b57dd294697275e8679be\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-05 17:54:22\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.2\";s:2:\"to\";s:6:\"3.31.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-05 17:54:22\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.2\";s:2:\"to\";s:6:\"3.31.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"443273ab4a1becdfa6f81aea95f7b044\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-17 22:06:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-17 22:06:10\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"3ba4a1ffcccb7cc0481b4beda4fb3024\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-17 22:06:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-17 22:06:10\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"b4a84168cf20aee2dda7e5f271756735\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-17 22:06:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-17 22:06:11\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"48d141fa8e1133a633dabf2362e74b44\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-17 22:06:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.3\";s:2:\"to\";s:6:\"3.32.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-17 22:06:11\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.3\";s:2:\"to\";s:6:\"3.32.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"2b30507daef749635eb155e6d876adf1\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-09-17 22:06:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.3\";s:2:\"to\";s:6:\"3.32.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-09-17 22:06:11\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.31.3\";s:2:\"to\";s:6:\"3.32.1\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"94cb20b32cc9d2f310d43fac83ee45fa\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-10 21:16:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-10 21:16:10\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"5c54198db7ea353e65b6b43f9d578205\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-10 21:16:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-10 21:16:10\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"f7fa4cfd9a597b27d5cfb630c47425da\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-10 21:16:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-10 21:16:10\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"16f022b94450dd0a9cd783e5012ab821\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-10 21:16:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.1\";s:2:\"to\";s:6:\"3.32.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-10 21:16:10\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.1\";s:2:\"to\";s:6:\"3.32.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"72f1b55d6a7c9e09ebb56cbf78fad5d9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-10-10 21:16:10\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.1\";s:2:\"to\";s:6:\"3.32.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-10-10 21:16:10\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.1\";s:2:\"to\";s:6:\"3.32.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"fdff1797730cf66fdb25c563989d0aa0\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-11-08 20:27:12\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:173:\"ElementorPro\\Modules\\Notes\\Database\\Models\\Note::query(): Implicitly marking parameter $connection as nullable is deprecated, the explicit nullable type must be used instead\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:5:{i:0;a:5:{s:4:\"file\";s:81:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor-pro/plugin.php\";s:4:\"line\";i:172;s:8:\"function\";s:18:\"rest_error_handler\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}i:1;a:4:{s:4:\"file\";s:81:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor-pro/plugin.php\";s:4:\"line\";i:172;s:4:\"args\";a:1:{i:0;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/logger/manager.php\";}s:8:\"function\";s:7:\"include\";}i:2;a:5:{s:4:\"file\";s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor-pro/modules/notes/data/controller.php\";s:4:\"line\";i:243;s:8:\"function\";s:8:\"autoload\";s:5:\"class\";s:19:\"ElementorPro\\Plugin\";s:4:\"type\";s:2:\"->\";}i:3;a:5:{s:4:\"file\";s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/data/v2/base/controller.php\";s:4:\"line\";i:174;s:8:\"function\";s:21:\"get_collection_params\";s:5:\"class\";s:42:\"ElementorPro\\Modules\\Notes\\Data\\Controller\";s:4:\"type\";s:2:\"->\";}i:4;a:5:{s:4:\"file\";s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/data/v2/base/endpoint/index.php\";s:4:\"line\";i:57;s:8:\"function\";s:14:\"get_items_args\";s:5:\"class\";s:33:\"Elementor\\Data\\V2\\Base\\Controller\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:23;s:14:\"\0*\0times_dates\";a:23:{i:0;s:19:\"2025-11-08 20:27:12\";i:1;s:19:\"2025-11-11 15:33:26\";i:2;s:19:\"2025-11-11 15:35:09\";i:3;s:19:\"2025-11-11 15:37:16\";i:4;s:19:\"2025-11-11 15:37:49\";i:5;s:19:\"2025-11-20 01:31:07\";i:6;s:19:\"2025-12-05 00:28:25\";i:7;s:19:\"2025-12-05 21:04:41\";i:8;s:19:\"2025-12-05 21:04:47\";i:9;s:19:\"2025-12-05 21:04:57\";i:10;s:19:\"2025-12-05 21:05:01\";i:11;s:19:\"2025-12-05 21:05:18\";i:12;s:19:\"2025-12-05 21:05:20\";i:13;s:19:\"2025-12-05 21:05:26\";i:14;s:19:\"2025-12-05 21:08:03\";i:15;s:19:\"2025-12-05 21:08:09\";i:16;s:19:\"2025-12-05 21:08:46\";i:17;s:19:\"2025-12-05 21:14:42\";i:18;s:19:\"2025-12-05 21:14:46\";i:19;s:19:\"2025-12-05 21:14:57\";i:20;s:19:\"2025-12-05 21:15:02\";i:21;s:19:\"2025-12-05 21:15:06\";i:22;s:19:\"2025-12-05 21:15:12\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:173:\"ElementorPro\\Modules\\Notes\\Database\\Models\\Note::query(): Implicitly marking parameter $connection as nullable is deprecated, the explicit nullable type must be used instead\";s:4:\"file\";s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor-pro/modules/notes/database/models/note.php\";s:4:\"line\";i:252;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor-pro/modules/notes/database/models/note.php\";s:7:\"\0*\0line\";i:252;}s:32:\"ca515a0001ab72bd29c6fe1de071975c\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-11-08 20:27:12\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:163:\"ElementorPro\\Core\\Database\\Model_Base::query(): Implicitly marking parameter $connection as nullable is deprecated, the explicit nullable type must be used instead\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:5:{i:0;a:5:{s:4:\"file\";s:81:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor-pro/plugin.php\";s:4:\"line\";i:172;s:8:\"function\";s:18:\"rest_error_handler\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}i:1;a:4:{s:4:\"file\";s:81:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor-pro/plugin.php\";s:4:\"line\";i:172;s:4:\"args\";a:1:{i:0;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/logger/manager.php\";}s:8:\"function\";s:7:\"include\";}i:2;a:5:{s:4:\"file\";s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor-pro/modules/notes/database/models/note.php\";s:4:\"line\";i:18;s:8:\"function\";s:8:\"autoload\";s:5:\"class\";s:19:\"ElementorPro\\Plugin\";s:4:\"type\";s:2:\"->\";}i:3;a:4:{s:4:\"file\";s:81:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor-pro/plugin.php\";s:4:\"line\";i:172;s:4:\"args\";a:1:{i:0;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor-pro/modules/notes/database/models/note.php\";}s:8:\"function\";s:7:\"include\";}i:4;a:5:{s:4:\"file\";s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor-pro/modules/notes/data/controller.php\";s:4:\"line\";i:243;s:8:\"function\";s:8:\"autoload\";s:5:\"class\";s:19:\"ElementorPro\\Plugin\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:23;s:14:\"\0*\0times_dates\";a:23:{i:0;s:19:\"2025-11-08 20:27:12\";i:1;s:19:\"2025-11-11 15:33:26\";i:2;s:19:\"2025-11-11 15:35:09\";i:3;s:19:\"2025-11-11 15:37:16\";i:4;s:19:\"2025-11-11 15:37:49\";i:5;s:19:\"2025-11-20 01:31:07\";i:6;s:19:\"2025-12-05 00:28:25\";i:7;s:19:\"2025-12-05 21:04:41\";i:8;s:19:\"2025-12-05 21:04:47\";i:9;s:19:\"2025-12-05 21:04:57\";i:10;s:19:\"2025-12-05 21:05:01\";i:11;s:19:\"2025-12-05 21:05:18\";i:12;s:19:\"2025-12-05 21:05:20\";i:13;s:19:\"2025-12-05 21:05:26\";i:14;s:19:\"2025-12-05 21:08:03\";i:15;s:19:\"2025-12-05 21:08:09\";i:16;s:19:\"2025-12-05 21:08:46\";i:17;s:19:\"2025-12-05 21:14:42\";i:18;s:19:\"2025-12-05 21:14:46\";i:19;s:19:\"2025-12-05 21:14:57\";i:20;s:19:\"2025-12-05 21:15:02\";i:21;s:19:\"2025-12-05 21:15:06\";i:22;s:19:\"2025-12-05 21:15:13\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:163:\"ElementorPro\\Core\\Database\\Model_Base::query(): Implicitly marking parameter $connection as nullable is deprecated, the explicit nullable type must be used instead\";s:4:\"file\";s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor-pro/core/database/model-base.php\";s:4:\"line\";i:66;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor-pro/core/database/model-base.php\";s:7:\"\0*\0line\";i:66;}s:32:\"f11acb6b48d28bea730eeb280eec0ef8\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-11-11 08:24:08\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:170:\"ElementorPro\\Core\\Database\\Join_Clause::__construct(): Implicitly marking parameter $connection as nullable is deprecated, the explicit nullable type must be used instead\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:4;s:14:\"\0*\0times_dates\";a:4:{i:0;s:19:\"2025-11-11 08:24:08\";i:1;s:19:\"2025-11-19 08:24:39\";i:2;s:19:\"2025-11-26 08:28:03\";i:3;s:19:\"2025-12-04 08:25:21\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:170:\"ElementorPro\\Core\\Database\\Join_Clause::__construct(): Implicitly marking parameter $connection as nullable is deprecated, the explicit nullable type must be used instead\";s:4:\"file\";s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor-pro/core/database/join-clause.php\";s:4:\"line\";i:37;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor-pro/core/database/join-clause.php\";s:7:\"\0*\0line\";i:37;}s:32:\"988d0786f4e3c3b3dc10d4e952564601\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0date\";s:19:\"2025-11-11 15:33:26\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:31:\"Constant E_STRICT is deprecated\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:40;s:14:\"\0*\0times_dates\";a:40:{i:0;s:19:\"2025-11-11 15:33:26\";i:1;s:19:\"2025-11-11 15:33:26\";i:2;s:19:\"2025-11-11 15:35:09\";i:3;s:19:\"2025-11-11 15:35:09\";i:4;s:19:\"2025-11-11 15:37:16\";i:5;s:19:\"2025-11-11 15:37:16\";i:6;s:19:\"2025-11-11 15:37:49\";i:7;s:19:\"2025-11-11 15:37:49\";i:8;s:19:\"2025-12-05 21:04:41\";i:9;s:19:\"2025-12-05 21:04:41\";i:10;s:19:\"2025-12-05 21:04:47\";i:11;s:19:\"2025-12-05 21:04:47\";i:12;s:19:\"2025-12-05 21:04:57\";i:13;s:19:\"2025-12-05 21:04:57\";i:14;s:19:\"2025-12-05 21:05:01\";i:15;s:19:\"2025-12-05 21:05:01\";i:16;s:19:\"2025-12-05 21:05:18\";i:17;s:19:\"2025-12-05 21:05:18\";i:18;s:19:\"2025-12-05 21:05:20\";i:19;s:19:\"2025-12-05 21:05:20\";i:20;s:19:\"2025-12-05 21:05:26\";i:21;s:19:\"2025-12-05 21:05:26\";i:22;s:19:\"2025-12-05 21:08:03\";i:23;s:19:\"2025-12-05 21:08:03\";i:24;s:19:\"2025-12-05 21:08:09\";i:25;s:19:\"2025-12-05 21:08:09\";i:26;s:19:\"2025-12-05 21:08:46\";i:27;s:19:\"2025-12-05 21:08:46\";i:28;s:19:\"2025-12-05 21:14:42\";i:29;s:19:\"2025-12-05 21:14:42\";i:30;s:19:\"2025-12-05 21:14:46\";i:31;s:19:\"2025-12-05 21:14:46\";i:32;s:19:\"2025-12-05 21:14:57\";i:33;s:19:\"2025-12-05 21:14:57\";i:34;s:19:\"2025-12-05 21:15:02\";i:35;s:19:\"2025-12-05 21:15:02\";i:36;s:19:\"2025-12-05 21:15:06\";i:37;s:19:\"2025-12-05 21:15:06\";i:38;s:19:\"2025-12-05 21:15:13\";i:39;s:19:\"2025-12-05 21:15:13\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:31:\"Constant E_STRICT is deprecated\";s:4:\"file\";s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/logger/manager.php\";s:4:\"line\";i:249;s:5:\"trace\";b:1;}s:7:\"\0*\0file\";s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/logger/manager.php\";s:7:\"\0*\0line\";i:249;}s:32:\"7f37a0ef36270f2042b5bccbac6ad629\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-05 21:05:15\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-05 21:05:15\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"76d4f87116311b50673c1cfc57e26c1e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-05 21:05:15\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-05 21:05:15\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:44:\"Elementor/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"19bb0ae8bdc8ae0a964eab56634e24f1\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-05 21:05:15\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-05 21:05:15\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:46:\"Elementor/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"866dbe830c5233270acec590c9cc5f2a\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-05 21:05:15\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.4\";s:2:\"to\";s:6:\"3.33.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-05 21:05:15\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.4\";s:2:\"to\";s:6:\"3.33.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"8ce2cea280c63a6ee08d7a1fa06a83c3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-12-05 21:05:15\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.4\";s:2:\"to\";s:6:\"3.33.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-12-05 21:05:15\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:9:\"Elementor\";s:4:\"from\";s:6:\"3.32.4\";s:2:\"to\";s:6:\"3.33.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}}", "off");
INSERT INTO `wp_options` VALUES("20254", "duplicator_dismissed_admin_notices", "a:1:{s:14:\"review_request\";a:1:{s:4:\"time\";i:1737128309;}}", "on");
INSERT INTO `wp_options` VALUES("15711", "astra-sites-fresh-site", "no", "no");
INSERT INTO `wp_options` VALUES("15712", "ai_builder_recent_import_log_file", "/home/ldstage/public_html/astra-theme/wp-content/uploads/ai-builder/import-16-May-2024-11-19-53-af38370422a944f3d5669c5d71e679f7.log", "no");
INSERT INTO `wp_options` VALUES("1970", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("1971", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("1972", "auto_update_core_major", "unset", "yes");
INSERT INTO `wp_options` VALUES("273", "akismet_strictness", "0", "yes");
INSERT INTO `wp_options` VALUES("272", "widget_akismet_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("274", "akismet_show_user_comments_approved", "0", "yes");
INSERT INTO `wp_options` VALUES("275", "akismet_comment_form_privacy_notice", "hide", "yes");
INSERT INTO `wp_options` VALUES("276", "wordpress_api_key", "70dfa90428f4", "yes");
INSERT INTO `wp_options` VALUES("277", "akismet_spam_count", "0", "yes");
INSERT INTO `wp_options` VALUES("244", "gf_db_version", "2.9.23.2", "off");
INSERT INTO `wp_options` VALUES("245", "rg_form_version", "2.9.23.2", "no");
INSERT INTO `wp_options` VALUES("246", "gform_enable_background_updates", "1", "yes");
INSERT INTO `wp_options` VALUES("247", "gform_pending_installation", "", "yes");
INSERT INTO `wp_options` VALUES("248", "widget_gform_widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("249", "gravityformsaddon_gravityformswebapi_version", "1.0", "yes");
INSERT INTO `wp_options` VALUES("266", "gf_previous_db_version", "2.9.23", "yes");
INSERT INTO `wp_options` VALUES("267", "gf_upgrade_lock", "", "yes");
INSERT INTO `wp_options` VALUES("261", "rg_gforms_enable_akismet", "1", "yes");
INSERT INTO `wp_options` VALUES("262", "rg_gforms_currency", "USD", "yes");
INSERT INTO `wp_options` VALUES("263", "gform_enable_toolbar_menu", "1", "yes");
INSERT INTO `wp_options` VALUES("268", "gform_sticky_admin_messages", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("657", "bsf_analytics_installed_time", "1590359721", "no");
INSERT INTO `wp_options` VALUES("11477", "elementor_notes_db_version", "5", "yes");
INSERT INTO `wp_options` VALUES("1095", "astra_sites_recent_import_log_file", "/home/ldstage/public_html/astra-theme/wp-content/uploads/astra-sites/import-26-Oct-2020-09-45-07.txt", "yes");
INSERT INTO `wp_options` VALUES("1102", "astra-sites-categories", "a:5:{i:0;a:3:{s:2:\"id\";i:27;s:4:\"name\";s:8:\"Business\";s:4:\"slug\";s:8:\"business\";}i:1;a:3:{s:2:\"id\";i:36;s:4:\"name\";s:5:\"Other\";s:4:\"slug\";s:5:\"other\";}i:2;a:3:{s:2:\"id\";i:37;s:4:\"name\";s:4:\"Blog\";s:4:\"slug\";s:4:\"blog\";}i:3;a:3:{s:2:\"id\";i:38;s:4:\"name\";s:9:\"eCommerce\";s:4:\"slug\";s:9:\"ecommerce\";}i:4;a:3:{s:2:\"id\";i:39;s:4:\"name\";s:4:\"Free\";s:4:\"slug\";s:4:\"free\";}}", "no");
INSERT INTO `wp_options` VALUES("15699", "astra-sites-auto-version", "4.4.43", "off");
INSERT INTO `wp_options` VALUES("1112", "astra-sites-tags", "a:10:{i:0;a:3:{s:2:\"id\";i:352;s:4:\"name\";s:5:\"About\";s:4:\"slug\";s:5:\"about\";}i:1;a:3:{s:2:\"id\";i:1007;s:4:\"name\";s:8:\"about me\";s:4:\"slug\";s:8:\"about-me\";}i:2;a:3:{s:2:\"id\";i:455;s:4:\"name\";s:8:\"about us\";s:4:\"slug\";s:8:\"about-us\";}i:3;a:3:{s:2:\"id\";i:599;s:4:\"name\";s:9:\"ac repair\";s:4:\"slug\";s:9:\"ac-repair\";}i:4;a:3:{s:2:\"id\";i:639;s:4:\"name\";s:11:\"accessories\";s:4:\"slug\";s:11:\"accessories\";}i:5;a:3:{s:2:\"id\";i:999;s:4:\"name\";s:7:\"account\";s:4:\"slug\";s:7:\"account\";}i:6;a:3:{s:2:\"id\";i:447;s:4:\"name\";s:10:\"Accountant\";s:4:\"slug\";s:10:\"accountant\";}i:7;a:3:{s:2:\"id\";i:448;s:4:\"name\";s:10:\"Accounting\";s:4:\"slug\";s:10:\"accounting\";}i:8;a:3:{s:2:\"id\";i:532;s:4:\"name\";s:11:\"acupressure\";s:4:\"slug\";s:11:\"acupressure\";}i:9;a:3:{s:2:\"id\";i:803;s:4:\"name\";s:13:\"administrator\";s:4:\"slug\";s:13:\"administrator\";}}", "no");
INSERT INTO `wp_options` VALUES("1124", "astra-sites-last-export-checksums-latest", "w&AV!EGIEF)*", "off");
INSERT INTO `wp_options` VALUES("1127", "astra-sites-batch-status-string", "Complete storing data for page 55", "off");
INSERT INTO `wp_options` VALUES("1128", "astra-blocks-batch-status-string", "Complete storing data for page 4", "no");
INSERT INTO `wp_options` VALUES("1129", "astra-blocks-requests", "4", "no");
INSERT INTO `wp_options` VALUES("1136", "astra-sites-batch-is-complete", "yes", "no");
INSERT INTO `wp_options` VALUES("1139", "astra-sites-license-page-builder", "elementor", "yes");
INSERT INTO `wp_options` VALUES("1135", "_astra_sites_gettings_started", "yes", "no");
INSERT INTO `wp_options` VALUES("7624", "ai1wmue_plugin_key", "d848b117-8a28-465d-a07a-a1c393b1fcf1", "yes");
INSERT INTO `wp_options` VALUES("3450", "eael_save_settings", "a:101:{s:9:\"post-grid\";i:1;s:13:\"post-timeline\";i:1;s:10:\"fancy-text\";i:1;s:12:\"creative-btn\";i:1;s:10:\"count-down\";i:1;s:12:\"team-members\";i:1;s:12:\"testimonials\";i:1;s:8:\"info-box\";i:1;s:8:\"flip-box\";i:1;s:14:\"call-to-action\";i:1;s:11:\"dual-header\";i:1;s:11:\"price-table\";i:1;s:12:\"twitter-feed\";i:1;s:13:\"facebook-feed\";i:1;s:19:\"advanced-data-table\";i:1;s:10:\"data-table\";i:1;s:14:\"filter-gallery\";i:1;s:15:\"image-accordion\";i:1;s:14:\"content-ticker\";i:1;s:7:\"tooltip\";i:1;s:13:\"adv-accordion\";i:1;s:8:\"adv-tabs\";i:1;s:12:\"progress-bar\";i:1;s:12:\"feature-list\";i:1;s:12:\"product-grid\";i:1;s:16:\"woo-product-list\";i:1;s:17:\"woo-product-price\";i:1;s:18:\"woo-product-rating\";i:1;s:11:\"breadcrumbs\";i:1;s:18:\"woo-product-images\";i:1;s:15:\"woo-add-to-cart\";i:1;s:14:\"contact-form-7\";i:1;s:7:\"weforms\";i:1;s:10:\"ninja-form\";i:1;s:9:\"formstack\";i:1;s:12:\"gravity-form\";i:1;s:12:\"caldera-form\";i:1;s:7:\"wpforms\";i:1;s:10:\"fluentform\";i:1;s:8:\"typeform\";i:1;s:24:\"betterdocs-category-grid\";i:1;s:23:\"betterdocs-category-box\";i:1;s:22:\"betterdocs-search-form\";i:1;s:12:\"sticky-video\";i:1;s:14:\"event-calendar\";i:1;s:10:\"embedpress\";i:1;s:12:\"woo-checkout\";i:1;s:8:\"woo-cart\";i:1;s:14:\"login-register\";i:1;s:11:\"career-page\";i:1;s:19:\"woo-product-compare\";i:1;s:20:\"woo-product-carousel\";i:1;s:11:\"simple-menu\";i:1;s:19:\"woo-product-gallery\";i:1;s:18:\"interactive-circle\";i:1;s:14:\"better-payment\";i:1;s:11:\"nft-gallery\";i:1;s:16:\"business-reviews\";i:1;s:8:\"svg-draw\";i:1;s:9:\"promotion\";i:1;s:9:\"custom-js\";i:1;s:16:\"reading-progress\";i:1;s:16:\"table-of-content\";i:1;s:15:\"post-duplicator\";i:1;s:13:\"scroll-to-top\";i:1;s:12:\"wrapper-link\";i:1;s:20:\"special-hover-effect\";i:1;s:14:\"img-comparison\";i:1;s:17:\"instagram-gallery\";i:1;s:17:\"interactive-promo\";i:1;s:8:\"lightbox\";i:1;s:10:\"post-block\";i:1;s:18:\"testimonial-slider\";i:1;s:14:\"static-product\";i:1;s:14:\"adv-google-map\";i:1;s:13:\"flip-carousel\";i:1;s:17:\"interactive-cards\";i:1;s:16:\"content-timeline\";i:1;s:21:\"twitter-feed-carousel\";i:1;s:22:\"dynamic-filter-gallery\";i:1;s:9:\"post-list\";i:1;s:6:\"toggle\";i:1;s:9:\"mailchimp\";i:1;s:7:\"divider\";i:1;s:10:\"price-menu\";i:1;s:14:\"image-hotspots\";i:1;s:19:\"one-page-navigation\";i:1;s:7:\"counter\";i:1;s:13:\"post-carousel\";i:1;s:20:\"team-member-carousel\";i:1;s:13:\"logo-carousel\";i:1;s:17:\"protected-content\";i:1;s:9:\"offcanvas\";i:1;s:13:\"advanced-menu\";i:1;s:14:\"image-scroller\";i:1;s:19:\"learn-dash-elements\";i:1;s:15:\"woo-collections\";i:1;s:19:\"dismissible-section\";i:1;s:16:\"section-parallax\";i:1;s:17:\"section-particles\";i:1;s:20:\"eael-tooltip-section\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("3454", "edd_sl_3f108a182fb19972b031742afa068c31", "a:2:{s:7:\"timeout\";i:1617909833;s:5:\"value\";s:969:\"{\"new_version\":\"4.3.5\",\"stable_version\":\"4.3.5\",\"name\":\"Essential Addons for Elementor\",\"slug\":\"essential_adons_elementor\",\"url\":\"http:\\/\\/stage.myliquis.co\\/astra-theme?changelog=1\",\"last_updated\":\"2021-03-24T02:24:52.000Z\",\"homepage\":\"http:\\/\\/stage.myliquis.co\\/astra-theme\",\"package\":\"\",\"download_link\":\"\",\"sections\":{\"description\":\"Ultimate elements bundle for Elementor WordPress Page Builder. Lots of useful and premium elements to complete your website quickly.\",\"changelog\":\"See <a href=\\\\\\\"https:\\/\\/essential-addons.com\\/elementor\\/changelog\\/\\\\\\\" target=\\\\\\\"_blank\\\\\\\" rel=\\\\\\\"noopener\\\\\\\">Changelog<\\/a> for details.\"},\"banners\":{},\"icons\":{},\"description\":[\"Ultimate elements bundle for Elementor WordPress Page Builder. Lots of useful and premium elements to complete your website quickly.\"],\"changelog\":[\"See <a href=\\\\\\\"https:\\/\\/essential-addons.com\\/elementor\\/changelog\\/\\\\\\\" target=\\\\\\\"_blank\\\\\\\" rel=\\\\\\\"noopener\\\\\\\">Changelog<\\/a> for details.\"]}\";}", "no");
INSERT INTO `wp_options` VALUES("3453", "eael_pro_version", "6.7.3", "yes");
INSERT INTO `wp_options` VALUES("3456", "eael_version", "6.5.3", "yes");
INSERT INTO `wp_options` VALUES("3457", "essential-addons-elementor-license-key", "88735efe06655d108d5eb8f308be4c06", "yes");
INSERT INTO `wp_options` VALUES("3460", "essential-addons-elementor-license-status", "valid", "yes");
INSERT INTO `wp_options` VALUES("3464", "eael_editor_updated_at", "1717800132", "yes");
INSERT INTO `wp_options` VALUES("3476", "edd_sl_fbbc7dea131859a182293039a07f91d3", "a:2:{s:7:\"timeout\";i:1764979486;s:5:\"value\";s:2472:\"{\"new_version\":\"6.7.3\",\"stable_version\":\"6.7.3\",\"name\":\"Essential Addons for Elementor Pro\",\"slug\":\"essential_adons_elementor\",\"url\":\"https:\\/\\/api.wpdeveloper.com\\/downloads\\/essential-addons-elementor\\/?changelog=1\",\"last_updated\":\"2025-11-25 11:30:34\",\"homepage\":\"https:\\/\\/essential-addons.com\\/\",\"package\":\"https:\\/\\/api.wpdeveloper.com\\/edd-sl\\/package_download\\/MTc2NTEyMzQ4Njo4ODczNWVmZTA2NjU1ZDEwOGQ1ZWI4ZjMwOGJlNGMwNjo0MzcyOjdkZWI1Y2FkNzc5NjczNTg4NmI0OGJiZDcyZmEyNGY3Omh0dHBALy9zdGFnZS5teWxpcXVpcy5jby9hc3RyYS10aGVtZTow\",\"download_link\":\"https:\\/\\/api.wpdeveloper.com\\/edd-sl\\/package_download\\/MTc2NTEyMzQ4Njo4ODczNWVmZTA2NjU1ZDEwOGQ1ZWI4ZjMwOGJlNGMwNjo0MzcyOjdkZWI1Y2FkNzc5NjczNTg4NmI0OGJiZDcyZmEyNGY3Omh0dHBALy9zdGFnZS5teWxpcXVpcy5jby9hc3RyYS10aGVtZTow\",\"sections\":{\"description\":\"<p>Enhance <strong><a href=\\\"https:\\/\\/wordpress.org\\/plugins\\/elementor\\/\\\" rel=\\\"ugc\\\">Elementor<\\/a><\\/strong> page building experience with 100+ creative elements and extensions. Add powers to your website builder using our easy-to-use Elementor widgets and ready Elementor templates, which were designed to make your next WordPress website design easier and prettier than ever before.<\\/p>\\n\",\"changelog\":\"<p>See <a href=\\\"https:\\/\\/essential-addons.com\\/changelog\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Changelog<\\/a> for details.<\\/p>\\n\"},\"banners\":{\"high\":\"https:\\/\\/store.assets.wpdeveloper.com\\/2025\\/07\\/e04d35a1-ea-org-banner-1544-x-500-1.png\",\"low\":\"https:\\/\\/store.assets.wpdeveloper.com\\/2025\\/07\\/50bab75e-ea-org-banner-772-x-250.png\"},\"icons\":{\"1x\":\"https:\\/\\/store.assets.wpdeveloper.com\\/2024\\/08\\/9743a1d7-essential-addons-logo-2-128x128.png\",\"2x\":\"https:\\/\\/store.assets.wpdeveloper.com\\/2024\\/08\\/9743a1d7-essential-addons-logo-2-256x256.png\"},\"description\":[\"<p>Enhance <strong><a href=\\\"https:\\/\\/wordpress.org\\/plugins\\/elementor\\/\\\" rel=\\\"ugc\\\">Elementor<\\/a><\\/strong> page building experience with 100+ creative elements and extensions. Add powers to your website builder using our easy-to-use Elementor widgets and ready Elementor templates, which were designed to make your next WordPress website design easier and prettier than ever before.<\\/p>\\n\"],\"changelog\":[\"<p>See <a href=\\\"https:\\/\\/essential-addons.com\\/changelog\\/\\\" target=\\\"_blank\\\" rel=\\\"noopener\\\">Changelog<\\/a> for details.<\\/p>\\n\"],\"plugin\":\"essential-addons-elementor\\/essential_adons_elementor.php\",\"id\":\"essential-addons-elementor\\/essential_adons_elementor.php\",\"tested\":null}\";}", "off");
INSERT INTO `wp_options` VALUES("2617", "ast-block-templates-fresh-site", "yes", "no");
INSERT INTO `wp_options` VALUES("3001", "elementor_submissions_db_version", "5", "yes");
INSERT INTO `wp_options` VALUES("12476", "elementor_scheme_color", "a:4:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";}", "yes");
INSERT INTO `wp_options` VALUES("12478", "elementor_scheme_color-picker", "a:8:{i:1;s:7:\"#6ec1e4\";i:2;s:7:\"#54595f\";i:3;s:7:\"#7a7a7a\";i:4;s:7:\"#61ce70\";i:5;s:7:\"#4054b2\";i:6;s:7:\"#23a455\";i:7;s:4:\"#000\";i:8;s:4:\"#fff\";}", "yes");
INSERT INTO `wp_options` VALUES("12477", "elementor_scheme_typography", "a:4:{i:1;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"600\";}i:2;a:2:{s:11:\"font_family\";s:11:\"Roboto Slab\";s:11:\"font_weight\";s:3:\"400\";}i:3;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"400\";}i:4;a:2:{s:11:\"font_family\";s:6:\"Roboto\";s:11:\"font_weight\";s:3:\"500\";}}", "yes");
INSERT INTO `wp_options` VALUES("2988", "https_detection_errors", "a:1:{s:17:\"bad_response_code\";a:1:{i:0;s:19:\"Service Unavailable\";}}", "off");
INSERT INTO `wp_options` VALUES("15156", "ast-block-templates-version", "2.4.15", "yes");
INSERT INTO `wp_options` VALUES("5544", "eael_remove_old_cache", "1", "yes");
INSERT INTO `wp_options` VALUES("15155", "ast_blocks_sync_in_progress", "no", "no");
INSERT INTO `wp_options` VALUES("15157", "ast-templates-business-details", "a:1:{s:5:\"token\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("20200", "rg_form_original_version", "2.9.1", "off");
INSERT INTO `wp_options` VALUES("13508", "_elementor_pro_license_v2_data_fallback", "a:2:{s:7:\"timeout\";i:1765055061;s:5:\"value\";s:2844:\"{\"expires\":\"2026-01-02 00:00:00\",\"subscription_id\":\"9028614\",\"status\":\"ACTIVE\",\"recurring\":true,\"features\":[\"template_access_level_20\",\"kit_access_level_20\",\"activity-log\",\"breadcrumbs\",\"form\",\"posts\",\"template\",\"countdown\",\"slides\",\"price-list\",\"portfolio\",\"flip-box\",\"price-table\",\"login\",\"share-buttons\",\"theme-post-content\",\"theme-post-title\",\"nav-menu\",\"blockquote\",\"media-carousel\",\"animated-headline\",\"facebook-comments\",\"facebook-embed\",\"facebook-page\",\"facebook-button\",\"testimonial-carousel\",\"post-navigation\",\"search-form\",\"post-comments\",\"author-box\",\"call-to-action\",\"post-info\",\"theme-site-logo\",\"theme-site-title\",\"theme-archive-title\",\"theme-post-excerpt\",\"theme-post-featured-image\",\"archive-posts\",\"theme-page-title\",\"sitemap\",\"reviews\",\"table-of-contents\",\"lottie\",\"code-highlight\",\"hotspot\",\"video-playlist\",\"progress-tracker\",\"section-effects\",\"sticky\",\"scroll-snap\",\"page-transitions\",\"mega-menu\",\"nested-carousel\",\"loop-grid\",\"loop-carousel\",\"theme-builder\",\"elementor_icons\",\"elementor_custom_fonts\",\"dynamic-tags\",\"taxonomy-filter\",\"email\",\"email2\",\"mailpoet\",\"mailpoet3\",\"redirect\",\"header\",\"footer\",\"single-post\",\"single-page\",\"archive\",\"search-results\",\"error-404\",\"loop-item\",\"font-awesome-pro\",\"typekit\",\"gallery\",\"off-canvas\",\"link-in-bio-var-2\",\"link-in-bio-var-3\",\"link-in-bio-var-4\",\"link-in-bio-var-5\",\"link-in-bio-var-6\",\"link-in-bio-var-7\",\"search\",\"size-variable\",\"transitions\",\"element-manager-permissions\",\"akismet\",\"display-conditions\",\"woocommerce-products\",\"wc-products\",\"woocommerce-product-add-to-cart\",\"wc-elements\",\"wc-categories\",\"woocommerce-product-price\",\"woocommerce-product-title\",\"woocommerce-product-images\",\"woocommerce-product-upsell\",\"woocommerce-product-short-description\",\"woocommerce-product-meta\",\"woocommerce-product-stock\",\"woocommerce-product-rating\",\"wc-add-to-cart\",\"dynamic-tags-wc\",\"woocommerce-product-data-tabs\",\"woocommerce-product-related\",\"woocommerce-breadcrumb\",\"wc-archive-products\",\"woocommerce-archive-products\",\"woocommerce-product-additional-information\",\"woocommerce-menu-cart\",\"woocommerce-product-content\",\"woocommerce-archive-description\",\"paypal-button\",\"woocommerce-checkout-page\",\"woocommerce-cart\",\"woocommerce-my-account\",\"woocommerce-purchase-summary\",\"woocommerce-notices\",\"settings-woocommerce-pages\",\"settings-woocommerce-notices\",\"popup\",\"custom-css\",\"global-css\",\"custom_code\",\"custom-attributes\",\"form-submissions\",\"form-integrations\",\"dynamic-tags-acf\",\"dynamic-tags-pods\",\"dynamic-tags-toolset\",\"editor_comments\",\"stripe-button\",\"role-manager\",\"global-widget\",\"activecampaign\",\"cf7db\",\"convertkit\",\"discord\",\"drip\",\"getresponse\",\"mailchimp\",\"mailerlite\",\"slack\",\"webhook\",\"product-single\",\"product-archive\",\"wc-single-elements\",\"atomic-custom-attributes\",\"atomic-custom-css\"],\"tier\":\"expert\",\"generation\":\"empty\",\"activated\":true,\"success\":true}\";}", "off");
INSERT INTO `wp_options` VALUES("13509", "_elementor_pro_license_v2_data", "a:2:{s:7:\"timeout\";i:1765011861;s:5:\"value\";s:2844:\"{\"expires\":\"2026-01-02 00:00:00\",\"subscription_id\":\"9028614\",\"status\":\"ACTIVE\",\"recurring\":true,\"features\":[\"template_access_level_20\",\"kit_access_level_20\",\"activity-log\",\"breadcrumbs\",\"form\",\"posts\",\"template\",\"countdown\",\"slides\",\"price-list\",\"portfolio\",\"flip-box\",\"price-table\",\"login\",\"share-buttons\",\"theme-post-content\",\"theme-post-title\",\"nav-menu\",\"blockquote\",\"media-carousel\",\"animated-headline\",\"facebook-comments\",\"facebook-embed\",\"facebook-page\",\"facebook-button\",\"testimonial-carousel\",\"post-navigation\",\"search-form\",\"post-comments\",\"author-box\",\"call-to-action\",\"post-info\",\"theme-site-logo\",\"theme-site-title\",\"theme-archive-title\",\"theme-post-excerpt\",\"theme-post-featured-image\",\"archive-posts\",\"theme-page-title\",\"sitemap\",\"reviews\",\"table-of-contents\",\"lottie\",\"code-highlight\",\"hotspot\",\"video-playlist\",\"progress-tracker\",\"section-effects\",\"sticky\",\"scroll-snap\",\"page-transitions\",\"mega-menu\",\"nested-carousel\",\"loop-grid\",\"loop-carousel\",\"theme-builder\",\"elementor_icons\",\"elementor_custom_fonts\",\"dynamic-tags\",\"taxonomy-filter\",\"email\",\"email2\",\"mailpoet\",\"mailpoet3\",\"redirect\",\"header\",\"footer\",\"single-post\",\"single-page\",\"archive\",\"search-results\",\"error-404\",\"loop-item\",\"font-awesome-pro\",\"typekit\",\"gallery\",\"off-canvas\",\"link-in-bio-var-2\",\"link-in-bio-var-3\",\"link-in-bio-var-4\",\"link-in-bio-var-5\",\"link-in-bio-var-6\",\"link-in-bio-var-7\",\"search\",\"size-variable\",\"transitions\",\"element-manager-permissions\",\"akismet\",\"display-conditions\",\"woocommerce-products\",\"wc-products\",\"woocommerce-product-add-to-cart\",\"wc-elements\",\"wc-categories\",\"woocommerce-product-price\",\"woocommerce-product-title\",\"woocommerce-product-images\",\"woocommerce-product-upsell\",\"woocommerce-product-short-description\",\"woocommerce-product-meta\",\"woocommerce-product-stock\",\"woocommerce-product-rating\",\"wc-add-to-cart\",\"dynamic-tags-wc\",\"woocommerce-product-data-tabs\",\"woocommerce-product-related\",\"woocommerce-breadcrumb\",\"wc-archive-products\",\"woocommerce-archive-products\",\"woocommerce-product-additional-information\",\"woocommerce-menu-cart\",\"woocommerce-product-content\",\"woocommerce-archive-description\",\"paypal-button\",\"woocommerce-checkout-page\",\"woocommerce-cart\",\"woocommerce-my-account\",\"woocommerce-purchase-summary\",\"woocommerce-notices\",\"settings-woocommerce-pages\",\"settings-woocommerce-notices\",\"popup\",\"custom-css\",\"global-css\",\"custom_code\",\"custom-attributes\",\"form-submissions\",\"form-integrations\",\"dynamic-tags-acf\",\"dynamic-tags-pods\",\"dynamic-tags-toolset\",\"editor_comments\",\"stripe-button\",\"role-manager\",\"global-widget\",\"activecampaign\",\"cf7db\",\"convertkit\",\"discord\",\"drip\",\"getresponse\",\"mailchimp\",\"mailerlite\",\"slack\",\"webhook\",\"product-single\",\"product-archive\",\"wc-single-elements\",\"atomic-custom-attributes\",\"atomic-custom-css\"],\"tier\":\"expert\",\"generation\":\"empty\",\"activated\":true,\"success\":true}\";}", "off");
INSERT INTO `wp_options` VALUES("5361", "265a76343_updated_at", "1628201667", "yes");
INSERT INTO `wp_options` VALUES("5565", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("5562", "widget_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("7335", "rg_gforms_message", "<!--GFM-->", "yes");
INSERT INTO `wp_options` VALUES("10148", "elementor_events_db_version", "1.0.0", "no");
INSERT INTO `wp_options` VALUES("10022", "astra-sites-all-site-categories-and-tags", "a:608:{i:0;a:2:{s:2:\"id\";i:2487;s:4:\"name\";s:6:\"Agency\";}i:1;a:2:{s:2:\"id\";s:6:\"2487-0\";s:4:\"name\";s:8:\"creative\";}i:2;a:2:{s:2:\"id\";s:6:\"2487-1\";s:4:\"name\";s:8:\"branding\";}i:3;a:2:{s:2:\"id\";s:6:\"2487-2\";s:4:\"name\";s:6:\"agency\";}i:4;a:2:{s:2:\"id\";s:6:\"2487-3\";s:4:\"name\";s:3:\"web\";}i:5;a:2:{s:2:\"id\";s:6:\"2487-4\";s:4:\"name\";s:6:\"social\";}i:6;a:2:{s:2:\"id\";s:6:\"2487-5\";s:4:\"name\";s:5:\"media\";}i:7;a:2:{s:2:\"id\";s:6:\"2487-6\";s:4:\"name\";s:7:\"graphic\";}i:8;a:2:{s:2:\"id\";s:6:\"2487-7\";s:4:\"name\";s:7:\"digital\";}i:9;a:2:{s:2:\"id\";s:6:\"2487-8\";s:4:\"name\";s:3:\"SEO\";}i:10;a:2:{s:2:\"id\";s:6:\"2487-9\";s:4:\"name\";s:9:\"marketing\";}i:11;a:2:{s:2:\"id\";s:7:\"2487-10\";s:4:\"name\";s:11:\"advertising\";}i:12;a:2:{s:2:\"id\";s:7:\"2487-11\";s:4:\"name\";s:22:\"information technology\";}i:13;a:2:{s:2:\"id\";s:7:\"2487-12\";s:4:\"name\";s:7:\"website\";}i:14;a:2:{s:2:\"id\";s:7:\"2487-13\";s:4:\"name\";s:7:\"startup\";}i:15;a:2:{s:2:\"id\";s:7:\"2487-14\";s:4:\"name\";s:8:\"internet\";}i:16;a:2:{s:2:\"id\";s:7:\"2487-15\";s:4:\"name\";s:8:\"software\";}i:17;a:2:{s:2:\"id\";s:7:\"2487-16\";s:4:\"name\";s:10:\"copywriter\";}i:18;a:2:{s:2:\"id\";s:7:\"2487-17\";s:4:\"name\";s:9:\"animation\";}i:19;a:2:{s:2:\"id\";s:7:\"2487-18\";s:4:\"name\";s:7:\"writing\";}i:20;a:2:{s:2:\"id\";s:7:\"2487-19\";s:4:\"name\";s:6:\"online\";}i:21;a:2:{s:2:\"id\";s:7:\"2487-20\";s:4:\"name\";s:4:\"firm\";}i:22;a:2:{s:2:\"id\";s:7:\"2487-21\";s:4:\"name\";s:8:\"template\";}i:23;a:2:{s:2:\"id\";s:7:\"2487-22\";s:4:\"name\";s:8:\"business\";}i:24;a:2:{s:2:\"id\";s:7:\"2487-23\";s:4:\"name\";s:5:\"Astra\";}i:25;a:2:{s:2:\"id\";s:7:\"2487-24\";s:4:\"name\";s:10:\"consulting\";}i:26;a:2:{s:2:\"id\";s:7:\"2487-25\";s:4:\"name\";s:10:\"consultant\";}i:27;a:2:{s:2:\"id\";s:7:\"2487-26\";s:4:\"name\";s:7:\"company\";}i:28;a:2:{s:2:\"id\";s:7:\"2487-27\";s:4:\"name\";s:6:\"design\";}i:29;a:2:{s:2:\"id\";s:7:\"2487-28\";s:4:\"name\";s:8:\"designer\";}i:30;a:2:{s:2:\"id\";s:7:\"2487-29\";s:4:\"name\";s:6:\"studio\";}i:31;a:2:{s:2:\"id\";s:7:\"2487-30\";s:4:\"name\";s:9:\"developer\";}i:32;a:2:{s:2:\"id\";s:7:\"2487-31\";s:4:\"name\";s:7:\"website\";}i:33;a:2:{s:2:\"id\";s:7:\"2487-32\";s:4:\"name\";s:4:\"logo\";}i:34;a:2:{s:2:\"id\";s:7:\"2487-33\";s:4:\"name\";s:0:\"\";}i:35;a:2:{s:2:\"id\";i:2486;s:4:\"name\";s:11:\"Art & Music\";}i:36;a:2:{s:2:\"id\";s:6:\"2486-0\";s:4:\"name\";s:2:\"DJ\";}i:37;a:2:{s:2:\"id\";s:6:\"2486-1\";s:4:\"name\";s:5:\"Music\";}i:38;a:2:{s:2:\"id\";s:6:\"2486-2\";s:4:\"name\";s:5:\"Album\";}i:39;a:2:{s:2:\"id\";s:6:\"2486-3\";s:4:\"name\";s:6:\"Singer\";}i:40;a:2:{s:2:\"id\";s:6:\"2486-4\";s:4:\"name\";s:4:\"Band\";}i:41;a:2:{s:2:\"id\";s:6:\"2486-5\";s:4:\"name\";s:4:\"Rock\";}i:42;a:2:{s:2:\"id\";s:6:\"2486-6\";s:4:\"name\";s:11:\"Disc Jockey\";}i:43;a:2:{s:2:\"id\";s:6:\"2486-7\";s:4:\"name\";s:6:\"Guitar\";}i:44;a:2:{s:2:\"id\";s:6:\"2486-8\";s:4:\"name\";s:9:\"Voiceover\";}i:45;a:2:{s:2:\"id\";s:6:\"2486-9\";s:4:\"name\";s:8:\"Musician\";}i:46;a:2:{s:2:\"id\";s:7:\"2486-10\";s:4:\"name\";s:8:\"template\";}i:47;a:2:{s:2:\"id\";s:7:\"2486-11\";s:4:\"name\";s:5:\"Astra\";}i:48;a:2:{s:2:\"id\";s:7:\"2486-12\";s:4:\"name\";s:7:\"website\";}i:49;a:2:{s:2:\"id\";s:7:\"2486-13\";s:4:\"name\";s:0:\"\";}i:50;a:2:{s:2:\"id\";i:2475;s:4:\"name\";s:10:\"Automotive\";}i:51;a:2:{s:2:\"id\";s:6:\"2475-0\";s:4:\"name\";s:6:\"garage\";}i:52;a:2:{s:2:\"id\";s:6:\"2475-1\";s:4:\"name\";s:6:\"retail\";}i:53;a:2:{s:2:\"id\";s:6:\"2475-2\";s:4:\"name\";s:4:\"bike\";}i:54;a:2:{s:2:\"id\";s:6:\"2475-3\";s:4:\"name\";s:3:\"car\";}i:55;a:2:{s:2:\"id\";s:6:\"2475-4\";s:4:\"name\";s:9:\"detailing\";}i:56;a:2:{s:2:\"id\";s:6:\"2475-5\";s:4:\"name\";s:7:\"denting\";}i:57;a:2:{s:2:\"id\";s:6:\"2475-6\";s:4:\"name\";s:4:\"wash\";}i:58;a:2:{s:2:\"id\";s:6:\"2475-7\";s:4:\"name\";s:7:\"service\";}i:59;a:2:{s:2:\"id\";s:6:\"2475-8\";s:4:\"name\";s:8:\"services\";}i:60;a:2:{s:2:\"id\";s:6:\"2475-9\";s:4:\"name\";s:8:\"template\";}i:61;a:2:{s:2:\"id\";s:7:\"2475-10\";s:4:\"name\";s:5:\"local\";}i:62;a:2:{s:2:\"id\";s:7:\"2475-11\";s:4:\"name\";s:8:\"business\";}i:63;a:2:{s:2:\"id\";s:7:\"2475-12\";s:4:\"name\";s:5:\"Astra\";}i:64;a:2:{s:2:\"id\";s:7:\"2475-13\";s:4:\"name\";s:4:\"shop\";}i:65;a:2:{s:2:\"id\";s:7:\"2475-14\";s:4:\"name\";s:7:\"company\";}i:66;a:2:{s:2:\"id\";s:7:\"2475-15\";s:4:\"name\";s:6:\"repair\";}i:67;a:2:{s:2:\"id\";s:7:\"2475-16\";s:4:\"name\";s:7:\"website\";}i:68;a:2:{s:2:\"id\";s:7:\"2475-17\";s:4:\"name\";s:0:\"\";}i:69;a:2:{s:2:\"id\";i:2479;s:4:\"name\";s:6:\"Beauty\";}i:70;a:2:{s:2:\"id\";s:6:\"2479-0\";s:4:\"name\";s:10:\"beautician\";}i:71;a:2:{s:2:\"id\";s:6:\"2479-1\";s:4:\"name\";s:7:\"massage\";}i:72;a:2:{s:2:\"id\";s:6:\"2479-2\";s:4:\"name\";s:6:\"beauty\";}i:73;a:2:{s:2:\"id\";s:6:\"2479-3\";s:4:\"name\";s:6:\"parlor\";}i:74;a:2:{s:2:\"id\";s:6:\"2479-4\";s:4:\"name\";s:6:\"saloon\";}i:75;a:2:{s:2:\"id\";s:6:\"2479-5\";s:4:\"name\";s:3:\"spa\";}i:76;a:2:{s:2:\"id\";s:6:\"2479-6\";s:4:\"name\";s:7:\"dresser\";}i:77;a:2:{s:2:\"id\";s:6:\"2479-7\";s:4:\"name\";s:6:\"bridal\";}i:78;a:2:{s:2:\"id\";s:6:\"2479-8\";s:4:\"name\";s:6:\"facial\";}i:79;a:2:{s:2:\"id\";s:6:\"2479-9\";s:4:\"name\";s:4:\"nail\";}i:80;a:2:{s:2:\"id\";s:7:\"2479-10\";s:4:\"name\";s:7:\"stylist\";}i:81;a:2:{s:2:\"id\";s:7:\"2479-11\";s:4:\"name\";s:4:\"skin\";}i:82;a:2:{s:2:\"id\";s:7:\"2479-12\";s:4:\"name\";s:4:\"care\";}i:83;a:2:{s:2:\"id\";s:7:\"2479-13\";s:4:\"name\";s:9:\"cosmetics\";}i:84;a:2:{s:2:\"id\";s:7:\"2479-14\";s:4:\"name\";s:5:\"salon\";}i:85;a:2:{s:2:\"id\";s:7:\"2479-15\";s:4:\"name\";s:6:\"waxing\";}i:86;a:2:{s:2:\"id\";s:7:\"2479-16\";s:4:\"name\";s:6:\"barber\";}i:87;a:2:{s:2:\"id\";s:7:\"2479-17\";s:4:\"name\";s:6:\"makeup\";}i:88;a:2:{s:2:\"id\";s:7:\"2479-18\";s:4:\"name\";s:4:\"hair\";}i:89;a:2:{s:2:\"id\";s:7:\"2479-19\";s:4:\"name\";s:7:\"service\";}i:90;a:2:{s:2:\"id\";s:7:\"2479-20\";s:4:\"name\";s:8:\"services\";}i:91;a:2:{s:2:\"id\";s:7:\"2479-21\";s:4:\"name\";s:8:\"template\";}i:92;a:2:{s:2:\"id\";s:7:\"2479-22\";s:4:\"name\";s:5:\"local\";}i:93;a:2:{s:2:\"id\";s:7:\"2479-23\";s:4:\"name\";s:8:\"business\";}i:94;a:2:{s:2:\"id\";s:7:\"2479-24\";s:4:\"name\";s:5:\"Astra\";}i:95;a:2:{s:2:\"id\";s:7:\"2479-25\";s:4:\"name\";s:7:\"website\";}i:96;a:2:{s:2:\"id\";s:7:\"2479-26\";s:4:\"name\";s:0:\"\";}i:97;a:2:{s:2:\"id\";i:2497;s:4:\"name\";s:4:\"Blog\";}i:98;a:2:{s:2:\"id\";s:6:\"2497-0\";s:4:\"name\";s:7:\"blogger\";}i:99;a:2:{s:2:\"id\";s:6:\"2497-1\";s:4:\"name\";s:4:\"blog\";}i:100;a:2:{s:2:\"id\";s:6:\"2497-2\";s:4:\"name\";s:6:\"author\";}i:101;a:2:{s:2:\"id\";s:6:\"2497-3\";s:4:\"name\";s:4:\"news\";}i:102;a:2:{s:2:\"id\";s:6:\"2497-4\";s:4:\"name\";s:9:\"editorial\";}i:103;a:2:{s:2:\"id\";s:6:\"2497-5\";s:4:\"name\";s:8:\"magazine\";}i:104;a:2:{s:2:\"id\";s:6:\"2497-6\";s:4:\"name\";s:9:\"newspaper\";}i:105;a:2:{s:2:\"id\";s:6:\"2497-7\";s:4:\"name\";s:7:\"vlogger\";}i:106;a:2:{s:2:\"id\";s:6:\"2497-8\";s:4:\"name\";s:8:\"YouTuber\";}i:107;a:2:{s:2:\"id\";s:6:\"2497-9\";s:4:\"name\";s:7:\"podcast\";}i:108;a:2:{s:2:\"id\";s:7:\"2497-10\";s:4:\"name\";s:6:\"online\";}i:109;a:2:{s:2:\"id\";s:7:\"2497-11\";s:4:\"name\";s:8:\"template\";}i:110;a:2:{s:2:\"id\";s:7:\"2497-12\";s:4:\"name\";s:5:\"Astra\";}i:111;a:2:{s:2:\"id\";s:7:\"2497-13\";s:4:\"name\";s:7:\"website\";}i:112;a:2:{s:2:\"id\";s:7:\"2497-14\";s:4:\"name\";s:10:\"influencer\";}i:113;a:2:{s:2:\"id\";s:7:\"2497-15\";s:4:\"name\";s:0:\"\";}i:114;a:2:{s:2:\"id\";i:2495;s:4:\"name\";s:9:\"eCommerce\";}i:115;a:2:{s:2:\"id\";s:6:\"2495-0\";s:4:\"name\";s:11:\"WooCommerce\";}i:116;a:2:{s:2:\"id\";s:6:\"2495-1\";s:4:\"name\";s:10:\"e-commerce\";}i:117;a:2:{s:2:\"id\";s:6:\"2495-2\";s:4:\"name\";s:9:\"eCommerce\";}i:118;a:2:{s:2:\"id\";s:6:\"2495-3\";s:4:\"name\";s:5:\"store\";}i:119;a:2:{s:2:\"id\";s:6:\"2495-4\";s:4:\"name\";s:4:\"shop\";}i:120;a:2:{s:2:\"id\";s:6:\"2495-5\";s:4:\"name\";s:4:\"cart\";}i:121;a:2:{s:2:\"id\";s:6:\"2495-6\";s:4:\"name\";s:8:\"checkout\";}i:122;a:2:{s:2:\"id\";s:6:\"2495-7\";s:4:\"name\";s:8:\"commerce\";}i:123;a:2:{s:2:\"id\";s:6:\"2495-8\";s:4:\"name\";s:12:\"dropshipping\";}i:124;a:2:{s:2:\"id\";s:6:\"2495-9\";s:4:\"name\";s:11:\"fulfillment\";}i:125;a:2:{s:2:\"id\";s:7:\"2495-10\";s:4:\"name\";s:6:\"online\";}i:126;a:2:{s:2:\"id\";s:7:\"2495-11\";s:4:\"name\";s:8:\"template\";}i:127;a:2:{s:2:\"id\";s:7:\"2495-12\";s:4:\"name\";s:5:\"Astra\";}i:128;a:2:{s:2:\"id\";s:7:\"2495-13\";s:4:\"name\";s:7:\"website\";}i:129;a:2:{s:2:\"id\";s:7:\"2495-14\";s:4:\"name\";s:0:\"\";}i:130;a:2:{s:2:\"id\";i:2491;s:4:\"name\";s:22:\"Educational Institutes\";}i:131;a:2:{s:2:\"id\";s:6:\"2491-0\";s:4:\"name\";s:9:\"education\";}i:132;a:2:{s:2:\"id\";s:6:\"2491-1\";s:4:\"name\";s:7:\"college\";}i:133;a:2:{s:2:\"id\";s:6:\"2491-2\";s:4:\"name\";s:10:\"university\";}i:134;a:2:{s:2:\"id\";s:6:\"2491-3\";s:4:\"name\";s:6:\"course\";}i:135;a:2:{s:2:\"id\";s:6:\"2491-4\";s:4:\"name\";s:7:\"courses\";}i:136;a:2:{s:2:\"id\";s:6:\"2491-5\";s:4:\"name\";s:8:\"learning\";}i:137;a:2:{s:2:\"id\";s:6:\"2491-6\";s:4:\"name\";s:5:\"tutor\";}i:138;a:2:{s:2:\"id\";s:6:\"2491-7\";s:4:\"name\";s:10:\"graduation\";}i:139;a:2:{s:2:\"id\";s:6:\"2491-8\";s:4:\"name\";s:8:\"academic\";}i:140;a:2:{s:2:\"id\";s:6:\"2491-9\";s:4:\"name\";s:7:\"library\";}i:141;a:2:{s:2:\"id\";s:7:\"2491-10\";s:4:\"name\";s:8:\"training\";}i:142;a:2:{s:2:\"id\";s:7:\"2491-11\";s:4:\"name\";s:7:\"academy\";}i:143;a:2:{s:2:\"id\";s:7:\"2491-12\";s:4:\"name\";s:5:\"class\";}i:144;a:2:{s:2:\"id\";s:7:\"2491-13\";s:4:\"name\";s:7:\"classes\";}i:145;a:2:{s:2:\"id\";s:7:\"2491-14\";s:4:\"name\";s:12:\"kindergarten\";}i:146;a:2:{s:2:\"id\";s:7:\"2491-15\";s:4:\"name\";s:9:\"preschool\";}i:147;a:2:{s:2:\"id\";s:7:\"2491-16\";s:4:\"name\";s:6:\"school\";}i:148;a:2:{s:2:\"id\";s:7:\"2491-17\";s:4:\"name\";s:9:\"classroom\";}i:149;a:2:{s:2:\"id\";s:7:\"2491-18\";s:4:\"name\";s:7:\"lecture\";}i:150;a:2:{s:2:\"id\";s:7:\"2491-19\";s:4:\"name\";s:7:\"program\";}i:151;a:2:{s:2:\"id\";s:7:\"2491-20\";s:4:\"name\";s:5:\"learn\";}i:152;a:2:{s:2:\"id\";s:7:\"2491-21\";s:4:\"name\";s:7:\"tutions\";}i:153;a:2:{s:2:\"id\";s:7:\"2491-22\";s:4:\"name\";s:8:\"template\";}i:154;a:2:{s:2:\"id\";s:7:\"2491-23\";s:4:\"name\";s:5:\"Astra\";}i:155;a:2:{s:2:\"id\";s:7:\"2491-24\";s:4:\"name\";s:7:\"website\";}i:156;a:2:{s:2:\"id\";s:7:\"2491-25\";s:4:\"name\";s:0:\"\";}i:157;a:2:{s:2:\"id\";i:2494;s:4:\"name\";s:9:\"eLearning\";}i:158;a:2:{s:2:\"id\";s:6:\"2494-0\";s:4:\"name\";s:8:\"Learning\";}i:159;a:2:{s:2:\"id\";s:6:\"2494-1\";s:4:\"name\";s:8:\"Learning\";}i:160;a:2:{s:2:\"id\";s:6:\"2494-2\";s:4:\"name\";s:10:\"e-Learning\";}i:161;a:2:{s:2:\"id\";s:6:\"2494-3\";s:4:\"name\";s:9:\"LearnDash\";}i:162;a:2:{s:2:\"id\";s:6:\"2494-4\";s:4:\"name\";s:8:\"Template\";}i:163;a:2:{s:2:\"id\";s:6:\"2494-5\";s:4:\"name\";s:7:\"Website\";}i:164;a:2:{s:2:\"id\";s:6:\"2494-6\";s:4:\"name\";s:4:\"Site\";}i:165;a:2:{s:2:\"id\";s:6:\"2494-7\";s:4:\"name\";s:3:\"LMS\";}i:166;a:2:{s:2:\"id\";s:6:\"2494-8\";s:4:\"name\";s:6:\"Course\";}i:167;a:2:{s:2:\"id\";s:6:\"2494-9\";s:4:\"name\";s:7:\"Courses\";}i:168;a:2:{s:2:\"id\";s:7:\"2494-10\";s:4:\"name\";s:9:\"education\";}i:169;a:2:{s:2:\"id\";s:7:\"2494-11\";s:4:\"name\";s:11:\"masterclass\";}i:170;a:2:{s:2:\"id\";s:7:\"2494-12\";s:4:\"name\";s:6:\"online\";}i:171;a:2:{s:2:\"id\";s:7:\"2494-13\";s:4:\"name\";s:8:\"template\";}i:172;a:2:{s:2:\"id\";s:7:\"2494-14\";s:4:\"name\";s:5:\"Astra\";}i:173;a:2:{s:2:\"id\";s:7:\"2494-15\";s:4:\"name\";s:7:\"website\";}i:174;a:2:{s:2:\"id\";s:7:\"2494-16\";s:4:\"name\";s:0:\"\";}i:175;a:2:{s:2:\"id\";i:2489;s:4:\"name\";s:16:\"Event Invitation\";}i:176;a:2:{s:2:\"id\";s:6:\"2489-0\";s:4:\"name\";s:5:\"event\";}i:177;a:2:{s:2:\"id\";s:6:\"2489-1\";s:4:\"name\";s:7:\"wedding\";}i:178;a:2:{s:2:\"id\";s:6:\"2489-2\";s:4:\"name\";s:7:\"planner\";}i:179;a:2:{s:2:\"id\";s:6:\"2489-3\";s:4:\"name\";s:8:\"catering\";}i:180;a:2:{s:2:\"id\";s:6:\"2489-4\";s:4:\"name\";s:5:\"party\";}i:181;a:2:{s:2:\"id\";s:6:\"2489-5\";s:4:\"name\";s:8:\"birthday\";}i:182;a:2:{s:2:\"id\";s:6:\"2489-6\";s:4:\"name\";s:11:\"anniversary\";}i:183;a:2:{s:2:\"id\";s:6:\"2489-7\";s:4:\"name\";s:10:\"conference\";}i:184;a:2:{s:2:\"id\";s:6:\"2489-8\";s:4:\"name\";s:6:\"meetup\";}i:185;a:2:{s:2:\"id\";s:6:\"2489-9\";s:4:\"name\";s:7:\"meet up\";}i:186;a:2:{s:2:\"id\";s:7:\"2489-10\";s:4:\"name\";s:9:\"organizer\";}i:187;a:2:{s:2:\"id\";s:7:\"2489-11\";s:4:\"name\";s:7:\"concert\";}i:188;a:2:{s:2:\"id\";s:7:\"2489-12\";s:4:\"name\";s:11:\"celebration\";}i:189;a:2:{s:2:\"id\";s:7:\"2489-13\";s:4:\"name\";s:12:\"celebrations\";}i:190;a:2:{s:2:\"id\";s:7:\"2489-14\";s:4:\"name\";s:5:\"venue\";}i:191;a:2:{s:2:\"id\";s:7:\"2489-15\";s:4:\"name\";s:10:\"invitation\";}i:192;a:2:{s:2:\"id\";s:7:\"2489-16\";s:4:\"name\";s:8:\"template\";}i:193;a:2:{s:2:\"id\";s:7:\"2489-17\";s:4:\"name\";s:5:\"Astra\";}i:194;a:2:{s:2:\"id\";s:7:\"2489-18\";s:4:\"name\";s:7:\"company\";}i:195;a:2:{s:2:\"id\";s:7:\"2489-19\";s:4:\"name\";s:7:\"website\";}i:196;a:2:{s:2:\"id\";s:7:\"2489-20\";s:4:\"name\";s:0:\"\";}i:197;a:2:{s:2:\"id\";i:2483;s:4:\"name\";s:15:\"Expert Services\";}i:198;a:2:{s:2:\"id\";s:6:\"2483-0\";s:4:\"name\";s:8:\"personal\";}i:199;a:2:{s:2:\"id\";s:6:\"2483-1\";s:4:\"name\";s:5:\"coach\";}i:200;a:2:{s:2:\"id\";s:6:\"2483-2\";s:4:\"name\";s:8:\"coaching\";}i:201;a:2:{s:2:\"id\";s:6:\"2483-3\";s:4:\"name\";s:10:\"counseling\";}i:202;a:2:{s:2:\"id\";s:6:\"2483-4\";s:4:\"name\";s:12:\"relationship\";}i:203;a:2:{s:2:\"id\";s:6:\"2483-5\";s:4:\"name\";s:4:\"life\";}i:204;a:2:{s:2:\"id\";s:6:\"2483-6\";s:4:\"name\";s:12:\"motivational\";}i:205;a:2:{s:2:\"id\";s:6:\"2483-7\";s:4:\"name\";s:7:\"speaker\";}i:206;a:2:{s:2:\"id\";s:6:\"2483-8\";s:4:\"name\";s:10:\"influencer\";}i:207;a:2:{s:2:\"id\";s:6:\"2483-9\";s:4:\"name\";s:12:\"entrepreneur\";}i:208;a:2:{s:2:\"id\";s:7:\"2483-10\";s:4:\"name\";s:7:\"service\";}i:209;a:2:{s:2:\"id\";s:7:\"2483-11\";s:4:\"name\";s:8:\"services\";}i:210;a:2:{s:2:\"id\";s:7:\"2483-12\";s:4:\"name\";s:8:\"template\";}i:211;a:2:{s:2:\"id\";s:7:\"2483-13\";s:4:\"name\";s:8:\"business\";}i:212;a:2:{s:2:\"id\";s:7:\"2483-14\";s:4:\"name\";s:5:\"Astra\";}i:213;a:2:{s:2:\"id\";s:7:\"2483-15\";s:4:\"name\";s:10:\"consulting\";}i:214;a:2:{s:2:\"id\";s:7:\"2483-16\";s:4:\"name\";s:10:\"consultant\";}i:215;a:2:{s:2:\"id\";s:7:\"2483-17\";s:4:\"name\";s:7:\"website\";}i:216;a:2:{s:2:\"id\";s:7:\"2483-18\";s:4:\"name\";s:12:\"professional\";}i:217;a:2:{s:2:\"id\";s:7:\"2483-19\";s:4:\"name\";s:21:\"professional services\";}i:218;a:2:{s:2:\"id\";s:7:\"2483-20\";s:4:\"name\";s:0:\"\";}i:219;a:2:{s:2:\"id\";i:2481;s:4:\"name\";s:15:\"Finance Service\";}i:220;a:2:{s:2:\"id\";s:6:\"2481-0\";s:4:\"name\";s:7:\"finance\";}i:221;a:2:{s:2:\"id\";s:6:\"2481-1\";s:4:\"name\";s:9:\"financial\";}i:222;a:2:{s:2:\"id\";s:6:\"2481-2\";s:4:\"name\";s:10:\"investment\";}i:223;a:2:{s:2:\"id\";s:6:\"2481-3\";s:4:\"name\";s:10:\"accountant\";}i:224;a:2:{s:2:\"id\";s:6:\"2481-4\";s:4:\"name\";s:10:\"accounting\";}i:225;a:2:{s:2:\"id\";s:6:\"2481-5\";s:4:\"name\";s:9:\"insurance\";}i:226;a:2:{s:2:\"id\";s:6:\"2481-6\";s:4:\"name\";s:8:\"advisory\";}i:227;a:2:{s:2:\"id\";s:6:\"2481-7\";s:4:\"name\";s:7:\"finance\";}i:228;a:2:{s:2:\"id\";s:6:\"2481-8\";s:4:\"name\";s:9:\"chartered\";}i:229;a:2:{s:2:\"id\";s:6:\"2481-9\";s:4:\"name\";s:3:\"CPA\";}i:230;a:2:{s:2:\"id\";s:7:\"2481-10\";s:4:\"name\";s:9:\"corporate\";}i:231;a:2:{s:2:\"id\";s:7:\"2481-11\";s:4:\"name\";s:3:\"tax\";}i:232;a:2:{s:2:\"id\";s:7:\"2481-12\";s:4:\"name\";s:8:\"advisory\";}i:233;a:2:{s:2:\"id\";s:7:\"2481-13\";s:4:\"name\";s:7:\"banking\";}i:234;a:2:{s:2:\"id\";s:7:\"2481-14\";s:4:\"name\";s:7:\"adviser\";}i:235;a:2:{s:2:\"id\";s:7:\"2481-15\";s:4:\"name\";s:7:\"service\";}i:236;a:2:{s:2:\"id\";s:7:\"2481-16\";s:4:\"name\";s:8:\"services\";}i:237;a:2:{s:2:\"id\";s:7:\"2481-17\";s:4:\"name\";s:8:\"template\";}i:238;a:2:{s:2:\"id\";s:7:\"2481-18\";s:4:\"name\";s:8:\"business\";}i:239;a:2:{s:2:\"id\";s:7:\"2481-19\";s:4:\"name\";s:5:\"Astra\";}i:240;a:2:{s:2:\"id\";s:7:\"2481-20\";s:4:\"name\";s:10:\"consulting\";}i:241;a:2:{s:2:\"id\";s:7:\"2481-21\";s:4:\"name\";s:10:\"consultant\";}i:242;a:2:{s:2:\"id\";s:7:\"2481-22\";s:4:\"name\";s:7:\"company\";}i:243;a:2:{s:2:\"id\";s:7:\"2481-23\";s:4:\"name\";s:7:\"website\";}i:244;a:2:{s:2:\"id\";s:7:\"2481-24\";s:4:\"name\";s:0:\"\";}i:245;a:2:{s:2:\"id\";i:2480;s:4:\"name\";s:18:\"Fitness & Wellness\";}i:246;a:2:{s:2:\"id\";s:6:\"2480-0\";s:4:\"name\";s:7:\"trainer\";}i:247;a:2:{s:2:\"id\";s:6:\"2480-1\";s:4:\"name\";s:10:\"instructor\";}i:248;a:2:{s:2:\"id\";s:6:\"2480-2\";s:4:\"name\";s:9:\"dietitian\";}i:249;a:2:{s:2:\"id\";s:6:\"2480-3\";s:4:\"name\";s:10:\"meditation\";}i:250;a:2:{s:2:\"id\";s:6:\"2480-4\";s:4:\"name\";s:12:\"nutritionist\";}i:251;a:2:{s:2:\"id\";s:6:\"2480-5\";s:4:\"name\";s:4:\"yoga\";}i:252;a:2:{s:2:\"id\";s:6:\"2480-6\";s:4:\"name\";s:7:\"fitness\";}i:253;a:2:{s:2:\"id\";s:6:\"2480-7\";s:4:\"name\";s:3:\"gym\";}i:254;a:2:{s:2:\"id\";s:6:\"2480-8\";s:4:\"name\";s:9:\"gymnasium\";}i:255;a:2:{s:2:\"id\";s:6:\"2480-9\";s:4:\"name\";s:9:\"athletics\";}i:256;a:2:{s:2:\"id\";s:7:\"2480-10\";s:4:\"name\";s:6:\"health\";}i:257;a:2:{s:2:\"id\";s:7:\"2480-11\";s:4:\"name\";s:7:\"service\";}i:258;a:2:{s:2:\"id\";s:7:\"2480-12\";s:4:\"name\";s:8:\"services\";}i:259;a:2:{s:2:\"id\";s:7:\"2480-13\";s:4:\"name\";s:8:\"template\";}i:260;a:2:{s:2:\"id\";s:7:\"2480-14\";s:4:\"name\";s:5:\"local\";}i:261;a:2:{s:2:\"id\";s:7:\"2480-15\";s:4:\"name\";s:8:\"business\";}i:262;a:2:{s:2:\"id\";s:7:\"2480-16\";s:4:\"name\";s:5:\"Astra\";}i:263;a:2:{s:2:\"id\";s:7:\"2480-17\";s:4:\"name\";s:10:\"consulting\";}i:264;a:2:{s:2:\"id\";s:7:\"2480-18\";s:4:\"name\";s:10:\"consultant\";}i:265;a:2:{s:2:\"id\";s:7:\"2480-19\";s:4:\"name\";s:7:\"website\";}i:266;a:2:{s:2:\"id\";s:7:\"2480-20\";s:4:\"name\";s:0:\"\";}i:267;a:2:{s:2:\"id\";i:2476;s:4:\"name\";s:9:\"Gardening\";}i:268;a:2:{s:2:\"id\";s:6:\"2476-0\";s:4:\"name\";s:6:\"garden\";}i:269;a:2:{s:2:\"id\";s:6:\"2476-1\";s:4:\"name\";s:7:\"florist\";}i:270;a:2:{s:2:\"id\";s:6:\"2476-2\";s:4:\"name\";s:8:\"gardener\";}i:271;a:2:{s:2:\"id\";s:6:\"2476-3\";s:4:\"name\";s:9:\"gardening\";}i:272;a:2:{s:2:\"id\";s:6:\"2476-4\";s:4:\"name\";s:9:\"landscape\";}i:273;a:2:{s:2:\"id\";s:6:\"2476-5\";s:4:\"name\";s:11:\"landscaping\";}i:274;a:2:{s:2:\"id\";s:6:\"2476-6\";s:4:\"name\";s:9:\"lawn care\";}i:275;a:2:{s:2:\"id\";s:6:\"2476-7\";s:4:\"name\";s:9:\"botanical\";}i:276;a:2:{s:2:\"id\";s:6:\"2476-8\";s:4:\"name\";s:7:\"service\";}i:277;a:2:{s:2:\"id\";s:6:\"2476-9\";s:4:\"name\";s:8:\"services\";}i:278;a:2:{s:2:\"id\";s:7:\"2476-10\";s:4:\"name\";s:8:\"template\";}i:279;a:2:{s:2:\"id\";s:7:\"2476-11\";s:4:\"name\";s:5:\"local\";}i:280;a:2:{s:2:\"id\";s:7:\"2476-12\";s:4:\"name\";s:8:\"business\";}i:281;a:2:{s:2:\"id\";s:7:\"2476-13\";s:4:\"name\";s:5:\"Astra\";}i:282;a:2:{s:2:\"id\";s:7:\"2476-14\";s:4:\"name\";s:4:\"shop\";}i:283;a:2:{s:2:\"id\";s:7:\"2476-15\";s:4:\"name\";s:7:\"company\";}i:284;a:2:{s:2:\"id\";s:7:\"2476-16\";s:4:\"name\";s:6:\"repair\";}i:285;a:2:{s:2:\"id\";s:7:\"2476-17\";s:4:\"name\";s:7:\"website\";}i:286;a:2:{s:2:\"id\";s:7:\"2476-18\";s:4:\"name\";s:6:\"Flower\";}i:287;a:2:{s:2:\"id\";s:7:\"2476-19\";s:4:\"name\";s:0:\"\";}i:288;a:2:{s:2:\"id\";i:2490;s:4:\"name\";s:10:\"Healthcare\";}i:289;a:2:{s:2:\"id\";s:6:\"2490-0\";s:4:\"name\";s:6:\"dental\";}i:290;a:2:{s:2:\"id\";s:6:\"2490-1\";s:4:\"name\";s:5:\"teeth\";}i:291;a:2:{s:2:\"id\";s:6:\"2490-2\";s:4:\"name\";s:11:\"acupuncture\";}i:292;a:2:{s:2:\"id\";s:6:\"2490-3\";s:4:\"name\";s:9:\"treatment\";}i:293;a:2:{s:2:\"id\";s:6:\"2490-4\";s:4:\"name\";s:7:\"dentist\";}i:294;a:2:{s:2:\"id\";s:6:\"2490-5\";s:4:\"name\";s:8:\"diabetes\";}i:295;a:2:{s:2:\"id\";s:6:\"2490-6\";s:4:\"name\";s:9:\"diagnosis\";}i:296;a:2:{s:2:\"id\";s:6:\"2490-7\";s:4:\"name\";s:6:\"doctor\";}i:297;a:2:{s:2:\"id\";s:6:\"2490-8\";s:4:\"name\";s:3:\"eye\";}i:298;a:2:{s:2:\"id\";s:6:\"2490-9\";s:4:\"name\";s:4:\"care\";}i:299;a:2:{s:2:\"id\";s:7:\"2490-10\";s:4:\"name\";s:12:\"psychologist\";}i:300;a:2:{s:2:\"id\";s:7:\"2490-11\";s:4:\"name\";s:7:\"surgeon\";}i:301;a:2:{s:2:\"id\";s:7:\"2490-12\";s:4:\"name\";s:6:\"health\";}i:302;a:2:{s:2:\"id\";s:7:\"2490-13\";s:4:\"name\";s:11:\"homeopathic\";}i:303;a:2:{s:2:\"id\";s:7:\"2490-14\";s:4:\"name\";s:6:\"mental\";}i:304;a:2:{s:2:\"id\";s:7:\"2490-15\";s:4:\"name\";s:11:\"neurologist\";}i:305;a:2:{s:2:\"id\";s:7:\"2490-16\";s:4:\"name\";s:12:\"orthodontist\";}i:306;a:2:{s:2:\"id\";s:7:\"2490-17\";s:4:\"name\";s:7:\"medical\";}i:307;a:2:{s:2:\"id\";s:7:\"2490-18\";s:4:\"name\";s:12:\"psychiatrist\";}i:308;a:2:{s:2:\"id\";s:7:\"2490-19\";s:4:\"name\";s:12:\"pediatrician\";}i:309;a:2:{s:2:\"id\";s:7:\"2490-20\";s:4:\"name\";s:4:\"skin\";}i:310;a:2:{s:2:\"id\";s:7:\"2490-21\";s:4:\"name\";s:7:\"dentist\";}i:311;a:2:{s:2:\"id\";s:7:\"2490-22\";s:4:\"name\";s:6:\"health\";}i:312;a:2:{s:2:\"id\";s:7:\"2490-23\";s:4:\"name\";s:7:\"medical\";}i:313;a:2:{s:2:\"id\";s:7:\"2490-24\";s:4:\"name\";s:3:\"lab\";}i:314;a:2:{s:2:\"id\";s:7:\"2490-25\";s:4:\"name\";s:8:\"hospital\";}i:315;a:2:{s:2:\"id\";s:7:\"2490-26\";s:4:\"name\";s:9:\"therapist\";}i:316;a:2:{s:2:\"id\";s:7:\"2490-27\";s:4:\"name\";s:8:\"template\";}i:317;a:2:{s:2:\"id\";s:7:\"2490-28\";s:4:\"name\";s:8:\"business\";}i:318;a:2:{s:2:\"id\";s:7:\"2490-29\";s:4:\"name\";s:5:\"Astra\";}i:319;a:2:{s:2:\"id\";s:7:\"2490-30\";s:4:\"name\";s:10:\"consulting\";}i:320;a:2:{s:2:\"id\";s:7:\"2490-31\";s:4:\"name\";s:10:\"consultant\";}i:321;a:2:{s:2:\"id\";s:7:\"2490-32\";s:4:\"name\";s:7:\"website\";}i:322;a:2:{s:2:\"id\";s:7:\"2490-33\";s:4:\"name\";s:0:\"\";}i:323;a:2:{s:2:\"id\";i:2477;s:4:\"name\";s:13:\"Home Services\";}i:324;a:2:{s:2:\"id\";s:6:\"2477-0\";s:4:\"name\";s:8:\"cleaning\";}i:325;a:2:{s:2:\"id\";s:6:\"2477-1\";s:4:\"name\";s:13:\"home cleaning\";}i:326;a:2:{s:2:\"id\";s:6:\"2477-2\";s:4:\"name\";s:15:\"office cleaning\";}i:327;a:2:{s:2:\"id\";s:6:\"2477-3\";s:4:\"name\";s:20:\"residential cleaning\";}i:328;a:2:{s:2:\"id\";s:6:\"2477-4\";s:4:\"name\";s:4:\"maid\";}i:329;a:2:{s:2:\"id\";s:6:\"2477-5\";s:4:\"name\";s:6:\"carpet\";}i:330;a:2:{s:2:\"id\";s:6:\"2477-6\";s:4:\"name\";s:10:\"babysitter\";}i:331;a:2:{s:2:\"id\";s:6:\"2477-7\";s:4:\"name\";s:11:\"babysitting\";}i:332;a:2:{s:2:\"id\";s:6:\"2477-8\";s:4:\"name\";s:7:\"laundry\";}i:333;a:2:{s:2:\"id\";s:6:\"2477-9\";s:4:\"name\";s:4:\"pest\";}i:334;a:2:{s:2:\"id\";s:7:\"2477-10\";s:4:\"name\";s:7:\"painter\";}i:335;a:2:{s:2:\"id\";s:7:\"2477-11\";s:4:\"name\";s:8:\"painting\";}i:336;a:2:{s:2:\"id\";s:7:\"2477-12\";s:4:\"name\";s:14:\"security guard\";}i:337;a:2:{s:2:\"id\";s:7:\"2477-13\";s:4:\"name\";s:7:\"service\";}i:338;a:2:{s:2:\"id\";s:7:\"2477-14\";s:4:\"name\";s:8:\"services\";}i:339;a:2:{s:2:\"id\";s:7:\"2477-15\";s:4:\"name\";s:8:\"template\";}i:340;a:2:{s:2:\"id\";s:7:\"2477-16\";s:4:\"name\";s:5:\"local\";}i:341;a:2:{s:2:\"id\";s:7:\"2477-17\";s:4:\"name\";s:8:\"business\";}i:342;a:2:{s:2:\"id\";s:7:\"2477-18\";s:4:\"name\";s:5:\"Astra\";}i:343;a:2:{s:2:\"id\";s:7:\"2477-19\";s:4:\"name\";s:4:\"shop\";}i:344;a:2:{s:2:\"id\";s:7:\"2477-20\";s:4:\"name\";s:7:\"company\";}i:345;a:2:{s:2:\"id\";s:7:\"2477-21\";s:4:\"name\";s:6:\"repair\";}i:346;a:2:{s:2:\"id\";s:7:\"2477-22\";s:4:\"name\";s:7:\"website\";}i:347;a:2:{s:2:\"id\";s:7:\"2477-23\";s:4:\"name\";s:0:\"\";}i:348;a:2:{s:2:\"id\";i:2498;s:4:\"name\";s:14:\"Hotel & Travel\";}i:349;a:2:{s:2:\"id\";s:6:\"2498-0\";s:4:\"name\";s:3:\"inn\";}i:350;a:2:{s:2:\"id\";s:6:\"2498-1\";s:4:\"name\";s:5:\"motel\";}i:351;a:2:{s:2:\"id\";s:6:\"2498-2\";s:4:\"name\";s:8:\"boarding\";}i:352;a:2:{s:2:\"id\";s:6:\"2498-3\";s:4:\"name\";s:5:\"guest\";}i:353;a:2:{s:2:\"id\";s:6:\"2498-4\";s:4:\"name\";s:5:\"lodge\";}i:354;a:2:{s:2:\"id\";s:6:\"2498-5\";s:4:\"name\";s:17:\"bed and breakfast\";}i:355;a:2:{s:2:\"id\";s:6:\"2498-6\";s:4:\"name\";s:3:\"b&b\";}i:356;a:2:{s:2:\"id\";s:6:\"2498-7\";s:4:\"name\";s:3:\"bnb\";}i:357;a:2:{s:2:\"id\";s:6:\"2498-8\";s:4:\"name\";s:6:\"hostel\";}i:358;a:2:{s:2:\"id\";s:6:\"2498-9\";s:4:\"name\";s:10:\"aparthotel\";}i:359;a:2:{s:2:\"id\";s:7:\"2498-10\";s:4:\"name\";s:6:\"boatel\";}i:360;a:2:{s:2:\"id\";s:7:\"2498-11\";s:4:\"name\";s:13:\"accommodation\";}i:361;a:2:{s:2:\"id\";s:7:\"2498-12\";s:4:\"name\";s:5:\"hotel\";}i:362;a:2:{s:2:\"id\";s:7:\"2498-13\";s:4:\"name\";s:10:\"guesthouse\";}i:363;a:2:{s:2:\"id\";s:7:\"2498-14\";s:4:\"name\";s:8:\"homestay\";}i:364;a:2:{s:2:\"id\";s:7:\"2498-15\";s:4:\"name\";s:6:\"resort\";}i:365;a:2:{s:2:\"id\";s:7:\"2498-16\";s:4:\"name\";s:7:\"camping\";}i:366;a:2:{s:2:\"id\";s:7:\"2498-17\";s:4:\"name\";s:8:\"heritage\";}i:367;a:2:{s:2:\"id\";s:7:\"2498-18\";s:4:\"name\";s:7:\"lodging\";}i:368;a:2:{s:2:\"id\";s:7:\"2498-19\";s:4:\"name\";s:8:\"template\";}i:369;a:2:{s:2:\"id\";s:7:\"2498-20\";s:4:\"name\";s:8:\"business\";}i:370;a:2:{s:2:\"id\";s:7:\"2498-21\";s:4:\"name\";s:5:\"Astra\";}i:371;a:2:{s:2:\"id\";s:7:\"2498-22\";s:4:\"name\";s:7:\"website\";}i:372;a:2:{s:2:\"id\";s:7:\"2498-23\";s:4:\"name\";s:0:\"\";}i:373;a:2:{s:2:\"id\";i:2482;s:4:\"name\";s:3:\"Law\";}i:374;a:2:{s:2:\"id\";s:6:\"2482-0\";s:4:\"name\";s:3:\"law\";}i:375;a:2:{s:2:\"id\";s:6:\"2482-1\";s:4:\"name\";s:6:\"lawyer\";}i:376;a:2:{s:2:\"id\";s:6:\"2482-2\";s:4:\"name\";s:8:\"criminal\";}i:377;a:2:{s:2:\"id\";s:6:\"2482-3\";s:4:\"name\";s:7:\"defense\";}i:378;a:2:{s:2:\"id\";s:6:\"2482-4\";s:4:\"name\";s:7:\"lawyers\";}i:379;a:2:{s:2:\"id\";s:6:\"2482-5\";s:4:\"name\";s:6:\"injury\";}i:380;a:2:{s:2:\"id\";s:6:\"2482-6\";s:4:\"name\";s:11:\"immigration\";}i:381;a:2:{s:2:\"id\";s:6:\"2482-7\";s:4:\"name\";s:12:\"compensation\";}i:382;a:2:{s:2:\"id\";s:6:\"2482-8\";s:4:\"name\";s:10:\"litigation\";}i:383;a:2:{s:2:\"id\";s:6:\"2482-9\";s:4:\"name\";s:5:\"civil\";}i:384;a:2:{s:2:\"id\";s:7:\"2482-10\";s:4:\"name\";s:8:\"advocate\";}i:385;a:2:{s:2:\"id\";s:7:\"2482-11\";s:4:\"name\";s:9:\"counselor\";}i:386;a:2:{s:2:\"id\";s:7:\"2482-12\";s:4:\"name\";s:8:\"accident\";}i:387;a:2:{s:2:\"id\";s:7:\"2482-13\";s:4:\"name\";s:7:\"divorce\";}i:388;a:2:{s:2:\"id\";s:7:\"2482-14\";s:4:\"name\";s:5:\"legal\";}i:389;a:2:{s:2:\"id\";s:7:\"2482-15\";s:4:\"name\";s:9:\"solicitor\";}i:390;a:2:{s:2:\"id\";s:7:\"2482-16\";s:4:\"name\";s:8:\"attorney\";}i:391;a:2:{s:2:\"id\";s:7:\"2482-17\";s:4:\"name\";s:14:\"representative\";}i:392;a:2:{s:2:\"id\";s:7:\"2482-18\";s:4:\"name\";s:10:\"employment\";}i:393;a:2:{s:2:\"id\";s:7:\"2482-19\";s:4:\"name\";s:4:\"firm\";}i:394;a:2:{s:2:\"id\";s:7:\"2482-20\";s:4:\"name\";s:8:\"services\";}i:395;a:2:{s:2:\"id\";s:7:\"2482-21\";s:4:\"name\";s:7:\"service\";}i:396;a:2:{s:2:\"id\";s:7:\"2482-22\";s:4:\"name\";s:8:\"template\";}i:397;a:2:{s:2:\"id\";s:7:\"2482-23\";s:4:\"name\";s:8:\"business\";}i:398;a:2:{s:2:\"id\";s:7:\"2482-24\";s:4:\"name\";s:5:\"Astra\";}i:399;a:2:{s:2:\"id\";s:7:\"2482-25\";s:4:\"name\";s:10:\"consulting\";}i:400;a:2:{s:2:\"id\";s:7:\"2482-26\";s:4:\"name\";s:10:\"consultant\";}i:401;a:2:{s:2:\"id\";s:7:\"2482-27\";s:4:\"name\";s:7:\"website\";}i:402;a:2:{s:2:\"id\";s:7:\"2482-28\";s:4:\"name\";s:0:\"\";}i:403;a:2:{s:2:\"id\";i:2478;s:4:\"name\";s:17:\"Local Storefronts\";}i:404;a:2:{s:2:\"id\";s:6:\"2478-0\";s:4:\"name\";s:5:\"store\";}i:405;a:2:{s:2:\"id\";s:6:\"2478-1\";s:4:\"name\";s:4:\"shop\";}i:406;a:2:{s:2:\"id\";s:6:\"2478-2\";s:4:\"name\";s:10:\"storefront\";}i:407;a:2:{s:2:\"id\";s:6:\"2478-3\";s:4:\"name\";s:16:\"brick and mortar\";}i:408;a:2:{s:2:\"id\";s:6:\"2478-4\";s:4:\"name\";s:6:\"retail\";}i:409;a:2:{s:2:\"id\";s:6:\"2478-5\";s:4:\"name\";s:12:\"departmental\";}i:410;a:2:{s:2:\"id\";s:6:\"2478-6\";s:4:\"name\";s:9:\"shopfront\";}i:411;a:2:{s:2:\"id\";s:6:\"2478-7\";s:4:\"name\";s:4:\"gift\";}i:412;a:2:{s:2:\"id\";s:6:\"2478-8\";s:4:\"name\";s:10:\"bookstores\";}i:413;a:2:{s:2:\"id\";s:6:\"2478-9\";s:4:\"name\";s:0:\"\";}i:414;a:2:{s:2:\"id\";i:2471;s:4:\"name\";s:16:\"Local Technician\";}i:415;a:2:{s:2:\"id\";s:6:\"2471-0\";s:4:\"name\";s:5:\"local\";}i:416;a:2:{s:2:\"id\";s:6:\"2471-1\";s:4:\"name\";s:10:\"technician\";}i:417;a:2:{s:2:\"id\";s:6:\"2471-2\";s:4:\"name\";s:8:\"air duct\";}i:418;a:2:{s:2:\"id\";s:6:\"2471-3\";s:4:\"name\";s:9:\"carpenter\";}i:419;a:2:{s:2:\"id\";s:6:\"2471-4\";s:4:\"name\";s:4:\"CCTV\";}i:420;a:2:{s:2:\"id\";s:6:\"2471-5\";s:4:\"name\";s:11:\"electrician\";}i:421;a:2:{s:2:\"id\";s:6:\"2471-6\";s:4:\"name\";s:9:\"furniture\";}i:422;a:2:{s:2:\"id\";s:6:\"2471-7\";s:4:\"name\";s:8:\"handyman\";}i:423;a:2:{s:2:\"id\";s:6:\"2471-8\";s:4:\"name\";s:10:\"remodeling\";}i:424;a:2:{s:2:\"id\";s:6:\"2471-9\";s:4:\"name\";s:4:\"HVAC\";}i:425;a:2:{s:2:\"id\";s:7:\"2471-10\";s:4:\"name\";s:9:\"locksmith\";}i:426;a:2:{s:2:\"id\";s:7:\"2471-11\";s:4:\"name\";s:7:\"plumber\";}i:427;a:2:{s:2:\"id\";s:7:\"2471-12\";s:4:\"name\";s:8:\"plumbing\";}i:428;a:2:{s:2:\"id\";s:7:\"2471-13\";s:4:\"name\";s:8:\"swimming\";}i:429;a:2:{s:2:\"id\";s:7:\"2471-14\";s:4:\"name\";s:4:\"pool\";}i:430;a:2:{s:2:\"id\";s:7:\"2471-15\";s:4:\"name\";s:7:\"roofing\";}i:431;a:2:{s:2:\"id\";s:7:\"2471-16\";s:4:\"name\";s:6:\"window\";}i:432;a:2:{s:2:\"id\";s:7:\"2471-17\";s:4:\"name\";s:12:\"installation\";}i:433;a:2:{s:2:\"id\";s:7:\"2471-18\";s:4:\"name\";s:11:\"maintenance\";}i:434;a:2:{s:2:\"id\";s:7:\"2471-19\";s:4:\"name\";s:6:\"worker\";}i:435;a:2:{s:2:\"id\";s:7:\"2471-20\";s:4:\"name\";s:8:\"services\";}i:436;a:2:{s:2:\"id\";s:7:\"2471-21\";s:4:\"name\";s:7:\"service\";}i:437;a:2:{s:2:\"id\";s:7:\"2471-22\";s:4:\"name\";s:8:\"template\";}i:438;a:2:{s:2:\"id\";s:7:\"2471-23\";s:4:\"name\";s:8:\"business\";}i:439;a:2:{s:2:\"id\";s:7:\"2471-24\";s:4:\"name\";s:5:\"Astra\";}i:440;a:2:{s:2:\"id\";s:7:\"2471-25\";s:4:\"name\";s:7:\"company\";}i:441;a:2:{s:2:\"id\";s:7:\"2471-26\";s:4:\"name\";s:6:\"repair\";}i:442;a:2:{s:2:\"id\";s:7:\"2471-27\";s:4:\"name\";s:7:\"website\";}i:443;a:2:{s:2:\"id\";s:7:\"2471-28\";s:4:\"name\";s:0:\"\";}i:444;a:2:{s:2:\"id\";i:2474;s:4:\"name\";s:13:\"Manufacturing\";}i:445;a:2:{s:2:\"id\";s:6:\"2474-0\";s:4:\"name\";s:8:\"industry\";}i:446;a:2:{s:2:\"id\";s:6:\"2474-1\";s:4:\"name\";s:23:\"industrial manufacturer\";}i:447;a:2:{s:2:\"id\";s:6:\"2474-2\";s:4:\"name\";s:13:\"manufacturing\";}i:448;a:2:{s:2:\"id\";s:6:\"2474-3\";s:4:\"name\";s:8:\"mechanic\";}i:449;a:2:{s:2:\"id\";s:6:\"2474-4\";s:4:\"name\";s:14:\"pharmaceutical\";}i:450;a:2:{s:2:\"id\";s:6:\"2474-5\";s:4:\"name\";s:8:\"template\";}i:451;a:2:{s:2:\"id\";s:6:\"2474-6\";s:4:\"name\";s:5:\"local\";}i:452;a:2:{s:2:\"id\";s:6:\"2474-7\";s:4:\"name\";s:8:\"business\";}i:453;a:2:{s:2:\"id\";s:6:\"2474-8\";s:4:\"name\";s:5:\"Astra\";}i:454;a:2:{s:2:\"id\";s:6:\"2474-9\";s:4:\"name\";s:7:\"company\";}i:455;a:2:{s:2:\"id\";s:7:\"2474-10\";s:4:\"name\";s:7:\"website\";}i:456;a:2:{s:2:\"id\";s:7:\"2474-11\";s:4:\"name\";s:0:\"\";}i:457;a:2:{s:2:\"id\";i:2500;s:4:\"name\";s:12:\"Multipurpose\";}i:458;a:2:{s:2:\"id\";s:6:\"2500-0\";s:4:\"name\";s:5:\"clean\";}i:459;a:2:{s:2:\"id\";s:6:\"2500-1\";s:4:\"name\";s:7:\"minimal\";}i:460;a:2:{s:2:\"id\";s:6:\"2500-2\";s:4:\"name\";s:12:\"multipurpose\";}i:461;a:2:{s:2:\"id\";s:6:\"2500-3\";s:4:\"name\";s:6:\"simple\";}i:462;a:2:{s:2:\"id\";s:6:\"2500-4\";s:4:\"name\";s:7:\"generic\";}i:463;a:2:{s:2:\"id\";i:2492;s:4:\"name\";s:10:\"Non Profit\";}i:464;a:2:{s:2:\"id\";s:6:\"2492-0\";s:4:\"name\";s:7:\"charity\";}i:465;a:2:{s:2:\"id\";s:6:\"2492-1\";s:4:\"name\";s:12:\"organization\";}i:466;a:2:{s:2:\"id\";s:6:\"2492-2\";s:4:\"name\";s:6:\"church\";}i:467;a:2:{s:2:\"id\";s:6:\"2492-3\";s:4:\"name\";s:9:\"nonprofit\";}i:468;a:2:{s:2:\"id\";s:6:\"2492-4\";s:4:\"name\";s:3:\"NGO\";}i:469;a:2:{s:2:\"id\";s:6:\"2492-5\";s:4:\"name\";s:5:\"event\";}i:470;a:2:{s:2:\"id\";s:6:\"2492-6\";s:4:\"name\";s:12:\"crowdfunding\";}i:471;a:2:{s:2:\"id\";s:6:\"2492-7\";s:4:\"name\";s:8:\"campaign\";}i:472;a:2:{s:2:\"id\";s:6:\"2492-8\";s:4:\"name\";s:10:\"fundraiser\";}i:473;a:2:{s:2:\"id\";s:6:\"2492-9\";s:4:\"name\";s:6:\"donate\";}i:474;a:2:{s:2:\"id\";s:7:\"2492-10\";s:4:\"name\";s:8:\"donation\";}i:475;a:2:{s:2:\"id\";s:7:\"2492-11\";s:4:\"name\";s:9:\"community\";}i:476;a:2:{s:2:\"id\";s:7:\"2492-12\";s:4:\"name\";s:8:\"politics\";}i:477;a:2:{s:2:\"id\";s:7:\"2492-13\";s:4:\"name\";s:10:\"politician\";}i:478;a:2:{s:2:\"id\";s:7:\"2492-14\";s:4:\"name\";s:8:\"template\";}i:479;a:2:{s:2:\"id\";s:7:\"2492-15\";s:4:\"name\";s:5:\"Astra\";}i:480;a:2:{s:2:\"id\";s:7:\"2492-16\";s:4:\"name\";s:7:\"website\";}i:481;a:2:{s:2:\"id\";s:7:\"2492-17\";s:4:\"name\";s:0:\"\";}i:482;a:2:{s:2:\"id\";i:2472;s:4:\"name\";s:4:\"Pets\";}i:483;a:2:{s:2:\"id\";s:6:\"2472-0\";s:4:\"name\";s:10:\"dog sitter\";}i:484;a:2:{s:2:\"id\";s:6:\"2472-1\";s:4:\"name\";s:3:\"dog\";}i:485;a:2:{s:2:\"id\";s:6:\"2472-2\";s:4:\"name\";s:7:\"walking\";}i:486;a:2:{s:2:\"id\";s:6:\"2472-3\";s:4:\"name\";s:3:\"pet\";}i:487;a:2:{s:2:\"id\";s:6:\"2472-4\";s:4:\"name\";s:8:\"groomers\";}i:488;a:2:{s:2:\"id\";s:6:\"2472-5\";s:4:\"name\";s:12:\"veterinarian\";}i:489;a:2:{s:2:\"id\";s:6:\"2472-6\";s:4:\"name\";s:3:\"vet\";}i:490;a:2:{s:2:\"id\";s:6:\"2472-7\";s:4:\"name\";s:10:\"veterinary\";}i:491;a:2:{s:2:\"id\";s:6:\"2472-8\";s:4:\"name\";s:7:\"service\";}i:492;a:2:{s:2:\"id\";s:6:\"2472-9\";s:4:\"name\";s:8:\"services\";}i:493;a:2:{s:2:\"id\";s:7:\"2472-10\";s:4:\"name\";s:8:\"template\";}i:494;a:2:{s:2:\"id\";s:7:\"2472-11\";s:4:\"name\";s:8:\"business\";}i:495;a:2:{s:2:\"id\";s:7:\"2472-12\";s:4:\"name\";s:5:\"local\";}i:496;a:2:{s:2:\"id\";s:7:\"2472-13\";s:4:\"name\";s:8:\"business\";}i:497;a:2:{s:2:\"id\";s:7:\"2472-14\";s:4:\"name\";s:5:\"Astra\";}i:498;a:2:{s:2:\"id\";s:7:\"2472-15\";s:4:\"name\";s:10:\"consulting\";}i:499;a:2:{s:2:\"id\";s:7:\"2472-16\";s:4:\"name\";s:10:\"consultant\";}i:500;a:2:{s:2:\"id\";s:7:\"2472-17\";s:4:\"name\";s:7:\"website\";}i:501;a:2:{s:2:\"id\";s:7:\"2472-18\";s:4:\"name\";s:0:\"\";}i:502;a:2:{s:2:\"id\";i:2485;s:4:\"name\";s:11:\"Photography\";}i:503;a:2:{s:2:\"id\";s:6:\"2485-0\";s:4:\"name\";s:11:\"photography\";}i:504;a:2:{s:2:\"id\";s:6:\"2485-1\";s:4:\"name\";s:12:\"photographer\";}i:505;a:2:{s:2:\"id\";s:6:\"2485-2\";s:4:\"name\";s:9:\"portfolio\";}i:506;a:2:{s:2:\"id\";s:6:\"2485-3\";s:4:\"name\";s:8:\"portrait\";}i:507;a:2:{s:2:\"id\";s:6:\"2485-4\";s:4:\"name\";s:8:\"template\";}i:508;a:2:{s:2:\"id\";s:6:\"2485-5\";s:4:\"name\";s:5:\"Astra\";}i:509;a:2:{s:2:\"id\";s:6:\"2485-6\";s:4:\"name\";s:7:\"website\";}i:510;a:2:{s:2:\"id\";s:6:\"2485-7\";s:4:\"name\";s:0:\"\";}i:511;a:2:{s:2:\"id\";i:2488;s:4:\"name\";s:9:\"Portfolio\";}i:512;a:2:{s:2:\"id\";s:6:\"2488-0\";s:4:\"name\";s:2:\"UX\";}i:513;a:2:{s:2:\"id\";s:6:\"2488-1\";s:4:\"name\";s:2:\"UI\";}i:514;a:2:{s:2:\"id\";s:6:\"2488-2\";s:4:\"name\";s:9:\"animation\";}i:515;a:2:{s:2:\"id\";s:6:\"2488-3\";s:4:\"name\";s:6:\"resume\";}i:516;a:2:{s:2:\"id\";s:6:\"2488-4\";s:4:\"name\";s:16:\"curriculum vitae\";}i:517;a:2:{s:2:\"id\";s:6:\"2488-5\";s:4:\"name\";s:2:\"cv\";}i:518;a:2:{s:2:\"id\";s:6:\"2488-6\";s:4:\"name\";s:6:\"career\";}i:519;a:2:{s:2:\"id\";s:6:\"2488-7\";s:4:\"name\";s:8:\"animator\";}i:520;a:2:{s:2:\"id\";s:6:\"2488-8\";s:4:\"name\";s:5:\"actor\";}i:521;a:2:{s:2:\"id\";s:6:\"2488-9\";s:4:\"name\";s:6:\"writer\";}i:522;a:2:{s:2:\"id\";s:7:\"2488-10\";s:4:\"name\";s:10:\"voice-over\";}i:523;a:2:{s:2:\"id\";s:7:\"2488-11\";s:4:\"name\";s:12:\"web designer\";}i:524;a:2:{s:2:\"id\";s:7:\"2488-12\";s:4:\"name\";s:17:\"tarot card reader\";}i:525;a:2:{s:2:\"id\";s:7:\"2488-13\";s:4:\"name\";s:11:\"illustrator\";}i:526;a:2:{s:2:\"id\";s:7:\"2488-14\";s:4:\"name\";s:10:\"freelancer\";}i:527;a:2:{s:2:\"id\";s:7:\"2488-15\";s:4:\"name\";s:9:\"freelance\";}i:528;a:2:{s:2:\"id\";s:7:\"2488-16\";s:4:\"name\";s:6:\"author\";}i:529;a:2:{s:2:\"id\";s:7:\"2488-17\";s:4:\"name\";s:6:\"visual\";}i:530;a:2:{s:2:\"id\";s:7:\"2488-18\";s:4:\"name\";s:7:\"student\";}i:531;a:2:{s:2:\"id\";s:7:\"2488-19\";s:4:\"name\";s:11:\"programming\";}i:532;a:2:{s:2:\"id\";s:7:\"2488-20\";s:4:\"name\";s:11:\"photography\";}i:533;a:2:{s:2:\"id\";s:7:\"2488-21\";s:4:\"name\";s:12:\"photographer\";}i:534;a:2:{s:2:\"id\";s:7:\"2488-22\";s:4:\"name\";s:5:\"model\";}i:535;a:2:{s:2:\"id\";s:7:\"2488-23\";s:4:\"name\";s:6:\"online\";}i:536;a:2:{s:2:\"id\";s:7:\"2488-24\";s:4:\"name\";s:8:\"personal\";}i:537;a:2:{s:2:\"id\";s:7:\"2488-25\";s:4:\"name\";s:7:\"website\";}i:538;a:2:{s:2:\"id\";s:7:\"2488-26\";s:4:\"name\";s:8:\"template\";}i:539;a:2:{s:2:\"id\";s:7:\"2488-27\";s:4:\"name\";s:5:\"Astra\";}i:540;a:2:{s:2:\"id\";s:7:\"2488-28\";s:4:\"name\";s:10:\"consulting\";}i:541;a:2:{s:2:\"id\";s:7:\"2488-29\";s:4:\"name\";s:10:\"consultant\";}i:542;a:2:{s:2:\"id\";s:7:\"2488-30\";s:4:\"name\";s:8:\"designer\";}i:543;a:2:{s:2:\"id\";s:7:\"2488-31\";s:4:\"name\";s:6:\"design\";}i:544;a:2:{s:2:\"id\";s:7:\"2488-32\";s:4:\"name\";s:6:\"studio\";}i:545;a:2:{s:2:\"id\";s:7:\"2488-33\";s:4:\"name\";s:6:\"artist\";}i:546;a:2:{s:2:\"id\";s:7:\"2488-34\";s:4:\"name\";s:9:\"developer\";}i:547;a:2:{s:2:\"id\";s:7:\"2488-35\";s:4:\"name\";s:7:\"website\";}i:548;a:2:{s:2:\"id\";s:7:\"2488-36\";s:4:\"name\";s:0:\"\";}i:549;a:2:{s:2:\"id\";i:2484;s:4:\"name\";s:11:\"Real Estate\";}i:550;a:2:{s:2:\"id\";s:6:\"2484-0\";s:4:\"name\";s:4:\"real\";}i:551;a:2:{s:2:\"id\";s:6:\"2484-1\";s:4:\"name\";s:6:\"estate\";}i:552;a:2:{s:2:\"id\";s:6:\"2484-2\";s:4:\"name\";s:8:\"building\";}i:553;a:2:{s:2:\"id\";s:6:\"2484-3\";s:4:\"name\";s:12:\"construction\";}i:554;a:2:{s:2:\"id\";s:6:\"2484-4\";s:4:\"name\";s:10:\"contractor\";}i:555;a:2:{s:2:\"id\";s:6:\"2484-5\";s:4:\"name\";s:5:\"agent\";}i:556;a:2:{s:2:\"id\";s:6:\"2484-6\";s:4:\"name\";s:9:\"architect\";}i:557;a:2:{s:2:\"id\";s:6:\"2484-7\";s:4:\"name\";s:8:\"interior\";}i:558;a:2:{s:2:\"id\";s:6:\"2484-8\";s:4:\"name\";s:4:\"firm\";}i:559;a:2:{s:2:\"id\";s:6:\"2484-9\";s:4:\"name\";s:7:\"service\";}i:560;a:2:{s:2:\"id\";s:7:\"2484-10\";s:4:\"name\";s:8:\"template\";}i:561;a:2:{s:2:\"id\";s:7:\"2484-11\";s:4:\"name\";s:8:\"business\";}i:562;a:2:{s:2:\"id\";s:7:\"2484-12\";s:4:\"name\";s:5:\"Astra\";}i:563;a:2:{s:2:\"id\";s:7:\"2484-13\";s:4:\"name\";s:10:\"consulting\";}i:564;a:2:{s:2:\"id\";s:7:\"2484-14\";s:4:\"name\";s:10:\"consultant\";}i:565;a:2:{s:2:\"id\";s:7:\"2484-15\";s:4:\"name\";s:7:\"company\";}i:566;a:2:{s:2:\"id\";s:7:\"2484-16\";s:4:\"name\";s:8:\"designer\";}i:567;a:2:{s:2:\"id\";s:7:\"2484-17\";s:4:\"name\";s:7:\"website\";}i:568;a:2:{s:2:\"id\";s:7:\"2484-18\";s:4:\"name\";s:0:\"\";}i:569;a:2:{s:2:\"id\";i:2496;s:4:\"name\";s:17:\"Restaurant & Food\";}i:570;a:2:{s:2:\"id\";s:6:\"2496-0\";s:4:\"name\";s:4:\"food\";}i:571;a:2:{s:2:\"id\";s:6:\"2496-1\";s:4:\"name\";s:10:\"restaurant\";}i:572;a:2:{s:2:\"id\";s:6:\"2496-2\";s:4:\"name\";s:7:\"kitchen\";}i:573;a:2:{s:2:\"id\";s:6:\"2496-3\";s:4:\"name\";s:9:\"breakfast\";}i:574;a:2:{s:2:\"id\";s:6:\"2496-4\";s:4:\"name\";s:6:\"brunch\";}i:575;a:2:{s:2:\"id\";s:6:\"2496-5\";s:4:\"name\";s:6:\"dining\";}i:576;a:2:{s:2:\"id\";s:6:\"2496-6\";s:4:\"name\";s:5:\"diner\";}i:577;a:2:{s:2:\"id\";s:6:\"2496-7\";s:4:\"name\";s:7:\"cooking\";}i:578;a:2:{s:2:\"id\";s:6:\"2496-8\";s:4:\"name\";s:8:\"template\";}i:579;a:2:{s:2:\"id\";s:6:\"2496-9\";s:4:\"name\";s:8:\"business\";}i:580;a:2:{s:2:\"id\";s:7:\"2496-10\";s:4:\"name\";s:5:\"Astra\";}i:581;a:2:{s:2:\"id\";s:7:\"2496-11\";s:4:\"name\";s:7:\"website\";}i:582;a:2:{s:2:\"id\";s:7:\"2496-12\";s:4:\"name\";s:0:\"\";}i:583;a:2:{s:2:\"id\";i:2499;s:4:\"name\";s:10:\"Technology\";}i:584;a:2:{s:2:\"id\";s:6:\"2499-0\";s:4:\"name\";s:4:\"SaaS\";}i:585;a:2:{s:2:\"id\";s:6:\"2499-1\";s:4:\"name\";s:10:\"Mobile App\";}i:586;a:2:{s:2:\"id\";s:6:\"2499-2\";s:4:\"name\";s:4:\"Tech\";}i:587;a:2:{s:2:\"id\";s:6:\"2499-3\";s:4:\"name\";s:7:\"Product\";}i:588;a:2:{s:2:\"id\";s:6:\"2499-4\";s:4:\"name\";s:8:\"Software\";}i:589;a:2:{s:2:\"id\";s:6:\"2499-5\";s:4:\"name\";s:7:\"Startup\";}i:590;a:2:{s:2:\"id\";s:6:\"2499-6\";s:4:\"name\";s:0:\"\";}i:591;a:2:{s:2:\"id\";i:2473;s:4:\"name\";s:9:\"Transport\";}i:592;a:2:{s:2:\"id\";s:6:\"2473-0\";s:4:\"name\";s:6:\"movers\";}i:593;a:2:{s:2:\"id\";s:6:\"2473-1\";s:4:\"name\";s:7:\"packers\";}i:594;a:2:{s:2:\"id\";s:6:\"2473-2\";s:4:\"name\";s:6:\"moving\";}i:595;a:2:{s:2:\"id\";s:6:\"2473-3\";s:4:\"name\";s:6:\"towing\";}i:596;a:2:{s:2:\"id\";s:6:\"2473-4\";s:4:\"name\";s:6:\"rental\";}i:597;a:2:{s:2:\"id\";s:6:\"2473-5\";s:4:\"name\";s:7:\"service\";}i:598;a:2:{s:2:\"id\";s:6:\"2473-6\";s:4:\"name\";s:8:\"services\";}i:599;a:2:{s:2:\"id\";s:6:\"2473-7\";s:4:\"name\";s:8:\"delivery\";}i:600;a:2:{s:2:\"id\";s:6:\"2473-8\";s:4:\"name\";s:8:\"template\";}i:601;a:2:{s:2:\"id\";s:6:\"2473-9\";s:4:\"name\";s:5:\"local\";}i:602;a:2:{s:2:\"id\";s:7:\"2473-10\";s:4:\"name\";s:8:\"business\";}i:603;a:2:{s:2:\"id\";s:7:\"2473-11\";s:4:\"name\";s:5:\"Astra\";}i:604;a:2:{s:2:\"id\";s:7:\"2473-12\";s:4:\"name\";s:7:\"company\";}i:605;a:2:{s:2:\"id\";s:7:\"2473-13\";s:4:\"name\";s:7:\"website\";}i:606;a:2:{s:2:\"id\";s:7:\"2473-14\";s:4:\"name\";s:7:\"courier\";}i:607;a:2:{s:2:\"id\";s:7:\"2473-15\";s:4:\"name\";s:0:\"\";}}", "no");
INSERT INTO `wp_options` VALUES("12505", "eael_admin_menu_notice", "13", "off");
INSERT INTO `wp_options` VALUES("12515", "_site_transient_t15s-registry-gforms", "O:8:\"stdClass\":2:{s:8:\"projects\";a:59:{s:26:\"gravityformsactivecampaign\";a:1:{s:12:\"translations\";a:26:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T14:15:16+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:17+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:27+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T07:57:07+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T11:15:47+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2024-11-09T11:31:32+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2022-06-27T08:31:49+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-05T14:57:41+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-05T14:57:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:05+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-10-09T08:22:02+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T09:20:30+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-05T14:57:45+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-24T15:09:35+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-05T14:57:46+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T14:59:21+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-04-02T06:44:05+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:11+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T15:58:58+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T18:39:07+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-04-02T13:27:41+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-29T17:58:14+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-20T19:24:04+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T12:47:21+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-30T21:18:28+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-30T22:29:04+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformsaweber\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-19T14:35:08+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-19T08:03:28+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-19T11:19:40+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2023-08-16T11:26:53+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2023-08-16T11:26:50+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2023-08-16T11:26:50+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-19T07:37:20+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-19T15:24:00+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2023-08-16T11:26:54+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-24T15:14:51+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-18T15:09:53+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-04-01T06:34:42+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-18T15:56:34+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-18T18:10:35+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-04-02T13:44:34+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-29T17:52:10+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-20T19:27:52+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-19T12:51:04+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-27T15:08:02+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-30T22:22:32+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformsagilecrm\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-19T14:37:01+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:27+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-19T08:01:05+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-19T11:18:14+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2024-11-09T11:31:32+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-27T08:36:09+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-27T08:36:11+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-27T08:36:16+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-11-06T08:44:20+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-19T09:20:53+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-01-06T16:56:35+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-24T15:13:08+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-18T15:05:10+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-04-01T06:35:45+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-18T15:45:37+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-18T18:39:20+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-04-02T13:43:17+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-29T17:54:16+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-20T19:26:30+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-19T12:49:31+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-30T21:23:25+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-30T22:24:10+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:24:\"gravityformsauthorizenet\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2024-03-20T12:51:36+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-12-28T11:16:35+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2022-06-23T19:13:22+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2024-09-12T11:38:58+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2022-06-29T15:48:18+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-10-19T11:05:17+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-10-19T11:04:01+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2022-06-23T19:13:41+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-03-02T20:29:58+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-10-21T11:50:09+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:21+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:37+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:39+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:45+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-03-14T17:38:30+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2021-09-13T20:54:56+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-12-17T15:01:32+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-12-17T15:53:58+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T08:01:49+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:28+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T08:01:53+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-11-05T09:28:49+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-11-09T01:30:51+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformsbatchbook\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2024-03-20T12:53:19+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2022-06-27T09:51:40+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-03T10:14:25+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:20+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:29:58+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:29:36+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:29:39+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:29:46+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2025-11-06T08:44:47+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:24+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:41+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2020-01-22T16:00:21+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:48+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-03-14T17:40:37+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T08:02:41+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T08:02:47+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T08:02:49+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:30:05+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:30:11+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:32+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2020-10-21T18:08:50+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T08:02:59+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-09T01:26:27+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformsbreeze\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T14:38:33+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T08:03:58+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T11:20:05+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2022-06-23T19:13:42+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T07:33:49+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T09:21:40+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-01-06T16:59:43+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-24T15:15:41+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-18T15:11:29+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-04-01T06:33:30+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-18T16:04:19+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-18T18:39:39+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-04-02T13:45:16+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-29T17:49:19+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-20T19:28:07+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T12:53:20+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-27T15:05:01+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-30T22:19:44+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:27:\"gravityformscampaignmonitor\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-19T14:38:54+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2024-11-09T11:58:24+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-19T08:04:30+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-19T11:20:27+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2023-01-06T17:00:49+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-19T07:37:42+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-19T09:21:49+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2020-10-27T15:32:58+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-24T15:16:23+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-18T15:12:16+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-04-01T06:33:17+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-18T16:04:53+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-18T18:40:04+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-04-02T13:45:29+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-29T18:51:09+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-20T16:43:56+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-19T13:16:17+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-27T15:04:34+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-30T22:52:50+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformscampfire\";a:1:{s:12:\"translations\";a:24:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2024-03-20T12:55:41+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:21+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:02:39+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:01:41+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:51+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:30+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:34+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2022-06-27T09:53:41+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-03-02T20:33:52+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:43+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:01:45+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2020-02-18T11:26:09+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2020-01-22T16:22:19+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:47+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-03-14T17:44:01+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-03-02T20:33:59+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:02:22+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:55+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:58+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:44:01+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:36+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:02:33+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2020-02-13T09:15:04+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-11-09T01:41:12+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:22:\"gravityformscapsulecrm\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T14:41:03+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:26+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T08:05:52+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T11:21:13+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2024-11-09T11:31:33+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2022-06-27T08:52:42+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2022-06-27T08:52:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-01-06T17:03:07+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-11-06T08:43:59+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T09:22:00+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-01-06T17:03:14+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-24T15:18:53+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T15:20:01+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-04-01T06:33:04+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T16:07:43+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T18:40:30+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-04-02T13:46:44+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-29T18:53:38+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-20T19:29:19+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T13:18:09+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-30T21:28:54+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-30T22:52:20+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:26:\"gravityformschainedselects\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2024-03-26T11:38:44+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2023-04-14T18:06:58+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2023-11-20T07:22:44+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2023-01-06T17:04:41+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2022-06-23T19:13:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-10-27T15:57:33+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-11-04T16:39:59+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-11-04T16:39:05+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-10-27T15:56:33+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-11-04T16:40:25+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-12-17T14:50:04+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2021-09-13T21:00:54+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-12-17T15:03:03+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-12-17T15:55:04+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-11-04T16:40:51+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2023-01-06T17:04:14+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-10-21T17:43:40+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-10-27T15:55:51+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2023-11-10T01:29:52+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:23:\"gravityformscleverreach\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T14:41:52+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T08:06:48+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T11:21:40+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2022-06-27T08:54:38+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2022-06-27T08:54:39+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2023-01-06T17:05:28+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T07:38:06+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T09:22:17+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2023-01-06T17:05:34+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-24T15:20:44+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-18T15:25:49+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-04-02T06:43:20+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-18T16:06:22+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-18T18:40:33+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-04-02T13:47:12+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-29T18:54:26+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-20T19:29:40+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T13:19:11+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-30T21:26:25+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-30T22:50:24+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformscoupons\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-19T14:42:29+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2022-06-23T19:14:14+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-19T08:07:30+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-19T11:27:01+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2022-06-23T19:13:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2023-03-02T20:27:34+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-19T07:38:40+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-19T09:23:19+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2023-01-06T17:06:49+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-26T15:44:36+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-18T15:26:41+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-04-02T06:34:19+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2023-11-03T10:13:14+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-18T16:05:15+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-18T18:40:36+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2024-09-08T00:13:14+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-29T19:00:30+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-20T16:43:37+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-22T07:24:43+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-27T15:06:38+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-30T22:45:00+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformsdropbox\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-19T16:09:14+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2024-09-02T08:18:20+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-19T14:46:04+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-19T11:28:31+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2022-06-27T08:56:15+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-01-06T17:07:52+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-19T10:35:31+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-19T09:23:32+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2022-06-27T08:56:26+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-26T15:45:53+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-18T15:34:40+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-04-02T06:33:50+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-11-03T10:13:15+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-18T16:02:05+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-18T18:40:58+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-04-02T15:53:32+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-29T19:16:51+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-20T20:05:17+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-22T07:26:02+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-30T21:31:44+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-30T22:44:36+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:16:\"gravityformsemma\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T16:12:50+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T15:01:29+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T11:29:52+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T14:10:50+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T14:10:51+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T14:10:54+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T14:10:56+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T09:23:59+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T14:10:58+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-26T15:49:47+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T15:49:44+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-04-02T06:32:04+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:14+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T15:50:44+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T18:41:05+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-04-02T15:29:12+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-29T19:14:52+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-20T20:16:33+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-22T07:29:16+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-30T06:27:41+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-30T22:41:32+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:22:\"gravityformsfreshbooks\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2024-03-20T13:24:54+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:09:49+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:29+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-02-20T14:36:42+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2020-10-21T11:51:43+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:09:52+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:11+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:13+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:19+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-03-14T17:49:01+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2021-09-14T09:32:44+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:33+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2020-12-17T15:53:03+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:39+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:09:59+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2021-02-08T11:26:17+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:44+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-11-29T02:21:29+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:23:\"gravityformsgetresponse\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T16:13:42+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T15:03:09+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T11:30:45+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2022-06-27T08:58:09+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2022-06-27T08:58:11+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2023-01-06T17:11:13+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T07:40:50+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T09:24:14+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2023-01-06T17:11:18+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-26T15:50:57+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-18T16:08:44+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-04-02T07:37:54+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-18T16:02:48+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-18T18:45:04+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-04-02T15:55:20+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-29T19:12:36+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-20T20:06:28+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-22T07:29:56+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-30T21:24:10+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-30T22:39:14+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformshelpscout\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2024-03-20T13:26:34+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-02-20T14:31:15+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-11-24T07:42:04+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-10-11T17:38:30+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2022-06-27T09:58:40+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2022-06-27T09:58:42+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:19+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-10-25T16:20:17+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:08+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2020-11-05T09:45:35+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:27+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:32+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-03-14T17:50:31+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-11-28T21:10:33+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:48+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-10-25T23:03:06+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-10-20T06:44:18+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:15+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-11-04T18:39:39+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:13:00+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-11-29T02:37:34+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformshighrise\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2024-03-20T13:28:49+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2022-06-27T09:59:10+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-03T10:14:26+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:12+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:45+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-03T10:13:20+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:21+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:25+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:27+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2025-11-06T08:43:37+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:18+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:33+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:35+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:40+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-03-14T17:51:12+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:52+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:54+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:52+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:56+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:23+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2021-08-02T17:30:03+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:14:05+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-19T23:28:15+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformshipchat\";a:1:{s:12:\"translations\";a:25:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2024-03-20T13:29:15+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:58:44+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2022-06-27T10:00:12+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:58:50+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:25+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:00+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:04+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:11+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-03-02T20:33:52+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2020-10-21T13:28:02+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:58:57+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:9:\"de/formal\";a:7:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:58:55+00:00\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-de_DE_formal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2020-02-21T12:24:57+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2020-01-25T07:46:44+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:18+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-03-14T17:51:30+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:23+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-01-06T17:14:57+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-01-06T17:14:59+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:32+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:35+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:06+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2021-08-02T17:31:33+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2020-02-13T09:22:17+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-11-19T23:25:08+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformsmadmimi\";a:1:{s:12:\"translations\";a:34:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-20T13:31:30+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:11:17+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:15+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:27+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:5:\"zh-hk\";a:7:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:32+00:00\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-zh_HK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:22+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:16:07+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:20+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:06+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2020-10-21T11:52:31+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:26+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:14:\"de-ch/informal\";a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-09-25T12:09:30+00:00\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:110:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-de_CH_informal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:11:27+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:49+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:52+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:13+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"id\";a:7:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:30+00:00\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-id_ID.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"id\";i:1;s:3:\"ind\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:57+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-03-14T17:52:56+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:15+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2021-10-02T10:46:06+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:16:11+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2020-12-17T15:55:55+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ro\";a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:47+00:00\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ro_RO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ro\";i:1;s:3:\"ron\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:16:17+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"sr\";a:7:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:16+00:00\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-sr_RS.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sr\";i:1;s:3:\"srp\";}}s:5:\"es-mx\";a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:11:53+00:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-es_MX.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:36+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2021-08-02T17:35:32+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:16:24+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-09T01:39:35+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformsmailchimp\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2024-03-20T13:32:12+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-11-24T12:41:33+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:15+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2022-06-27T08:43:13+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:16:52+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-03-02T20:28:02+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2021-10-25T16:35:54+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:16:39+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:16:57+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2021-10-17T13:48:34+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:05+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-02-04T16:58:16+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-11-03T10:13:13+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-11-28T21:13:27+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:19+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2021-10-25T23:02:38+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:25+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:16:47+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:29+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:31+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-11-25T20:33:22+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:26:\"gravityformspartialentries\";a:1:{s:12:\"translations\";a:27:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-11-23T11:07:56+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-04-14T17:10:56+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-02-20T14:31:15+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2024-11-09T11:58:41+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-11-26T19:03:02+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:18:21+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2024-11-09T11:31:43+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2022-06-23T19:13:42+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2020-10-21T13:19:25+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:17:46+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:14:\"de-ch/informal\";a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-09-25T12:09:31+00:00\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:124:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-de_CH_informal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-10-17T13:38:00+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:18:03+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:18:05+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2024-11-08T17:21:07+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:18:12+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2020-12-17T14:50:15+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2021-09-14T09:48:18+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:18:24+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2020-12-17T15:55:24+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:18:31+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:17:54+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2021-08-02T17:40:09+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2020-11-05T09:27:36+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-11-25T20:27:12+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:29:\"gravityformspaypalpaymentspro\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2024-03-20T13:33:43+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:118:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-12-28T11:16:35+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-11-26T19:04:21+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:08:48+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2022-06-23T19:13:42+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:118:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-03-02T20:27:35+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2021-03-24T14:22:06+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:07:45+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:09:54+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-01-06T17:19:10+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:08:26+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-03-14T17:54:30+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:118:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2021-09-14T09:52:47+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-01-06T17:19:29+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-12-17T14:13:06+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:10:17+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:09:09+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2021-09-29T18:02:03+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-01-06T17:19:40+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-11-25T20:24:57+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:118:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformspaypal\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2024-03-20T15:01:34+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:51+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2022-06-23T19:13:23+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:31+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2022-06-27T10:05:05+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2022-06-23T19:13:41+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-03-02T20:27:35+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2020-10-21T11:52:44+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:19:55+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:13+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:15+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:21+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-03-14T17:54:51+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2021-09-14T09:52:14+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:35+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2020-12-17T15:54:54+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:40+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:03+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2021-09-29T18:06:04+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:46+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-12-01T23:37:46+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformspaypalpro\";a:1:{s:12:\"translations\";a:30:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2025-11-06T14:08:36+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-04-15T14:48:04+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-12-28T11:11:03+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-12-28T11:16:36+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:5:\"zh-hk\";a:7:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-03-02T20:50:54+00:00\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-zh_HK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:59:29+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:55:46+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:55:30+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:55:02+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:55:18+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:54:52+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2025-10-23T13:44:10+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:56:58+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:9:\"de/formal\";a:7:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-03-30T13:48:05+00:00\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-de_DE_formal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:14:\"de-ch/informal\";a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-09-25T12:58:34+00:00\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-de_CH_informal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-10-17T13:40:59+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-04-29T16:41:43+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-01-27T16:56:20+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-03-02T20:50:29+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:54:26+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-03-14T17:55:20+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2019-12-10T13:19:22+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2021-09-14T09:53:44+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:53:59+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:54:40+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:57:32+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:56:26+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2021-11-04T18:47:08+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-04-29T16:42:28+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-12-01T23:55:20+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:17:\"gravityformspolls\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-03-20T15:15:58+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-11-27T04:51:47+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-11-05T15:15:31+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2022-06-27T09:09:10+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2022-06-27T09:09:12+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2022-06-27T09:09:20+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-03-02T20:51:24+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-10-21T13:43:25+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-11-05T15:13:17+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-01-06T17:22:24+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-11-05T15:17:13+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-01-06T17:22:32+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-03-14T17:55:58+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2021-09-14T09:55:19+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-12-17T14:20:05+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-12-17T14:19:33+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-11-05T15:18:45+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-01-06T17:22:14+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2021-11-04T18:52:05+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-06-29T08:29:29+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-12-02T00:08:37+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformspostmark\";a:1:{s:12:\"translations\";a:18:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-11-24T12:00:03+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-11-27T04:54:05+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-24T11:44:53+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2022-06-27T09:11:37+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-25T21:03:26+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-31T19:40:40+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-03-29T18:54:45+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-22T09:30:48+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-26T12:48:57+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-06-04T08:26:03+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-09-14T09:55:49+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-31T04:01:04+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-04-11T21:20:33+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-20T16:53:54+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-06-01T17:59:01+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-06-05T06:35:48+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-26T23:45:38+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-11-25T20:16:29+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:16:\"gravityformsquiz\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-07T08:40:34+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-17T12:15:00+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-06T18:20:38+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-07-10T08:01:14+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-07-10T08:01:15+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-07-10T08:01:15+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-07-10T08:01:12+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-17T15:15:27+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-19T07:49:40+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-07-10T08:01:13+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-26T10:46:55+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-17T20:51:56+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-10-02T06:51:05+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-10T10:06:05+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-06T19:10:38+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-11T23:20:43+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-15T19:21:44+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-24T12:53:46+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-22T19:36:46+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-17T09:14:40+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-15T19:21:20+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformssignature\";a:1:{s:12:\"translations\";a:25:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-19T16:17:23+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2023-02-20T14:32:41+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2022-06-27T10:11:12+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-24T08:43:38+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-19T11:44:44+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2024-11-09T11:33:00+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2021-08-12T08:00:46+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2023-03-02T20:55:38+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-19T07:42:56+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-19T09:28:09+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2023-03-02T20:55:40+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-26T16:52:40+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"id\";a:7:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2024-09-02T08:48:32+00:00\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-id_ID.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"id\";i:1;s:3:\"ind\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-18T16:56:26+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-04-02T07:03:50+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-18T16:06:03+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-18T19:08:56+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-04-02T16:07:30+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-29T18:33:52+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-20T16:45:25+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-22T07:55:39+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-30T12:11:45+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-30T23:01:49+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:17:\"gravityformsslack\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T16:18:46+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-04-14T18:11:09+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-24T08:44:34+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T11:45:41+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-01-06T17:26:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T07:48:34+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T09:27:59+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-01-06T17:26:48+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-26T16:52:08+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T16:57:49+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-04-02T07:03:12+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T16:08:17+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T22:09:43+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-04-02T15:58:47+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-29T18:35:17+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-20T16:49:20+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-22T07:56:35+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-30T21:31:04+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-31T00:49:49+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformsstripe\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:57+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:02+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:00+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:02+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:02+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:01+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:01+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:02+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:00+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:00+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:00+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:57+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:59+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:59+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:59+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:59+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-11-03T17:55:20+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:59+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:58+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:58+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformssurvey\";a:1:{s:12:\"translations\";a:27:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-20T15:11:13+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2023-04-14T18:14:00+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-09-02T08:43:26+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2022-06-23T19:14:15+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-20T05:58:48+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-15T15:32:19+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2022-06-27T08:34:13+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2022-06-23T19:13:41+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2023-03-02T20:57:55+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2025-11-06T08:40:43+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-28T10:17:54+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:14:\"de-ch/informal\";a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2023-09-25T12:51:08+00:00\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-de_CH_informal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2023-10-17T13:14:03+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2020-11-06T13:17:26+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-04-01T11:10:01+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-11-08T17:20:20+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-19T16:32:17+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-04-01T05:03:07+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-18T10:41:56+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-21T23:00:49+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-31T22:09:46+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-20T22:24:23+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-25T10:52:40+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-04-02T20:12:15+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-20T18:41:25+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-20T22:24:57+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformstrello\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T16:47:20+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2024-09-02T08:18:24+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T13:28:46+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T11:53:16+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:13+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-01-06T17:29:56+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T15:26:43+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T09:27:15+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-01-06T17:30:03+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-26T16:54:51+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T17:00:57+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-04-02T06:56:40+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T16:04:33+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T22:10:14+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-04-02T16:08:09+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-29T18:29:32+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-20T20:39:11+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-22T08:10:53+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-27T15:04:50+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-30T23:00:57+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformstwilio\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-19T16:46:45+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-18T13:28:16+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-19T11:53:28+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2023-01-05T16:46:39+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2022-06-27T09:02:55+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2023-01-06T17:31:07+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-18T15:26:24+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-19T09:27:02+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2023-01-06T17:31:12+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-27T09:14:41+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-18T17:01:55+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-04-02T06:56:24+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-18T16:03:43+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-18T22:10:21+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-04-02T16:07:47+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-29T18:29:10+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-20T20:39:39+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-22T08:11:15+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-27T15:05:31+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-30T23:00:32+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:28:\"gravityformsuserregistration\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-19T16:46:08+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:116:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2024-09-02T08:18:21+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:116:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2023-01-06T17:32:56+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-24T08:49:32+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-19T11:54:15+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2022-06-27T10:16:33+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2022-06-27T10:16:36+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2023-01-06T17:32:11+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:116:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2023-03-02T20:28:46+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-10-07T07:40:48+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2024-03-29T13:44:16+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2021-03-29T19:18:41+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-27T09:23:57+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-19T19:34:41+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-04-02T06:56:06+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:116:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-18T15:47:00+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-18T22:32:36+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-04-02T16:03:40+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-29T18:28:28+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-20T21:04:43+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-22T08:12:58+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-30T21:30:15+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-30T23:00:05+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:116:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformszapier\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-19T16:50:44+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-18T13:22:40+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-19T11:55:18+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2022-06-27T09:18:29+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2022-06-27T09:18:32+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2022-06-27T09:18:39+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-18T15:19:39+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-19T09:26:32+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:33:24+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-27T09:12:38+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-19T19:38:52+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-04-02T06:53:00+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-18T15:27:45+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-18T22:10:46+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-04-02T15:19:59+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-29T18:24:13+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-20T20:59:29+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-22T08:15:36+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-30T21:16:01+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-30T22:56:56+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformszohocrm\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T16:54:27+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T13:18:24+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T11:56:01+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2022-06-27T09:02:53+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2022-06-27T08:55:23+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2023-01-06T17:34:25+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T15:16:09+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T09:26:21+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2023-01-06T17:34:31+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-27T09:09:58+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T19:41:21+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-04-02T06:52:06+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T15:23:21+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T22:10:50+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-04-02T16:06:20+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-29T18:20:53+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-20T19:57:28+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-22T20:46:20+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-30T21:27:36+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-30T22:55:02+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformsicontact\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T18:08:34+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T13:49:03+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T15:10:50+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T11:33:12+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T13:49:08+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T13:49:09+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T13:49:14+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T08:17:20+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T15:27:13+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T13:49:17+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-26T15:57:01+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T16:22:16+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-04-02T07:37:34+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T15:35:16+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T18:37:35+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-04-02T13:55:43+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-29T19:22:07+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-20T20:31:53+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-22T07:43:57+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-30T06:22:23+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-31T01:10:39+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:24:\"gravityformsemailoctopus\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-19T18:11:07+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-19T14:47:14+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-19T11:29:03+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:13+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2022-06-27T08:55:23+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-01-06T17:36:53+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-19T07:40:08+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-19T09:23:47+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2020-06-23T13:15:54+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-26T15:46:55+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-18T15:37:40+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-04-02T06:32:30+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:17+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-18T15:49:45+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-18T18:41:01+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-04-02T15:22:11+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-29T19:01:57+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-20T20:06:00+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-22T07:27:27+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-30T21:16:40+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-30T22:42:48+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformsmailgun\";a:1:{s:12:\"translations\";a:24:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-07T08:52:25+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-12-28T11:11:02+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2022-06-27T10:02:12+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-13T09:22:58+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-04T08:15:20+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-12-28T11:14:06+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:13+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2022-06-27T10:01:47+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-12-28T11:13:16+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-03-02T20:46:07+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-06T12:42:42+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-04T11:37:35+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-01-06T17:38:07+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-04T17:13:38+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-15T07:35:12+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-24T06:29:14+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-06T09:42:12+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-23T16:10:35+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-19T21:36:35+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-09T14:20:35+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-15T21:52:07+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-22T17:42:52+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-17T22:15:18+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-09T14:20:57+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformssendgrid\";a:1:{s:12:\"translations\";a:27:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-24T14:25:24+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:16+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-23T19:14:16+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-26T19:07:24+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-11-06T09:05:56+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-29T15:47:02+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-27T09:11:37+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-23T19:13:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-03-02T20:27:36+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-10-21T13:18:39+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-11-06T09:06:48+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:9:\"de/formal\";a:7:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-01-26T16:08:21+00:00\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:110:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-de_DE_formal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-07-04T20:05:08+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-06-28T10:45:00+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:16+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-05-23T18:18:20+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-11-06T09:07:21+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:12+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2021-09-14T09:57:06+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-12-17T14:33:12+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-12-17T14:32:57+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-11-06T09:06:16+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-11-04T22:55:46+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-11-06T09:05:23+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-05-15T07:53:36+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-09T01:37:59+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformssquare\";a:1:{s:12:\"translations\";a:19:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-19T18:16:30+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-18T13:35:08+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-19T11:46:46+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2022-06-27T09:13:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2022-06-27T09:13:16+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-19T11:23:16+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-19T09:27:45+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-05T15:16:17+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-27T09:21:10+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-18T16:59:25+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-04-02T07:01:53+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-18T15:48:44+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-18T22:33:22+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-04-02T15:50:24+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-29T19:04:48+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-20T20:38:28+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-22T07:58:10+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-30T21:22:34+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-31T00:48:40+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformshubspot\";a:1:{s:12:\"translations\";a:18:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2024-03-20T15:34:55+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-11-24T12:35:05+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2024-09-12T12:00:41+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2022-06-27T09:00:32+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-11-09T10:59:10+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-05-20T14:30:42+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-01-06T17:41:22+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-05-05T15:02:53+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-05-15T15:57:06+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-05-18T06:09:23+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-11-28T21:19:11+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-05-22T18:52:51+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-05-05T17:03:26+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-05-10T17:12:37+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-05-16T22:26:43+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-06-30T06:42:49+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-05-11T14:43:07+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-11-29T02:47:06+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:16:\"gravityformsppcp\";a:1:{s:12:\"translations\";a:17:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-20T09:43:02+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-24T08:39:31+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-19T11:42:24+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-11-06T08:51:11+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-19T15:27:49+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2024-09-02T08:18:52+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-27T09:33:41+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-18T16:49:14+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-04-02T07:11:31+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-18T15:55:09+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-18T22:09:33+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-04-02T15:41:01+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-29T19:12:01+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-20T20:49:21+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-22T07:53:48+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-30T21:19:19+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-31T00:55:53+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformsmollie\";a:1:{s:12:\"translations\";a:18:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-20T09:54:21+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-24T08:31:12+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-19T11:37:44+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2022-06-27T10:02:53+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-11-06T08:50:50+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-19T15:27:31+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2020-11-01T09:59:43+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-26T16:05:40+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-18T16:40:16+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-04-02T07:26:23+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-18T15:38:26+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-18T22:09:21+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-04-02T14:07:13+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-29T19:29:35+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-20T20:45:27+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-22T07:49:31+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-30T06:25:21+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-31T01:02:22+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityforms2checkout\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-20T10:16:35+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-05T13:57:22+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T07:54:21+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T11:14:58+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2022-06-23T19:13:29+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2022-06-23T19:15:48+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2023-02-19T14:45:46+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2023-03-02T20:27:36+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T15:03:54+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T09:20:17+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2021-02-02T19:49:22+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-24T15:08:16+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T14:56:03+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-04-02T06:46:34+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T15:44:09+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T18:39:01+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-04-02T13:25:30+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-29T18:06:04+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-20T19:20:42+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T12:45:48+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-30T21:13:17+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-31T00:53:30+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:32:\"gravityformsadvancedpostcreation\";a:1:{s:12:\"translations\";a:27:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-20T10:20:12+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:124:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-05T15:04:11+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:124:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:46:19+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-19T07:59:59+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-19T11:17:39+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-11-09T11:31:18+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-05T15:04:13+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-05T15:04:14+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-05T15:04:17+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:124:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-18T15:12:01+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-19T09:20:42+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-05T15:04:19+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-24T15:11:42+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"id\";a:7:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-09-02T08:46:48+00:00\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-id_ID.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"id\";i:1;s:3:\"ind\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-18T15:02:17+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-04-01T06:36:29+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:124:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-18T16:00:21+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-18T18:39:12+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-04-02T13:40:55+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ro\";a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-11-09T11:39:19+00:00\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-ro_RO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ro\";i:1;s:3:\"ron\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-29T17:55:50+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"sr\";a:7:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-11-09T11:50:56+00:00\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-sr_RS.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sr\";i:1;s:3:\"srp\";}}s:5:\"es-mx\";a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-11-08T16:08:06+00:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-es_MX.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-20T19:25:36+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-19T12:52:48+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-30T21:32:16+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-30T22:26:15+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:124:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformswebhooks\";a:1:{s:12:\"translations\";a:18:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-20T10:21:50+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2024-09-02T08:43:58+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-18T13:23:06+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T11:54:33+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-18T15:20:05+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T09:26:39+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-01-06T17:46:51+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-27T09:13:30+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T19:35:52+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-04-02T06:53:13+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-18T16:04:03+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-18T22:10:34+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-04-02T16:07:59+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-29T18:25:08+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-20T20:40:00+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-22T08:13:16+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-27T15:05:11+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-30T22:57:21+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:16:\"gravityformspipe\";a:1:{s:12:\"translations\";a:17:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-20T10:25:04+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-24T08:41:11+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-19T11:43:50+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-19T07:54:06+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-19T09:25:47+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2020-11-01T10:02:06+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-26T16:53:58+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-18T16:53:29+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-04-02T07:06:11+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-18T15:57:52+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-18T19:08:44+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-04-02T15:45:06+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-29T18:32:41+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-20T20:36:52+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-22T07:54:52+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-30T21:26:13+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-30T23:03:42+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:27:\"gravityformsconstantcontact\";a:1:{s:12:\"translations\";a:27:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2024-05-07T08:20:57+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-11-03T10:11:18+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2024-09-02T08:18:23+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-11-03T10:14:28+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-11-16T07:57:41+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2024-09-12T11:46:56+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2022-06-27T08:55:20+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2022-06-27T08:55:23+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-01-06T17:00:49+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-11-03T10:12:06+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2020-10-21T11:36:30+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-01-06T17:48:43+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-11-03T10:11:27+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-01-06T17:49:00+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2020-10-25T15:55:38+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-11-03T10:12:17+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-01-06T17:49:07+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-03-14T17:46:28+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-11-03T10:13:13+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-01-06T17:49:20+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-01-06T17:49:22+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-01-06T17:49:24+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2020-10-29T05:29:40+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-01-06T17:48:51+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2020-10-23T18:56:46+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-01-06T17:49:39+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-11-09T01:53:49+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:12:\"gravityforms\";a:1:{s:12:\"translations\";a:32:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-23T13:14:31+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:84:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-03-05T10:47:56+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-16T21:14:24+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:84:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-08-14T12:30:56+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:5:\"zh-hk\";a:7:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-03-05T10:49:15+00:00\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-zh_HK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-24T09:43:36+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-17T11:09:32+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-12-05T11:11:39+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-15T14:33:52+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-15T06:20:10+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-20T15:25:52+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:84:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-08-14T12:31:00+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-11-06T08:44:34+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-23T13:20:57+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:9:\"de/formal\";a:7:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-20T15:28:05+00:00\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-de_DE_formal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:14:\"de-ch/informal\";a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2023-09-25T13:01:31+00:00\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-de_CH_informal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-03-05T10:48:01+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-16T21:03:01+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-11-06T14:13:08+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-16T20:41:14+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-27T11:24:59+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-28T07:28:45+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:84:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-03-05T10:48:59+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-28T19:25:13+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-22T22:58:14+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-17T16:49:39+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-16T15:49:23+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"sk\";a:7:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-03-18T08:14:12+00:00\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-sk_SK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sk\";i:1;s:3:\"slk\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-30T17:47:05+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-18T06:37:54+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-25T23:45:08+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-16T21:36:45+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:84:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformsrecaptcha\";a:1:{s:12:\"translations\";a:17:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-20T13:53:42+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-24T08:42:51+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-19T11:44:18+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-19T07:42:11+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-19T09:26:04+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2021-06-02T13:26:50+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-24T15:22:17+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-18T16:55:31+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-04-02T07:04:32+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-18T16:03:07+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-18T19:08:49+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-04-02T15:57:11+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-29T18:36:18+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-20T16:45:05+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-22T07:55:19+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-30T21:25:15+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-30T23:02:23+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:22:\"gravityformsmoderation\";a:1:{s:12:\"translations\";a:16:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-20T13:59:13+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-24T08:22:59+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-19T11:35:03+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-19T11:04:22+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-19T09:24:58+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-27T09:27:24+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-18T16:27:34+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-04-02T07:33:23+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-18T15:53:22+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-18T19:18:57+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-04-02T15:32:17+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-29T19:24:32+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-20T20:34:28+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-22T20:50:18+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-30T21:17:58+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-31T01:04:54+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:23:\"gravityformsgeolocation\";a:1:{s:12:\"translations\";a:16:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-02-23T15:42:07+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-20T05:48:38+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-15T15:46:27+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-18T14:03:02+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-28T10:20:33+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-04-01T11:12:52+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-19T16:31:40+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-04-01T06:09:41+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-18T10:45:34+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-21T23:02:09+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-31T00:08:17+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-22T15:55:11+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-25T10:54:05+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-04-02T20:07:13+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-18T20:50:19+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-22T15:55:38+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:31:\"gravityformsconversationalforms\";a:1:{s:12:\"translations\";a:18:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-09T10:30:04+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:122:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-09T08:14:49+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-06T18:14:22+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-05-03T08:43:40+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:122:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-23T12:50:51+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-19T07:05:45+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-05-03T08:43:45+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-26T10:39:25+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-17T20:46:11+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-10-03T06:51:46+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:122:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-10T11:39:42+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-17T16:16:24+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-08T00:11:41+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-15T21:52:57+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-24T12:54:32+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-22T19:39:55+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-17T09:13:03+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-15T21:52:23+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:122:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:22:\"gravityformsconvertkit\";a:1:{s:12:\"translations\";a:17:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-20T15:22:27+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-19T08:12:59+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-19T11:26:33+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-19T07:33:00+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-19T15:26:57+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-05T14:03:37+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-26T15:43:54+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-18T15:58:29+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-04-02T06:42:58+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-18T15:32:27+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-18T18:18:49+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-04-02T14:41:29+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-29T19:00:05+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-20T20:26:46+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-22T07:21:27+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-30T06:26:31+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-30T22:50:03+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:11:\"gravitysmtp\";a:1:{s:12:\"translations\";a:16:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:21+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:82:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:28+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:26+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:27+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:28+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:24+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:26+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:25+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:82:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:23+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:26+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:26+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:25+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:27+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:24+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:25+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:21+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:82:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformsakismet\";a:1:{s:12:\"translations\";a:30:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-09T08:57:30+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T16:10:43+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T15:43:04+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"cs\";a:7:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T16:14:50+00:00\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-cs_CZ.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"cs\";i:1;s:3:\"ces\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-13T09:10:58+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T18:50:14+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T10:41:44+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T10:44:15+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T10:45:19+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T10:41:21+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-13T09:32:38+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-21T08:45:26+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"el\";a:7:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T16:14:11+00:00\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-el.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"el\";i:1;s:3:\"ell\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T10:41:28+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-08T12:27:32+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"id\";a:7:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T10:41:34+00:00\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-id_ID.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"id\";i:1;s:3:\"ind\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-15T07:17:28+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-24T04:38:07+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"fa\";a:7:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T16:08:07+00:00\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-fa_IR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fa\";i:1;s:3:\"fas\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-08T10:26:05+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-23T15:53:18+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-21T10:01:11+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ro\";a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T15:42:58+00:00\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-ro_RO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ro\";i:1;s:3:\"ron\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-09T14:18:02+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"sr\";a:7:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T15:42:59+00:00\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-sr_RS.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sr\";i:1;s:3:\"srp\";}}s:5:\"es-mx\";a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T15:42:48+00:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-es_MX.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-15T21:54:18+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-22T17:38:12+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-17T22:12:34+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-09T14:30:18+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:17:\"gravityformsbrevo\";a:1:{s:12:\"translations\";a:17:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-20T08:53:39+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-27T08:43:30+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-19T11:09:26+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-27T08:45:18+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-18T13:06:27+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-19T09:18:34+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-24T09:49:27+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-27T08:43:44+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-04-01T06:30:47+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-18T14:50:35+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-18T19:08:05+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-23T08:49:53+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-23T08:50:10+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-04-02T09:03:11+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-19T13:13:56+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-27T15:03:10+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-23T08:50:23+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}}s:13:\"_last_checked\";i:1764968642;}", "off");
INSERT INTO `wp_options` VALUES("12524", "_transient_timeout_essential-addons-elementor-license_data", "3336678190", "no");
INSERT INTO `wp_options` VALUES("12525", "_transient_essential-addons-elementor-license_data", "O:8:\"stdClass\":13:{s:7:\"success\";b:1;s:7:\"license\";s:5:\"valid\";s:7:\"item_id\";i:4372;s:9:\"item_name\";s:30:\"Essential Addons for Elementor\";s:13:\"license_limit\";i:0;s:10:\"site_count\";i:22;s:7:\"expires\";s:19:\"2023-04-07 23:59:59\";s:16:\"activations_left\";s:9:\"unlimited\";s:8:\"checksum\";s:32:\"41f75511406db66c432fc2d40c73dba6\";s:10:\"payment_id\";i:829288;s:13:\"customer_name\";s:9:\"Brad Ball\";s:14:\"customer_email\";s:22:\"brad@liquisdigital.com\";s:8:\"price_id\";s:1:\"3\";}", "no");
INSERT INTO `wp_options` VALUES("12530", "astra-sites-batch-status", "in-process", "no");
INSERT INTO `wp_options` VALUES("12619", "user_count", "1", "no");
INSERT INTO `wp_options` VALUES("12595", "_transient_health-check-site-status-result", "{\"good\":16,\"recommended\":7,\"critical\":1}", "yes");
INSERT INTO `wp_options` VALUES("12844", "eael_reduce_op_table_data", "1", "yes");
INSERT INTO `wp_options` VALUES("13528", "astra_admin_settings", "a:4:{s:26:\"addon-setup-admin-migrated\";b:1;s:18:\"self_hosted_gfonts\";b:0;s:19:\"preload_local_fonts\";b:0;s:26:\"theme-setup-admin-migrated\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("13737", "is_beta_enable_rollback_astra-addon", "0", "yes");
INSERT INTO `wp_options` VALUES("13713", "auto_update_plugins", "a:1:{i:0;s:29:\"gravityforms/gravityforms.php\";}", "no");
INSERT INTO `wp_options` VALUES("14632", "gf_telemetry_data", "a:2:{s:8:\"snapshot\";O:64:\"Gravity_Forms\\Gravity_Forms\\Telemetry\\GF_Telemetry_Snapshot_Data\":3:{s:4:\"data\";a:31:{s:3:\"key\";s:32:\"e2981f6e2b4d6c4ee5b305350eb81010\";s:10:\"wp_version\";s:5:\"6.8.3\";s:11:\"php_version\";s:6:\"8.4.14\";s:13:\"mysql_version\";s:7:\"10.6.24\";s:7:\"plugins\";a:12:{i:0;a:4:{s:4:\"name\";s:34:\"Akismet Anti-spam: Spam Protection\";s:4:\"slug\";s:7:\"akismet\";s:7:\"version\";s:3:\"5.5\";s:9:\"is_active\";b:1;}i:1;a:4:{s:4:\"name\";s:9:\"Astra Pro\";s:4:\"slug\";s:11:\"astra-addon\";s:7:\"version\";s:7:\"4.11.10\";s:9:\"is_active\";b:1;}i:2;a:4:{s:4:\"name\";s:14:\"Classic Editor\";s:4:\"slug\";s:14:\"classic-editor\";s:7:\"version\";s:5:\"1.6.7\";s:9:\"is_active\";b:1;}i:3;a:4:{s:4:\"name\";s:10:\"Duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:7:\"version\";s:8:\"1.5.13.3\";s:9:\"is_active\";b:1;}i:4;a:4:{s:4:\"name\";s:9:\"Elementor\";s:4:\"slug\";s:9:\"elementor\";s:7:\"version\";s:6:\"3.32.4\";s:9:\"is_active\";b:1;}i:5;a:4:{s:4:\"name\";s:13:\"Elementor Pro\";s:4:\"slug\";s:13:\"elementor-pro\";s:7:\"version\";s:6:\"3.32.2\";s:9:\"is_active\";b:1;}i:6;a:4:{s:4:\"name\";s:30:\"Essential Addons for Elementor\";s:4:\"slug\";s:35:\"essential-addons-for-elementor-lite\";s:7:\"version\";s:5:\"6.3.3\";s:9:\"is_active\";b:1;}i:7;a:4:{s:4:\"name\";s:36:\"Essential Addons for Elementor - Pro\";s:4:\"slug\";s:26:\"essential-addons-elementor\";s:7:\"version\";s:5:\"6.6.2\";s:9:\"is_active\";b:1;}i:8;a:4:{s:4:\"name\";s:13:\"Gravity Forms\";s:4:\"slug\";s:12:\"gravityforms\";s:7:\"version\";s:6:\"2.9.23\";s:9:\"is_active\";b:1;}i:9;a:4:{s:4:\"name\";s:25:\"Premium Starter Templates\";s:4:\"slug\";s:15:\"astra-pro-sites\";s:7:\"version\";s:6:\"4.4.39\";s:9:\"is_active\";b:1;}i:10;a:4:{s:4:\"name\";s:33:\"Ultimate Addons for Elementor Pro\";s:4:\"slug\";s:18:\"ultimate-elementor\";s:7:\"version\";s:6:\"1.40.5\";s:9:\"is_active\";b:1;}i:11;a:4:{s:4:\"name\";s:12:\"WP Portfolio\";s:4:\"slug\";s:15:\"astra-portfolio\";s:7:\"version\";s:6:\"1.13.2\";s:9:\"is_active\";b:1;}}s:10:\"theme_name\";s:20:\"Liquis Digital Theme\";s:9:\"theme_uri\";s:0:\"\";s:13:\"theme_version\";s:5:\"1.0.0\";s:12:\"theme_author\";s:14:\"Liquis Digital\";s:16:\"theme_author_uri\";s:25:\"https://liquisdigital.com\";s:12:\"is_multisite\";b:0;s:11:\"total_forms\";i:0;s:13:\"total_entries\";s:1:\"0\";s:11:\"emails_sent\";i:0;s:9:\"api_calls\";i:0;s:16:\"entry_meta_count\";i:0;s:19:\"entry_details_count\";i:0;s:17:\"entry_notes_count\";i:0;s:4:\"lang\";s:5:\"en_US\";s:2:\"db\";s:7:\"MariaDB\";s:10:\"autoUpdate\";i:1;s:8:\"currency\";s:3:\"USD\";s:14:\"dataCollection\";i:0;s:5:\"email\";b:0;s:9:\"formTypes\";s:0:\"\";s:14:\"formTypesOther\";b:0;s:11:\"hideLicense\";i:0;s:12:\"organization\";b:0;s:17:\"organizationOther\";b:0;s:8:\"services\";s:0:\"\";s:13:\"servicesOther\";b:0;}s:3:\"key\";s:8:\"snapshot\";s:15:\"data_collection\";b:0;}s:6:\"events\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("15968", "elementor_pro_theme_builder_conditions", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("31843", "_site_transient_timeout_theme_roots", "1764970443", "off");
INSERT INTO `wp_options` VALUES("31844", "_site_transient_theme_roots", "a:2:{s:11:\"astra-child\";s:7:\"/themes\";s:5:\"astra\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("19363", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"1727c65ee0a5912cad27a6f0cb67cf05\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:0:\"\";s:12:\"core/columns\";s:0:\"\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp_options` VALUES("17217", "_elementor_global_css", "a:6:{s:4:\"time\";i:1723562665;s:5:\"fonts\";a:0:{}s:5:\"icons\";a:0:{}s:20:\"dynamic_elements_ids\";a:0:{}s:6:\"status\";s:4:\"file\";i:0;b:0;}", "auto");
INSERT INTO `wp_options` VALUES("14855", "elementor_pro_install_history", "a:22:{s:6:\"3.16.0\";i:1695679377;s:6:\"3.16.2\";i:1710441861;s:6:\"3.16.4\";i:1695679378;s:6:\"3.20.0\";i:1712008938;s:6:\"3.20.1\";i:1710441862;s:6:\"3.20.2\";i:1715901592;s:6:\"3.20.3\";i:1712008939;s:6:\"3.21.2\";i:1716920459;s:6:\"3.21.3\";i:1723135371;s:6:\"3.21.5\";i:1715901593;s:6:\"3.21.8\";i:1716920460;s:6:\"3.23.3\";i:1723135372;s:6:\"3.25.4\";i:1732571170;s:6:\"3.26.2\";i:1735837279;s:6:\"3.26.3\";i:1737128303;s:6:\"3.27.5\";i:1741023474;s:6:\"3.27.6\";i:1741626334;s:6:\"3.28.0\";i:1742574830;s:6:\"3.28.2\";i:1743611962;s:6:\"3.28.4\";i:1747325128;s:6:\"3.29.1\";i:1748976712;s:6:\"3.31.2\";i:1755296402;}", "yes");
INSERT INTO `wp_options` VALUES("14868", "_transient_dirsize_cache", "a:2491:{s:53:\"/home/ldstage/public_html/astra-theme/wp-admin/images\";i:452996;s:54:\"/home/ldstage/public_html/astra-theme/wp-admin/network\";i:125400;s:57:\"/home/ldstage/public_html/astra-theme/wp-admin/js/widgets\";i:139376;s:49:\"/home/ldstage/public_html/astra-theme/wp-admin/js\";i:1922240;s:52:\"/home/ldstage/public_html/astra-theme/wp-admin/maint\";i:7600;s:51:\"/home/ldstage/public_html/astra-theme/wp-admin/user\";i:3418;s:55:\"/home/ldstage/public_html/astra-theme/wp-admin/includes\";i:3013910;s:64:\"/home/ldstage/public_html/astra-theme/wp-admin/css/colors/coffee\";i:75892;s:63:\"/home/ldstage/public_html/astra-theme/wp-admin/css/colors/light\";i:78474;s:66:\"/home/ldstage/public_html/astra-theme/wp-admin/css/colors/midnight\";i:78486;s:67:\"/home/ldstage/public_html/astra-theme/wp-admin/css/colors/ectoplasm\";i:77742;s:62:\"/home/ldstage/public_html/astra-theme/wp-admin/css/colors/blue\";i:77778;s:64:\"/home/ldstage/public_html/astra-theme/wp-admin/css/colors/modern\";i:77989;s:63:\"/home/ldstage/public_html/astra-theme/wp-admin/css/colors/ocean\";i:75229;s:65:\"/home/ldstage/public_html/astra-theme/wp-admin/css/colors/sunrise\";i:78407;s:57:\"/home/ldstage/public_html/astra-theme/wp-admin/css/colors\";i:643556;s:50:\"/home/ldstage/public_html/astra-theme/wp-admin/css\";i:2513119;s:46:\"/home/ldstage/public_html/astra-theme/wp-admin\";i:8950251;s:54:\"/home/ldstage/public_html/astra-theme/wp-snapshots/tmp\";i:0;s:50:\"/home/ldstage/public_html/astra-theme/wp-snapshots\";i:62738985;s:74:\"/home/ldstage/public_html/astra-theme/wp-content/maintenance/assets/images\";i:2548125;s:73:\"/home/ldstage/public_html/astra-theme/wp-content/maintenance/assets/fonts\";i:319200;s:67:\"/home/ldstage/public_html/astra-theme/wp-content/maintenance/assets\";i:2871491;s:60:\"/home/ldstage/public_html/astra-theme/wp-content/maintenance\";i:2873979;s:76:\"/home/ldstage/public_html/astra-theme/wp-content/upgrade-temp-backup/plugins\";i:0;s:68:\"/home/ldstage/public_html/astra-theme/wp-content/upgrade-temp-backup\";i:0;s:56:\"/home/ldstage/public_html/astra-theme/wp-content/upgrade\";i:0;s:48:\"/home/ldstage/public_html/astra-theme/wp-content\";i:2876499;s:57:\"/home/ldstage/public_html/astra-theme/wp-includes/widgets\";i:157888;s:62:\"/home/ldstage/public_html/astra-theme/wp-includes/images/media\";i:2419;s:64:\"/home/ldstage/public_html/astra-theme/wp-includes/images/smilies\";i:10082;s:64:\"/home/ldstage/public_html/astra-theme/wp-includes/images/crystal\";i:15541;s:56:\"/home/ldstage/public_html/astra-theme/wp-includes/images\";i:99334;s:60:\"/home/ldstage/public_html/astra-theme/wp-includes/php-compat\";i:1251;s:55:\"/home/ldstage/public_html/astra-theme/wp-includes/fonts\";i:289826;s:63:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/spacer\";i:4647;s:62:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/group\";i:12974;s:75:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/post-comments-form\";i:9560;s:65:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/archives\";i:1671;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/home-link\";i:1076;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/footnotes\";i:1605;s:69:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/post-excerpt\";i:2871;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/pullquote\";i:7773;s:73:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/query-no-results\";i:845;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/tag-cloud\";i:3446;s:76:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/comments-pagination\";i:8439;s:62:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/quote\";i:6217;s:84:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/comments-pagination-numbers\";i:1779;s:72:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/navigation-link\";i:11573;s:69:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/comment-date\";i:1058;s:61:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/list\";i:2030;s:64:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/columns\";i:8769;s:62:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/image\";i:39613;s:62:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/query\";i:6756;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/shortcode\";i:3216;s:71:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/page-list-item\";i:1055;s:67:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/post-terms\";i:1661;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/site-logo\";i:16147;s:73:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/query-pagination\";i:9221;s:70:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/legacy-widget\";i:501;s:72:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/latest-comments\";i:6603;s:67:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/categories\";i:2771;s:76:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/comment-author-name\";i:1138;s:63:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/search\";i:16453;s:81:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/comments-pagination-next\";i:957;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/list-item\";i:876;s:64:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/classic\";i:0;s:69:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/latest-posts\";i:11200;s:64:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/buttons\";i:11092;s:64:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/pattern\";i:336;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/read-more\";i:2280;s:70:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/template-part\";i:8427;s:62:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/video\";i:11407;s:65:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/loginout\";i:828;s:68:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/query-title\";i:1393;s:67:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/media-text\";i:13714;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/page-list\";i:7792;s:63:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/avatar\";i:2101;s:69:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/widget-group\";i:319;s:64:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/details\";i:2488;s:73:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/post-author-name\";i:1069;s:64:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/gallery\";i:74915;s:67:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/navigation\";i:140424;s:75:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/navigation-submenu\";i:5812;s:62:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/table\";i:28464;s:62:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/audio\";i:3542;s:81:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/query-pagination-numbers\";i:1788;s:82:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/query-pagination-previous\";i:964;s:61:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/more\";i:3698;s:65:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/calendar\";i:3750;s:85:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/comments-pagination-previous\";i:969;s:61:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/code\";i:2535;s:68:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/post-author\";i:2846;s:65:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/comments\";i:28862;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/post-date\";i:1293;s:61:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/html\";i:3678;s:63:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/column\";i:1453;s:73:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/comment-template\";i:2856;s:62:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/embed\";i:11032;s:69:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/site-tagline\";i:1516;s:62:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/cover\";i:78276;s:70:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/post-template\";i:6190;s:75:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/comment-reply-link\";i:1001;s:71:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/comments-title\";i:1646;s:76:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/post-featured-image\";i:26071;s:69:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/post-content\";i:831;s:61:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/file\";i:10005;s:68:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/social-link\";i:2290;s:78:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/post-author-biography\";i:922;s:67:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/post-title\";i:1824;s:60:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/rss\";i:5023;s:72:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/comment-content\";i:1369;s:63:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/button\";i:25357;s:65:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/freeform\";i:41012;s:78:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/query-pagination-next\";i:952;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/paragraph\";i:5213;s:77:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/post-navigation-link\";i:3059;s:62:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/verse\";i:1844;s:69:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/social-links\";i:51742;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/separator\";i:5308;s:69:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/preformatted\";i:1468;s:67:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/site-title\";i:2253;s:69:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/text-columns\";i:2980;s:65:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/nextpage\";i:2985;s:64:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/heading\";i:2135;s:74:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/comment-edit-link\";i:1159;s:73:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/term-description\";i:1697;s:62:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/block\";i:5039;s:64:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks/missing\";i:564;s:56:\"/home/ldstage/public_html/astra-theme/wp-includes/blocks\";i:1382131;s:62:\"/home/ldstage/public_html/astra-theme/wp-includes/style-engine\";i:40827;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/Text/Diff/Engine\";i:31802;s:68:\"/home/ldstage/public_html/astra-theme/wp-includes/Text/Diff/Renderer\";i:5528;s:59:\"/home/ldstage/public_html/astra-theme/wp-includes/Text/Diff\";i:44136;s:54:\"/home/ldstage/public_html/astra-theme/wp-includes/Text\";i:57048;s:68:\"/home/ldstage/public_html/astra-theme/wp-includes/sitemaps/providers\";i:16711;s:58:\"/home/ldstage/public_html/astra-theme/wp-includes/sitemaps\";i:46869;s:59:\"/home/ldstage/public_html/astra-theme/wp-includes/customize\";i:174797;s:59:\"/home/ldstage/public_html/astra-theme/wp-includes/PHPMailer\";i:228586;s:64:\"/home/ldstage/public_html/astra-theme/wp-includes/block-supports\";i:94951;s:64:\"/home/ldstage/public_html/astra-theme/wp-includes/block-patterns\";i:8843;s:68:\"/home/ldstage/public_html/astra-theme/wp-includes/rest-api/endpoints\";i:760389;s:65:\"/home/ldstage/public_html/astra-theme/wp-includes/rest-api/fields\";i:22340;s:65:\"/home/ldstage/public_html/astra-theme/wp-includes/rest-api/search\";i:15909;s:58:\"/home/ldstage/public_html/astra-theme/wp-includes/rest-api\";i:886114;s:77:\"/home/ldstage/public_html/astra-theme/wp-includes/Requests/src/Exception/Http\";i:16715;s:82:\"/home/ldstage/public_html/astra-theme/wp-includes/Requests/src/Exception/Transport\";i:1397;s:72:\"/home/ldstage/public_html/astra-theme/wp-includes/Requests/src/Exception\";i:22464;s:71:\"/home/ldstage/public_html/astra-theme/wp-includes/Requests/src/Response\";i:3101;s:68:\"/home/ldstage/public_html/astra-theme/wp-includes/Requests/src/Proxy\";i:4217;s:67:\"/home/ldstage/public_html/astra-theme/wp-includes/Requests/src/Auth\";i:2541;s:70:\"/home/ldstage/public_html/astra-theme/wp-includes/Requests/src/Utility\";i:7176;s:72:\"/home/ldstage/public_html/astra-theme/wp-includes/Requests/src/Transport\";i:35060;s:69:\"/home/ldstage/public_html/astra-theme/wp-includes/Requests/src/Cookie\";i:4363;s:62:\"/home/ldstage/public_html/astra-theme/wp-includes/Requests/src\";i:213372;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/Requests/library\";i:261;s:58:\"/home/ldstage/public_html/astra-theme/wp-includes/Requests\";i:213633;s:64:\"/home/ldstage/public_html/astra-theme/wp-includes/js/dist/vendor\";i:2539861;s:69:\"/home/ldstage/public_html/astra-theme/wp-includes/js/dist/development\";i:178306;s:57:\"/home/ldstage/public_html/astra-theme/wp-includes/js/dist\";i:18943781;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/js/imgareaselect\";i:49553;s:62:\"/home/ldstage/public_html/astra-theme/wp-includes/js/swfupload\";i:8715;s:58:\"/home/ldstage/public_html/astra-theme/wp-includes/js/jcrop\";i:24976;s:62:\"/home/ldstage/public_html/astra-theme/wp-includes/js/jquery/ui\";i:808535;s:59:\"/home/ldstage/public_html/astra-theme/wp-includes/js/jquery\";i:1325882;s:74:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/themes/inlite\";i:452642;s:74:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/themes/modern\";i:446221;s:67:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/themes\";i:898863;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/langs\";i:15529;s:75:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/wplink\";i:26476;s:73:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/link\";i:32949;s:74:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/paste\";i:113193;s:74:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/image\";i:55874;s:77:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/tabfocus\";i:5336;s:81:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/compat3x/css\";i:8179;s:77:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/compat3x\";i:21758;s:76:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/wpemoji\";i:5099;s:74:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/media\";i:57914;s:81:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/wpautoresize\";i:8332;s:79:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/fullscreen\";i:7779;s:78:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/wordpress\";i:50628;s:74:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/lists\";i:97383;s:78:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/textcolor\";i:16237;s:83:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/directionality\";i:2749;s:78:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/wpgallery\";i:4806;s:78:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/wpdialogs\";i:3761;s:80:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/colorpicker\";i:4910;s:75:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/wpview\";i:8985;s:76:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/charmap\";i:31811;s:82:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/wptextpattern\";i:11923;s:80:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/wpeditimage\";i:37711;s:71:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins/hr\";i:1347;s:68:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/plugins\";i:606961;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/utils\";i:18822;s:83:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/skins/wordpress/images\";i:14207;s:76:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/skins/wordpress\";i:22831;s:82:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/skins/lightgray/fonts\";i:155760;s:80:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/skins/lightgray/img\";i:2856;s:76:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/skins/lightgray\";i:210254;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce/skins\";i:233085;s:60:\"/home/ldstage/public_html/astra-theme/wp-includes/js/tinymce\";i:2853651;s:61:\"/home/ldstage/public_html/astra-theme/wp-includes/js/thickbox\";i:31233;s:75:\"/home/ldstage/public_html/astra-theme/wp-includes/js/mediaelement/renderers\";i:18880;s:65:\"/home/ldstage/public_html/astra-theme/wp-includes/js/mediaelement\";i:721307;s:61:\"/home/ldstage/public_html/astra-theme/wp-includes/js/plupload\";i:489844;s:57:\"/home/ldstage/public_html/astra-theme/wp-includes/js/crop\";i:20004;s:63:\"/home/ldstage/public_html/astra-theme/wp-includes/js/codemirror\";i:1287141;s:52:\"/home/ldstage/public_html/astra-theme/wp-includes/js\";i:28171622;s:62:\"/home/ldstage/public_html/astra-theme/wp-includes/certificates\";i:233231;s:54:\"/home/ldstage/public_html/astra-theme/wp-includes/pomo\";i:54211;s:53:\"/home/ldstage/public_html/astra-theme/wp-includes/ID3\";i:1155209;s:67:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/lib\";i:87360;s:81:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/src/Core/ChaCha20\";i:5264;s:79:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/src/Core/Base64\";i:22135;s:81:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/src/Core/Poly1305\";i:12912;s:86:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/src/Core/Curve25519/Ge\";i:7881;s:83:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/src/Core/Curve25519\";i:121645;s:85:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/src/Core/SecretStream\";i:3624;s:72:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/src/Core\";i:452743;s:73:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/src/PHP52\";i:4116;s:83:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/src/Core32/ChaCha20\";i:6407;s:83:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/src/Core32/Poly1305\";i:15965;s:88:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/src/Core32/Curve25519/Ge\";i:8177;s:85:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/src/Core32/Curve25519\";i:122690;s:87:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/src/Core32/SecretStream\";i:3656;s:74:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/src/Core32\";i:437041;s:67:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/src\";i:1207254;s:88:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/namespaced/Core/ChaCha20\";i:224;s:88:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/namespaced/Core/Poly1305\";i:112;s:93:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/namespaced/Core/Curve25519/Ge\";i:602;s:90:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/namespaced/Core/Curve25519\";i:820;s:79:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/namespaced/Core\";i:2444;s:74:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat/namespaced\";i:2698;s:63:\"/home/ldstage/public_html/astra-theme/wp-includes/sodium_compat\";i:1303525;s:56:\"/home/ldstage/public_html/astra-theme/wp-includes/assets\";i:24546;s:75:\"/home/ldstage/public_html/astra-theme/wp-includes/SimplePie/XML/Declaration\";i:7098;s:63:\"/home/ldstage/public_html/astra-theme/wp-includes/SimplePie/XML\";i:7098;s:65:\"/home/ldstage/public_html/astra-theme/wp-includes/SimplePie/Parse\";i:20551;s:65:\"/home/ldstage/public_html/astra-theme/wp-includes/SimplePie/Cache\";i:39607;s:72:\"/home/ldstage/public_html/astra-theme/wp-includes/SimplePie/Content/Type\";i:8015;s:67:\"/home/ldstage/public_html/astra-theme/wp-includes/SimplePie/Content\";i:8015;s:71:\"/home/ldstage/public_html/astra-theme/wp-includes/SimplePie/Decode/HTML\";i:17241;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/SimplePie/Decode\";i:17241;s:63:\"/home/ldstage/public_html/astra-theme/wp-includes/SimplePie/Net\";i:7493;s:64:\"/home/ldstage/public_html/astra-theme/wp-includes/SimplePie/HTTP\";i:11487;s:59:\"/home/ldstage/public_html/astra-theme/wp-includes/SimplePie\";i:458625;s:53:\"/home/ldstage/public_html/astra-theme/wp-includes/IXR\";i:33915;s:58:\"/home/ldstage/public_html/astra-theme/wp-includes/html-api\";i:79517;s:76:\"/home/ldstage/public_html/astra-theme/wp-includes/css/dist/customize-widgets\";i:26444;s:69:\"/home/ldstage/public_html/astra-theme/wp-includes/css/dist/components\";i:353661;s:66:\"/home/ldstage/public_html/astra-theme/wp-includes/css/dist/widgets\";i:23542;s:68:\"/home/ldstage/public_html/astra-theme/wp-includes/css/dist/edit-site\";i:372836;s:72:\"/home/ldstage/public_html/astra-theme/wp-includes/css/dist/block-library\";i:780066;s:74:\"/home/ldstage/public_html/astra-theme/wp-includes/css/dist/reusable-blocks\";i:2076;s:79:\"/home/ldstage/public_html/astra-theme/wp-includes/css/dist/list-reusable-blocks\";i:17714;s:74:\"/home/ldstage/public_html/astra-theme/wp-includes/css/dist/block-directory\";i:15034;s:73:\"/home/ldstage/public_html/astra-theme/wp-includes/css/dist/format-library\";i:7080;s:71:\"/home/ldstage/public_html/astra-theme/wp-includes/css/dist/block-editor\";i:595695;s:67:\"/home/ldstage/public_html/astra-theme/wp-includes/css/dist/commands\";i:11916;s:62:\"/home/ldstage/public_html/astra-theme/wp-includes/css/dist/nux\";i:11478;s:71:\"/home/ldstage/public_html/astra-theme/wp-includes/css/dist/edit-widgets\";i:106312;s:68:\"/home/ldstage/public_html/astra-theme/wp-includes/css/dist/edit-post\";i:208854;s:65:\"/home/ldstage/public_html/astra-theme/wp-includes/css/dist/editor\";i:76504;s:58:\"/home/ldstage/public_html/astra-theme/wp-includes/css/dist\";i:2609212;s:53:\"/home/ldstage/public_html/astra-theme/wp-includes/css\";i:3254483;s:62:\"/home/ldstage/public_html/astra-theme/wp-includes/theme-compat\";i:15446;s:49:\"/home/ldstage/public_html/astra-theme/wp-includes\";i:45440110;s:37:\"/home/ldstage/public_html/astra-theme\";i:120188457;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/lib/astra-notices\";i:13502;s:77:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/lib/webfont\";i:16861;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/lib/batch-processing\";i:13855;s:69:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/lib\";i:44218;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/metabox/extend-metabox/build\";i:1469475;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/metabox/extend-metabox/css/minified\";i:14113;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/metabox/extend-metabox/css/unminified\";i:16905;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/metabox/extend-metabox/css\";i:31018;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/metabox/extend-metabox\";i:1500493;s:73:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/metabox\";i:1549487;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/base/dynamic-css/widget\";i:8361;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/base/dynamic-css/html\";i:6452;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/base/dynamic-css/social\";i:22996;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/base/dynamic-css/button\";i:10044;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/base/dynamic-css\";i:47853;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/base/assets/js\";i:34560;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/base/assets\";i:34560;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/base\";i:82413;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/above-footer/dynamic-css\";i:6149;s:117:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/above-footer/assets/js/minified\";i:2211;s:119:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/above-footer/assets/js/unminified\";i:4373;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/above-footer/assets/js\";i:6584;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/above-footer/assets\";i:6584;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/above-footer\";i:15330;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/widget/dynamic-css\";i:3194;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/widget/assets/js/minified\";i:42;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/widget/assets/js/unminified\";i:416;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/widget/assets/js\";i:458;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/widget/assets\";i:458;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/widget\";i:6701;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/menu/dynamic-css\";i:15424;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/menu/assets/js/minified\";i:5226;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/menu/assets/js/unminified\";i:10662;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/menu/assets/js\";i:15888;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/menu/assets\";i:15888;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/menu\";i:36162;s:112:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/primary-footer/dynamic-css\";i:7168;s:119:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/primary-footer/assets/js/minified\";i:2395;s:121:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/primary-footer/assets/js/unminified\";i:4282;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/primary-footer/assets/js\";i:6677;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/primary-footer/assets\";i:6677;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/primary-footer\";i:16731;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/social-icon/dynamic-css\";i:720;s:116:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/social-icon/assets/js/minified\";i:83;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/social-icon/assets/js/unminified\";i:452;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/social-icon/assets/js\";i:535;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/social-icon/assets\";i:535;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/social-icon\";i:4282;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/html/dynamic-css\";i:2380;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/html/assets/js/minified\";i:907;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/html/assets/js/unminified\";i:1942;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/html/assets/js\";i:2849;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/html/assets\";i:2849;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/html\";i:8098;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/below-footer/dynamic-css\";i:6151;s:117:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/below-footer/assets/js/minified\";i:2211;s:119:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/below-footer/assets/js/unminified\";i:4516;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/below-footer/assets/js\";i:6727;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/below-footer/assets\";i:6727;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/below-footer\";i:15482;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/button/dynamic-css\";i:2468;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/button/assets/js/minified\";i:87;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/button/assets/js/unminified\";i:453;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/button/assets/js\";i:540;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/button/assets\";i:540;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/button\";i:6590;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/copyright/dynamic-css\";i:3350;s:114:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/copyright/assets/js/minified\";i:2031;s:116:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/copyright/assets/js/unminified\";i:4762;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/copyright/assets/js\";i:6793;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/copyright/assets\";i:6793;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer/copyright\";i:12776;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/footer\";i:122152;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/widget/dynamic-css\";i:694;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/widget/assets/js/minified\";i:42;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/widget/assets/js/unminified\";i:415;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/widget/assets/js\";i:457;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/widget/assets\";i:457;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/widget\";i:4200;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/woo-cart/dynamic-css\";i:45502;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/woo-cart/assets/js/minified\";i:16592;s:115:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/woo-cart/assets/js/unminified\";i:23392;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/woo-cart/assets/js\";i:39984;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/woo-cart/assets\";i:39984;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/woo-cart\";i:88268;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/mobile-menu/dynamic-css\";i:15790;s:116:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/mobile-menu/assets/js/minified\";i:8589;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/mobile-menu/assets/js/unminified\";i:16956;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/mobile-menu/assets/js\";i:25545;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/mobile-menu/assets\";i:25545;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/mobile-menu\";i:47017;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/menu/dynamic-css\";i:21688;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/menu/assets/js/minified\";i:12091;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/menu/assets/js/unminified\";i:19911;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/menu/assets/js\";i:32002;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/menu/assets\";i:32002;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/menu\";i:61691;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/edd-cart/dynamic-css\";i:19837;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/edd-cart/assets/js/minified\";i:5425;s:115:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/edd-cart/assets/js/unminified\";i:7382;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/edd-cart/assets/js\";i:12807;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/edd-cart/assets\";i:12807;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/edd-cart\";i:35111;s:112:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/mobile-trigger/dynamic-css\";i:10340;s:119:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/mobile-trigger/assets/js/minified\";i:4393;s:121:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/mobile-trigger/assets/js/unminified\";i:7241;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/mobile-trigger/assets/js\";i:11634;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/mobile-trigger/assets\";i:11634;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/mobile-trigger\";i:24405;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/below-header/dynamic-css\";i:6155;s:117:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/below-header/assets/js/minified\";i:2010;s:119:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/below-header/assets/js/unminified\";i:3331;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/below-header/assets/js\";i:5341;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/below-header/assets\";i:5341;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/below-header\";i:13899;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/off-canvas/dynamic-css\";i:22251;s:115:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/off-canvas/assets/js/minified\";i:5399;s:117:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/off-canvas/assets/js/unminified\";i:9000;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/off-canvas/assets/js\";i:14399;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/off-canvas/assets\";i:14399;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/off-canvas\";i:39018;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/search/dynamic-css\";i:5373;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/search/assets/js/minified\";i:2202;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/search/assets/js/unminified\";i:4668;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/search/assets/js\";i:6870;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/search/assets\";i:6870;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/search\";i:15205;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/above-header/dynamic-css\";i:6196;s:117:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/above-header/assets/js/minified\";i:1991;s:119:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/above-header/assets/js/unminified\";i:3312;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/above-header/assets/js\";i:5303;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/above-header/assets\";i:5303;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/above-header\";i:13901;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/social-icon/dynamic-css\";i:696;s:116:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/social-icon/assets/js/minified\";i:83;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/social-icon/assets/js/unminified\";i:449;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/social-icon/assets/js\";i:532;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/social-icon/assets\";i:532;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/social-icon\";i:4130;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/html/dynamic-css\";i:684;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/html/assets/js/minified\";i:77;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/html/assets/js/unminified\";i:454;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/html/assets/js\";i:531;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/html/assets\";i:531;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/html\";i:3926;s:112:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/primary-header/dynamic-css\";i:9091;s:119:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/primary-header/assets/js/minified\";i:4105;s:121:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/primary-header/assets/js/unminified\";i:7308;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/primary-header/assets/js\";i:11413;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/primary-header/assets\";i:11413;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/primary-header\";i:23898;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/account/dynamic-css\";i:6066;s:112:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/account/assets/js/minified\";i:3429;s:114:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/account/assets/js/unminified\";i:6725;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/account/assets/js\";i:10154;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/account/assets\";i:10154;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/account\";i:22568;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/site-identity/dynamic-css\";i:2577;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/site-identity/assets/js/minified\";i:1660;s:120:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/site-identity/assets/js/unminified\";i:3736;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/site-identity/assets/js\";i:5396;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/site-identity/assets\";i:5396;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/site-identity\";i:10439;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/button/dynamic-css\";i:678;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/button/assets/js/minified\";i:81;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/button/assets/js/unminified\";i:447;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/button/assets/js\";i:528;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/button/assets\";i:528;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header/button\";i:4659;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type/header\";i:412335;s:78:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/type\";i:634576;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/controllers\";i:22909;s:80:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder/markup\";i:20577;s:73:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/builder\";i:683360;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/modules/posts-structures/assets/js/minified\";i:16460;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/modules/posts-structures/assets/js/unminified\";i:21635;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/modules/posts-structures/assets/js\";i:38095;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/modules/posts-structures/assets\";i:38095;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/modules/posts-structures/customizer\";i:91248;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/modules/posts-structures/css\";i:38636;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/modules/posts-structures\";i:187075;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/modules/related-posts/customizer\";i:33517;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/modules/related-posts/css\";i:13352;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/modules/related-posts\";i:70938;s:73:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/modules\";i:258013;s:77:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/dynamic-css\";i:91413;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/compatibility/woocommerce/customizer/sections/layout\";i:44296;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/compatibility/woocommerce/customizer/sections\";i:56024;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/compatibility/woocommerce/customizer\";i:58092;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/compatibility/woocommerce\";i:229982;s:116:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/compatibility/lifterlms/customizer/sections/layout\";i:3888;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/compatibility/lifterlms/customizer/sections\";i:16133;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/compatibility/lifterlms/customizer\";i:17570;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/compatibility/lifterlms\";i:51765;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/compatibility/starter-content\";i:181561;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/compatibility/edd/customizer/sections/layout\";i:10389;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/compatibility/edd/customizer/sections\";i:17836;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/compatibility/edd/customizer\";i:19707;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/compatibility/edd\";i:66648;s:116:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/compatibility/learndash/customizer/sections/layout\";i:1979;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/compatibility/learndash/customizer/sections\";i:9517;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/compatibility/learndash/customizer\";i:11069;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/compatibility/learndash\";i:38373;s:79:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/compatibility\";i:709248;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/scroll-to-top/classes/customizer\";i:10493;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/scroll-to-top/classes\";i:14867;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/scroll-to-top/assets/js/minified\";i:1865;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/scroll-to-top/assets/js/unminified\";i:4354;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/scroll-to-top/assets/js\";i:6219;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/scroll-to-top/assets\";i:6219;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/scroll-to-top/css\";i:5872;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/scroll-to-top\";i:28662;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/heading-colors/dynamic-css\";i:1337;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/heading-colors/assets/js/minified\";i:6604;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/heading-colors/assets/js/unminified\";i:9556;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/heading-colors/assets/js\";i:16160;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/heading-colors/assets\";i:16160;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/heading-colors/customizer\";i:4941;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/heading-colors\";i:32988;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/breadcrumbs/dynamic-css\";i:25652;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/breadcrumbs/assets/js/minified\";i:6111;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/breadcrumbs/assets/js/unminified\";i:8182;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/breadcrumbs/assets/js\";i:14293;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/breadcrumbs/assets\";i:14293;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/breadcrumbs/customizer\";i:31592;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/breadcrumbs\";i:129436;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/transparent-header/classes/dynamic-css\";i:94271;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/transparent-header/classes/sections\";i:55203;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/transparent-header/classes\";i:168726;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/transparent-header/assets/js/minified\";i:33814;s:112:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/transparent-header/assets/js/unminified\";i:37880;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/transparent-header/assets/js\";i:71694;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/transparent-header/assets\";i:71694;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons/transparent-header\";i:242208;s:72:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/addons\";i:433294;s:70:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/blog\";i:37823;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/assets/images/starter-content\";i:105938;s:79:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/assets/images\";i:606947;s:78:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/assets/fonts\";i:4990;s:75:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/assets/js\";i:43700;s:76:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/assets/css\";i:383588;s:72:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/assets\";i:1039225;s:78:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/core/builder\";i:101421;s:81:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/core/deprecated\";i:18390;s:77:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/core/markup\";i:10095;s:70:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/core\";i:417010;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/extend-customizer\";i:3957;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/astra-pro\";i:3322;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/configurations/global-misc\";i:1273;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/configurations/layout\";i:83725;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/configurations/builder/base\";i:46260;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/configurations/builder/footer\";i:61696;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/configurations/builder/header\";i:179754;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/configurations/builder\";i:306492;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/configurations/accessibility\";i:4390;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/configurations/buttons\";i:43674;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/configurations/typography\";i:67235;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/configurations/block-editor\";i:3632;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/configurations/colors-background\";i:12928;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/configurations\";i:525722;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/custom-controls/description\";i:1052;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/custom-controls/typography\";i:22599;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/custom-controls/assets/js/unminified\";i:154622;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/custom-controls/assets/js\";i:154622;s:112:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/custom-controls/assets/css/minified\";i:222530;s:114:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/custom-controls/assets/css/unminified\";i:526752;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/custom-controls/assets/css\";i:749282;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/custom-controls/assets\";i:903904;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/custom-controls/customizer-link\";i:1399;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/custom-controls\";i:934127;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/extend-custom-controls/build\";i:4495312;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer/extend-custom-controls\";i:4495312;s:76:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/customizer\";i:6084908;s:72:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/schema\";i:20925;s:78:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc/theme-update\";i:172200;s:65:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/inc\";i:12136652;s:80:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/admin/assets/build\";i:1222717;s:74:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/admin/assets\";i:1222717;s:76:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/admin/includes\";i:60955;s:67:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/admin\";i:1285295;s:75:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/assets/images\";i:47933;s:74:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/assets/fonts\";i:14231;s:80:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/assets/js/minified\";i:147693;s:82:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/assets/js/unminified\";i:249251;s:71:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/assets/js\";i:396944;s:72:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/assets/svg\";i:3398800;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/assets/css/minified/compatibility/woocommerce\";i:567634;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/assets/css/minified/compatibility/page-builder\";i:1463;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/assets/css/minified/compatibility\";i:751785;s:81:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/assets/css/minified\";i:1341032;s:72:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/assets/css\";i:1341032;s:68:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/assets\";i:5198940;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/template-parts/footer/builder\";i:8075;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/template-parts/footer\";i:11278;s:81:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/template-parts/blog\";i:1164;s:80:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/template-parts/404\";i:978;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/template-parts/single\";i:2695;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/template-parts/header/builder\";i:16241;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/template-parts/header\";i:17267;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/template-parts/advanced-footer\";i:2129;s:76:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/template-parts\";i:45400;s:71:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra/languages\";i:285404;s:61:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra\";i:19481601;s:67:\"/home/ldstage/public_html/astra-theme/wp-content/themes/astra-child\";i:68753;s:55:\"/home/ldstage/public_html/astra-theme/wp-content/themes\";i:19550382;s:73:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/akismet/_inc/rtl\";i:19825;s:75:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/akismet/_inc/fonts\";i:2193;s:73:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/akismet/_inc/img\";i:17542;s:69:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/akismet/_inc\";i:83530;s:70:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/akismet/views\";i:39133;s:64:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/akismet\";i:320699;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/base/dynamic-css/social-icon\";i:4791;s:114:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/base/dynamic-css/divider\";i:9958;s:124:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/base/dynamic-css/language-switcher\";i:4251;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/base/dynamic-css/button\";i:1447;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/base/dynamic-css\";i:22503;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/base/configurations\";i:32500;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/base/controllers\";i:8079;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/base/assets/js\";i:23987;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/base/assets\";i:23987;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/base\";i:87069;s:116:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/social-icon/classes\";i:2091;s:120:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/social-icon/dynamic-css\";i:720;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/social-icon/assets/js\";i:474;s:120:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/social-icon/assets/scss\";i:0;s:128:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/social-icon/assets/css/minified\";i:1300;s:130:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/social-icon/assets/css/unminified\";i:1534;s:119:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/social-icon/assets/css\";i:2834;s:115:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/social-icon/assets\";i:3308;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/social-icon\";i:8685;s:112:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/divider/classes\";i:2922;s:116:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/divider/dynamic-css\";i:3182;s:123:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/divider/assets/js/minified\";i:872;s:125:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/divider/assets/js/unminified\";i:2255;s:114:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/divider/assets/js\";i:3127;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/divider/assets\";i:3127;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/divider\";i:11796;s:122:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/language-switcher/classes\";i:2755;s:126:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/language-switcher/dynamic-css\";i:2095;s:124:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/language-switcher/assets/js\";i:2290;s:121:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/language-switcher/assets\";i:2290;s:114:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/language-switcher\";i:9644;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/button/classes\";i:2343;s:115:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/button/dynamic-css\";i:723;s:122:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/button/assets/js/minified\";i:83;s:124:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/button/assets/js/unminified\";i:464;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/button/assets/js\";i:547;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/button/assets\";i:547;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer/button\";i:6143;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/footer\";i:36268;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/menu/classes\";i:2173;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/menu/dynamic-css\";i:1352;s:120:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/menu/assets/js/minified\";i:409;s:122:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/menu/assets/js/unminified\";i:984;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/menu/assets/js\";i:1393;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/menu/assets\";i:1393;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/menu\";i:7493;s:115:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/off-canvas/classes\";i:18460;s:119:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/off-canvas/dynamic-css\";i:1949;s:126:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/off-canvas/assets/js/minified\";i:654;s:128:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/off-canvas/assets/js/unminified\";i:1829;s:117:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/off-canvas/assets/js\";i:2483;s:114:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/off-canvas/assets\";i:2483;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/off-canvas\";i:25796;s:116:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/social-icon/classes\";i:2091;s:120:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/social-icon/dynamic-css\";i:720;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/social-icon/assets/js\";i:474;s:120:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/social-icon/assets/scss\";i:0;s:128:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/social-icon/assets/css/minified\";i:1300;s:130:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/social-icon/assets/css/unminified\";i:1534;s:119:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/social-icon/assets/css\";i:2834;s:115:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/social-icon/assets\";i:3308;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/social-icon\";i:8685;s:112:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/divider/classes\";i:2632;s:116:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/divider/dynamic-css\";i:719;s:123:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/divider/assets/js/minified\";i:83;s:125:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/divider/assets/js/unminified\";i:458;s:114:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/divider/assets/js\";i:541;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/divider/assets\";i:541;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/divider\";i:6455;s:112:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/account/classes\";i:2472;s:116:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/account/dynamic-css\";i:1811;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/account\";i:18777;s:122:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/language-switcher/classes\";i:2636;s:126:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/language-switcher/dynamic-css\";i:866;s:124:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/language-switcher/assets/js\";i:435;s:121:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/language-switcher/assets\";i:435;s:114:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/language-switcher\";i:6609;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/button/classes\";i:2283;s:115:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/button/dynamic-css\";i:722;s:122:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/button/assets/js/minified\";i:83;s:124:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/button/assets/js/unminified\";i:464;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/button/assets/js\";i:547;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/button/assets\";i:547;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header/button\";i:5941;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type/header\";i:79756;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/type\";i:203093;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/assets/scss\";i:7255;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/assets/css/minified\";i:12074;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/assets/css/unminified\";i:14664;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/assets/css\";i:26738;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/assets\";i:33993;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder/markup\";i:4582;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/builder\";i:259716;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/modules/target-rule/i18n\";i:49077;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/modules/target-rule\";i:280293;s:116:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/modules/menu-sidebar/assets/js/minified\";i:9571;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/modules/menu-sidebar/assets/js/unminified\";i:12727;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/modules/menu-sidebar/assets/js\";i:22298;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/modules/menu-sidebar/assets\";i:22298;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/modules/menu-sidebar\";i:27626;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/modules\";i:307919;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/compatibility\";i:33831;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/deprecated\";i:42835;s:82:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/cache\";i:19098;s:116:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/library/image-processing-queue/includes\";i:11540;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/library/image-processing-queue\";i:12271;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/library/batch-processing\";i:15270;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/library\";i:27541;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/customizer/extend-controls/build\";i:65611;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/customizer/extend-controls\";i:65611;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/customizer/assets/js\";i:65611;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/customizer/assets/css\";i:255;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/customizer/assets\";i:65866;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/customizer/controls\";i:1672;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes/customizer\";i:148799;s:76:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/classes\";i:1098202;s:82:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/compatibility\";i:4205;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/woocommerce/classes/sections\";i:182444;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/woocommerce/classes\";i:532574;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/woocommerce/templates\";i:25916;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/woocommerce/assets/js/minified\";i:95818;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/woocommerce/assets/js/unminified\";i:147021;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/woocommerce/assets/js\";i:242839;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/woocommerce/assets/css/minified\";i:219192;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/woocommerce/assets/css/unminified\";i:248086;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/woocommerce/assets/css\";i:467278;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/woocommerce/assets\";i:710117;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/woocommerce\";i:1270822;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/header-sections/classes/sections\";i:102729;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/header-sections/classes\";i:242119;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/header-sections/template\";i:4643;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/header-sections/assets/images\";i:1819;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/header-sections/assets/js/minified\";i:34875;s:112:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/header-sections/assets/js/unminified\";i:44953;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/header-sections/assets/js\";i:79828;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/header-sections/assets/css/minified\";i:73753;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/header-sections/assets/css/unminified\";i:72101;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/header-sections/assets/css\";i:145854;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/header-sections/assets\";i:227501;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/header-sections\";i:476013;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/site-layouts/classes/sections\";i:7998;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/site-layouts/classes\";i:27047;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/site-layouts/assets/js/minified\";i:4593;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/site-layouts/assets/js/unminified\";i:7637;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/site-layouts/assets/js\";i:12230;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/site-layouts/assets/css/minified\";i:3427;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/site-layouts/assets/css/unminified\";i:4547;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/site-layouts/assets/css\";i:7974;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/site-layouts/assets\";i:20204;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/site-layouts\";i:48751;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/nav-menu/classes/sections\";i:46401;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/nav-menu/classes\";i:228802;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/nav-menu/template\";i:304;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/nav-menu/assets/js/minified\";i:24530;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/nav-menu/assets/js/unminified\";i:37621;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/nav-menu/assets/js\";i:62151;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/nav-menu/assets/css/minified\";i:101942;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/nav-menu/assets/css/unminified\";i:116502;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/nav-menu/assets/css\";i:218444;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/nav-menu/assets\";i:280595;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/nav-menu/react/build\";i:3220085;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/nav-menu/react\";i:3802402;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/nav-menu\";i:4314099;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-hooks/classes\";i:204815;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-hooks/template\";i:656;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-hooks/assets/js/minified\";i:58398;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-hooks/assets/js/unminified\";i:28401;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-hooks/assets/js\";i:86799;s:117:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-hooks/assets/css/minified/images\";i:11402;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-hooks/assets/css/minified\";i:98685;s:112:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-hooks/assets/css/unminified\";i:67230;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-hooks/assets/css\";i:165915;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-hooks/assets\";i:252714;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-hooks/react/build\";i:171226;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-hooks/react/css/minified\";i:259;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-hooks/react/css/unminified\";i:298;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-hooks/react/css\";i:557;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-hooks/react\";i:793093;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-hooks\";i:1252924;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/spacing/classes/sections\";i:55469;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/spacing/classes\";i:252524;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/spacing/assets/js/minified\";i:58492;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/spacing/assets/js/unminified\";i:76817;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/spacing/assets/js\";i:135309;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/spacing/assets\";i:135309;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/spacing\";i:389386;s:117:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/colors-and-background/classes/dynamic-css\";i:59870;s:114:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/colors-and-background/classes/sections\";i:69986;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/colors-and-background/classes\";i:142034;s:116:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/colors-and-background/assets/js/minified\";i:24475;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/colors-and-background/assets/js/unminified\";i:31631;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/colors-and-background/assets/js\";i:56106;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/colors-and-background/assets\";i:56106;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/colors-and-background\";i:200360;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/lifterlms/classes/sections\";i:12937;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/lifterlms/classes\";i:36060;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/lifterlms/templates\";i:1600;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/lifterlms/assets/js/minified\";i:526;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/lifterlms/assets/js/unminified\";i:1279;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/lifterlms/assets/js\";i:1805;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/lifterlms/assets/css/minified\";i:11433;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/lifterlms/assets/css/unminified\";i:13165;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/lifterlms/assets/css\";i:24598;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/lifterlms/assets\";i:26403;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/lifterlms\";i:65547;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-search/classes/sections\";i:12630;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-search/classes\";i:32339;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-search/template\";i:2360;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-search/assets/js/minified\";i:3138;s:112:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-search/assets/js/unminified\";i:6610;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-search/assets/js\";i:9748;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-search/assets/css/minified\";i:19021;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-search/assets/css/unminified\";i:24625;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-search/assets/css\";i:43646;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-search/assets\";i:53394;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-search\";i:91519;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/typography/classes/sections\";i:88368;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/typography/classes\";i:169817;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/typography/assets/js/minified\";i:16806;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/typography/assets/js/unminified\";i:22052;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/typography/assets/js\";i:38858;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/typography/assets\";i:38858;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/typography\";i:210058;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/sticky-header/classes/dynamic-css\";i:211897;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/sticky-header/classes/sections\";i:163757;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/sticky-header/classes\";i:420577;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/sticky-header/assets/js/minified\";i:91439;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/sticky-header/assets/js/unminified\";i:126286;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/sticky-header/assets/js\";i:217725;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/sticky-header/assets/css/minified\";i:21169;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/sticky-header/assets/css/unminified\";i:23847;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/sticky-header/assets/css\";i:45016;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/sticky-header/assets\";i:262741;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/sticky-header\";i:686605;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/mobile-header/classes/dynamic-css\";i:216909;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/mobile-header/classes/sections\";i:26733;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/mobile-header/classes\";i:270280;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/mobile-header/assets/js/minified\";i:82846;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/mobile-header/assets/js/unminified\";i:116582;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/mobile-header/assets/js\";i:199428;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/mobile-header/assets/css/minified\";i:128432;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/mobile-header/assets/css/unminified\";i:150148;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/mobile-header/assets/css\";i:278580;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/mobile-header/assets\";i:478008;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/mobile-header\";i:750749;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/blog-pro/classes/sections\";i:65130;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/blog-pro/classes\";i:142959;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/blog-pro/template\";i:5482;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/blog-pro/assets/js/minified\";i:33900;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/blog-pro/assets/js/unminified\";i:93983;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/blog-pro/assets/js\";i:127883;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/blog-pro/assets/css/minified\";i:51802;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/blog-pro/assets/css/unminified\";i:64208;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/blog-pro/assets/css\";i:116010;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/blog-pro/assets\";i:243893;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/blog-pro\";i:393794;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/edd/classes/sections\";i:53800;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/edd/classes\";i:91990;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/edd/templates\";i:1474;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/edd/assets/js/minified\";i:8609;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/edd/assets/js/unminified\";i:11440;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/edd/assets/js\";i:20049;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/edd/assets/css/minified\";i:14059;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/edd/assets/css/unminified\";i:17155;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/edd/assets/css\";i:31214;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/edd/assets\";i:51263;s:79:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/edd\";i:146297;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/learndash/classes/sections\";i:23256;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/learndash/classes\";i:51215;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/learndash/templates\";i:1425;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/learndash/assets/js/minified\";i:7370;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/learndash/assets/js/unminified\";i:8154;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/learndash/assets/js\";i:15524;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/learndash/assets/css/minified\";i:3787;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/learndash/assets/css/unminified\";i:4703;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/learndash/assets/css\";i:8490;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/learndash/assets\";i:24014;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/learndash\";i:78292;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-footer/classes/sections\";i:15224;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-footer/classes\";i:39192;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-footer/template\";i:13559;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-footer/assets/js/minified\";i:1838;s:112:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-footer/assets/js/unminified\";i:2387;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-footer/assets/js\";i:4225;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-footer/assets/css/minified\";i:3360;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-footer/assets/css/unminified\";i:6744;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-footer/assets/css\";i:10104;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-footer/assets\";i:14329;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-footer\";i:68659;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-headers/classes\";i:211061;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-headers/compatibility\";i:1219;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-headers/template\";i:5574;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-headers/assets/images\";i:1256;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-headers/assets/js/minified\";i:19584;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-headers/assets/js/unminified\";i:19316;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-headers/assets/js\";i:38900;s:112:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-headers/assets/css/minified\";i:15031;s:114:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-headers/assets/css/unminified\";i:22055;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-headers/assets/css\";i:37086;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-headers/assets\";i:77242;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-headers/includes\";i:5032;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons/advanced-headers\";i:301840;s:75:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/addons\";i:10745832;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/bsf-analytics/assets/css/minified\";i:608;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/bsf-analytics/assets/css/unminified\";i:738;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/bsf-analytics/assets/css\";i:1346;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/bsf-analytics/assets\";i:1346;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/bsf-analytics\";i:25557;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/assets/js\";i:16687;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/assets/css\";i:11172;s:81:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/assets\";i:27859;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/astra-rollback/assets/js\";i:1819;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/astra-rollback/assets/css\";i:219;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/astra-rollback/assets\";i:2038;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/astra-rollback\";i:11364;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/core/assets/images\";i:646;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/core/assets/build\";i:73981;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/core/assets/css\";i:11814;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/core/assets\";i:86441;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/core/includes\";i:12782;s:79:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/core\";i:119700;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/bsf-core/classes\";i:12670;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/bsf-core/auto-update\";i:22783;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/bsf-core/assets/images\";i:25559;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/bsf-core/assets/fonts\";i:7039;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/bsf-core/assets/js\";i:36842;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/bsf-core/assets/css\";i:36789;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/bsf-core/assets\";i:106229;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/bsf-core/includes/views\";i:3294;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/bsf-core/includes\";i:23498;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/bsf-core/plugin-installer\";i:10166;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin/bsf-core\";i:288047;s:74:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/admin\";i:472706;s:81:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/assets/fonts\";i:4833;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/assets/js/minified\";i:10174;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/assets/js/unminified\";i:19903;s:78:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/assets/js\";i:30077;s:81:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/assets/flags\";i:341775;s:79:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/assets/img\";i:27993;s:79:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/assets/svg\";i:49980;s:75:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/assets\";i:454658;s:78:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon/languages\";i:1217719;s:68:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-addon\";i:14108193;s:80:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/classes\";i:11045;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/classes\";i:23527;s:129:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/components/customizer-step\";i:1090;s:126:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/components/default-step\";i:2407;s:132:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/components/exist-to-dashboard\";i:561;s:119:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/components/error\";i:6131;s:126:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/components/import-steps\";i:5743;s:126:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/components/site-preview\";i:4578;s:128:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/components/color-palettes\";i:4823;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/components/logo\";i:750;s:129:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/components/change-template\";i:2503;s:128:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/components/media-uploader\";i:7652;s:130:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/components/choose-ecommerce\";i:5021;s:127:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/components/font-selector\";i:8562;s:120:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/components/button\";i:3119;s:133:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/components/util/next-step-link\";i:3587;s:135:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/components/util/next-step-button\";i:879;s:137:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/components/util/previous-step-link\";i:3513;s:139:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/components/util/previous-step-button\";i:533;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/components/util\";i:8512;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/components\";i:62218;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/ui\";i:2131;s:120:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/import-site\";i:53227;s:139:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/site-list/site-category-filter\";i:2333;s:129:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/site-list/sites-grid\";i:2919;s:133:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/site-list/favorite-sites\";i:2002;s:136:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/site-list/no-favorite-sites\";i:684;s:138:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/site-list/page-builder-filter\";i:1916;s:132:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/site-list/related-sites\";i:1258;s:138:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/site-list/header/sync-library\";i:9948;s:137:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/site-list/header/my-favorite\";i:1380;s:125:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/site-list/header\";i:13075;s:132:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/site-list/search-filter\";i:6431;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/site-list\";i:44544;s:162:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/customize-site/customize-steps/site-colors-typography\";i:18151;s:158:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/customize-site/customize-steps/license-validation\";i:7018;s:153:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/customize-site/customize-steps/business-logo\";i:2338;s:160:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/customize-site/customize-steps/ecommerce-selections\";i:2222;s:139:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/customize-site/customize-steps\";i:30758;s:123:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/customize-site\";i:33515;s:123:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/survey-loading\";i:1404;s:115:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/survey\";i:32254;s:121:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps/page-builder\";i:5683;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/steps\";i:177969;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/utils\";i:11397;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src/store\";i:3267;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/src\";i:278989;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/dist\";i:827341;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets/images\";i:203493;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding/assets\";i:1360984;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/onboarding\";i:1393861;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/gutenberg-templates/dist/fonts\";i:11506;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/gutenberg-templates/dist/json\";i:774632;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/gutenberg-templates/dist\";i:1059605;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/gutenberg-templates/classes\";i:53067;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/gutenberg-templates\";i:1114986;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/astra-notices\";i:15028;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib/bsf-quick-links\";i:7796;s:80:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/lib\";i:2533908;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/classes/compatibility/sfwd-lms\";i:3018;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/classes/compatibility/uag\";i:1129;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/classes/compatibility/woocommerce\";i:5559;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/classes/compatibility/surecart\";i:3137;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/classes/compatibility/beaver-builder\";i:1192;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/classes/compatibility/elementor\";i:5123;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/classes/compatibility/astra-pro\";i:9635;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/classes/compatibility/uabb\";i:1153;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/classes/compatibility/learndash\";i:1191;s:126:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/classes/compatibility/checkout-plugins-stripe-woo\";i:1412;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/classes/compatibility\";i:34964;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/classes/batch-import\";i:21945;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/classes\";i:278450;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/importers/wxr-importer\";i:110955;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/importers/batch-processing/helpers\";i:29107;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/importers/batch-processing\";i:111139;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/importers\";i:253180;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/assets/images\";i:1003171;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/assets/fonts\";i:12531;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/assets/js/dist\";i:831353;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/assets/js\";i:976882;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/assets/css\";i:274493;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/assets\";i:2267077;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/includes\";i:30122;s:81:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc/json\";i:3453557;s:76:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/inc\";i:8816294;s:112:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/admin/bsf-analytics/assets/css/minified\";i:608;s:114:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/admin/bsf-analytics/assets/css/unminified\";i:778;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/admin/bsf-analytics/assets/css\";i:1386;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/admin/bsf-analytics/assets\";i:1386;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/admin/bsf-analytics\";i:25785;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/admin/bsf-core/classes\";i:12670;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/admin/bsf-core/auto-update\";i:22783;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/admin/bsf-core/assets/images\";i:25559;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/admin/bsf-core/assets/fonts\";i:7039;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/admin/bsf-core/assets/js\";i:36842;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/admin/bsf-core/assets/css\";i:36789;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/admin/bsf-core/assets\";i:106229;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/admin/bsf-core/includes/views\";i:3294;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/admin/bsf-core/includes\";i:23498;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/admin/bsf-core/plugin-installer\";i:10166;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/admin/bsf-core\";i:289695;s:78:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/admin\";i:315553;s:82:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites/languages\";i:1304588;s:72:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/astra-pro-sites\";i:10500245;s:74:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/classic-editor/js\";i:624;s:71:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/classic-editor\";i:63402;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/app/modules/site-editor\";i:1068;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/app/modules/onboarding\";i:13607;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/app/modules/kit-library/data/kits/endpoints\";i:1909;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/app/modules/kit-library/data/kits\";i:3433;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/app/modules/kit-library/data/taxonomies\";i:811;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/app/modules/kit-library/data\";i:13757;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/app/modules/kit-library/connect\";i:2072;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/app/modules/kit-library\";i:20068;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/app/modules/import-export/compatibility\";i:4536;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/app/modules/import-export/processes\";i:38448;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/app/modules/import-export/runners/export\";i:11736;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/app/modules/import-export/runners/import\";i:19191;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/app/modules/import-export/runners/revert\";i:6852;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/app/modules/import-export/runners\";i:38307;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/app/modules/import-export\";i:122106;s:78:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/app/modules\";i:156849;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/app/admin-menu-items\";i:570;s:70:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/app\";i:164749;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/data/base/processor\";i:877;s:76:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/data/base\";i:19488;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/data/v2/base/exceptions\";i:2215;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/data/v2/base/endpoint/index\";i:3416;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/data/v2/base/endpoint\";i:5074;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/data/v2/base/processor\";i:1031;s:79:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/data/v2/base\";i:34659;s:74:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/data/v2\";i:43779;s:71:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/data\";i:72671;s:82:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/web-cli\";i:1109;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/favorites/types\";i:1527;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/favorites\";i:9300;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/compatibility-tag/views\";i:2221;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/compatibility-tag\";i:14190;s:81:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/wp-cli\";i:15690;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/performance-lab\";i:2209;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/lazyload\";i:6684;s:80:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/usage\";i:21467;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/safe-mode/mu-plugin\";i:3967;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/safe-mode\";i:20309;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/elements-color-picker\";i:979;s:80:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/notes\";i:1235;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/dev-tools\";i:11261;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/admin-bar\";i:3283;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/nested-elements/base\";i:2988;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/nested-elements/controls\";i:483;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/nested-elements\";i:5072;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/site-navigation/data/endpoints\";i:8463;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/site-navigation/data\";i:9868;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/site-navigation\";i:11721;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/history/views\";i:5402;s:82:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/history\";i:17055;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/announcements/classes\";i:2505;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/announcements/triggers\";i:1803;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/announcements\";i:8479;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/system-info/templates\";i:937;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/system-info/reporters\";i:38566;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/system-info/helpers\";i:1738;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/system-info\";i:51356;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/dynamic-tags\";i:3029;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/ai/connect\";i:12020;s:77:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/ai\";i:28121;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/kit-elements-defaults/data\";i:3883;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/kit-elements-defaults/import-export/runners\";i:3856;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/kit-elements-defaults/import-export\";i:4731;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/kit-elements-defaults/utils\";i:5701;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/kit-elements-defaults\";i:16275;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/promotions/admin-menu-items/interfaces\";i:474;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/promotions/admin-menu-items\";i:6910;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/promotions\";i:9244;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/admin-top-bar\";i:3268;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/container-converter\";i:4179;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/styleguide/controls\";i:498;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/styleguide\";i:4696;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/shapes/widgets\";i:14383;s:81:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/shapes\";i:15744;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/apps/images\";i:222453;s:79:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/apps\";i:237473;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/page-templates/templates\";i:2089;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/page-templates\";i:13385;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/library/documents\";i:7119;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/library/traits\";i:1041;s:82:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/library\";i:12318;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/gutenberg\";i:3764;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/landing-pages/admin-menu-items\";i:1200;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/landing-pages/documents\";i:2335;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/landing-pages\";i:21324;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/nested-tabs/widgets\";i:40216;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/nested-tabs\";i:40967;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/generator-tag\";i:2352;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/nested-accordion/widgets\";i:24964;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules/nested-accordion\";i:25742;s:74:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/modules\";i:643280;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/jquery-hover-intent\";i:3093;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/pickr/themes\";i:9117;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/pickr\";i:32636;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/e-gallery/js\";i:65251;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/e-gallery/css\";i:7065;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/e-gallery\";i:72316;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/flatpickr\";i:157376;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/nprogress\";i:17564;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/inline-editor/js\";i:49905;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/inline-editor\";i:49905;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/jquery-numerator\";i:5194;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/e-select2/js\";i:241935;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/e-select2/css\";i:32267;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/e-select2\";i:274202;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/nouislider\";i:110550;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/animations\";i:18468;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/jquery-easing\";i:8184;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/color-thief\";i:6666;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/imagesloaded\";i:19402;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/eicons/fonts\";i:962626;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/eicons/css\";i:43231;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/eicons\";i:1416165;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/backbone\";i:192428;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/share-link\";i:7195;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/hover\";i:20542;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/perfect-scrollbar/js\";i:53612;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/perfect-scrollbar\";i:53612;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/font-awesome/fonts\";i:1085661;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/font-awesome/js\";i:55725;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/font-awesome/migration\";i:41049;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/font-awesome/json\";i:1165834;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/font-awesome/webfonts\";i:2929404;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/font-awesome/css\";i:419531;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/font-awesome\";i:5697204;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/swiper/v8/css\";i:35772;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/swiper/v8\";i:500732;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/swiper/css\";i:28823;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/swiper\";i:972411;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/tipsy\";i:12799;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/dialog\";i:31671;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/waypoints\";i:30316;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib/animate.css\";i:22669;s:77:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/lib\";i:9232568;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/images/app/site-editor\";i:161824;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/images/app/onboarding\";i:85684;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/images/app\";i:247508;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/images/library-connect\";i:304645;s:80:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/images\";i:757476;s:78:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/data\";i:164;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/svg-paths\";i:1225;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/mask-shapes\";i:2391;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/js/packages/query\";i:188353;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/js/packages/ui\";i:3833946;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/js/packages/editor-documents\";i:18792;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/js/packages/editor-panels\";i:19046;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/js/packages/locations\";i:7974;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/js/packages/editor-v1-adapters\";i:17038;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/js/packages/store\";i:326344;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/js/packages/editor-responsive\";i:15337;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/js/packages/editor-site-navigation\";i:65113;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/js/packages/env\";i:4920;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/js/packages/editor\";i:14042;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/js/packages/editor-app-bar\";i:65481;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/js/packages/icons\";i:173977;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/js/packages\";i:4750363;s:76:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/js\";i:19336759;s:80:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/shapes\";i:26279;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/css/modules/lazyload\";i:1129;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/css/modules/notes\";i:285;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/css/modules/announcements\";i:7997;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/css/modules/ai\";i:946;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/css/modules/container-converter\";i:904;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/css/modules/styleguide\";i:1651;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/css/modules/apps\";i:3500;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/css/modules\";i:16412;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/css/templates\";i:1359866;s:77:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets/css\";i:4859238;s:73:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/assets\";i:34216100;s:80:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/base\";i:152048;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/widgets/traits\";i:17093;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/widgets\";i:436000;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/managers\";i:78833;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/elements\";i:118852;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/interfaces\";i:409;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/editor-templates\";i:59792;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/settings/admin-menu-items\";i:5731;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/settings\";i:54227;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/template-library/classes\";i:5782;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/template-library/data/endpoints\";i:2321;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/template-library/data\";i:3015;s:117:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/template-library/sources/admin-menu-items\";i:1927;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/template-library/sources\";i:69123;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/template-library/forms\";i:1626;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/template-library\";i:97302;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/libraries/wp-background-process\";i:634;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/libraries/bfi-thumb\";i:24080;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/libraries\";i:24714;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/controls/groups\";i:93800;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/controls\";i:251591;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes/admin-templates\";i:7434;s:75:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/includes\";i:1540972;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/frontend/render-modes\";i:2561;s:80:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/frontend\";i:6415;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/base/background-process\";i:14017;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/base/elements-iteration-actions\";i:6901;s:76:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/base\";i:99177;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/document-types\";i:8313;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/app/modules/onboarding\";i:464;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/app/modules/kit-library/connect\";i:707;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/app/modules/kit-library\";i:1172;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/app/modules/import-export\";i:585;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/app/modules\";i:2221;s:75:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/app\";i:2576;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/common/modules/ajax\";i:7300;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/common/modules/connect/apps\";i:25521;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/common/modules/connect\";i:33652;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/common/modules/finder/categories\";i:13600;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/common/modules/finder\";i:23548;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/common/modules/event-tracker/data\";i:1867;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/common/modules/event-tracker\";i:9659;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/common/modules\";i:74159;s:78:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/common\";i:80668;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/debug/classes\";i:2437;s:77:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/debug\";i:7315;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/kits/documents/tabs\";i:55454;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/kits/documents\";i:61553;s:82:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/kits/views\";i:3322;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/kits/controls\";i:1634;s:76:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/kits\";i:80043;s:79:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/upgrade\";i:35463;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/role-manager\";i:7277;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/breakpoints\";i:18672;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/behaviors/interfaces\";i:636;s:81:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/behaviors\";i:636;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/dynamic-tags\";i:21523;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/experiments/exceptions\";i:177;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/experiments\";i:40538;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/settings/base\";i:11184;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/settings/page\";i:12588;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/settings/general\";i:3826;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/settings/editor-preferences\";i:5671;s:80:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/settings\";i:38366;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/admin/menu/interfaces\";i:546;s:82:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/admin/menu\";i:8805;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/admin/ui/components\";i:2421;s:80:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/admin/ui\";i:2421;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/admin/notices\";i:4258;s:77:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/admin\";i:69534;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/files/assets/svg\";i:7009;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/files/assets/json\";i:706;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/files/assets\";i:13391;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/files/file-types\";i:25977;s:81:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/files/css\";i:40575;s:77:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/files\";i:107569;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/utils/import-export/parsers\";i:29170;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/utils/import-export\";i:100860;s:77:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/utils\";i:125868;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/responsive/files\";i:4968;s:82:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/responsive\";i:9441;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/page-assets/data-managers/font-icon-svg\";i:3848;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/page-assets/data-managers\";i:12479;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/page-assets\";i:15397;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/editor/loader/v2/js\";i:574;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/editor/loader/v2/templates\";i:1604;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/editor/loader/v2/scss\";i:773;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/editor/loader/v2\";i:7033;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/editor/loader/common\";i:6692;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/editor/loader/v1/js\";i:26;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/editor/loader/v1/templates\";i:1602;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/editor/loader/v1\";i:4453;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/editor/loader\";i:26072;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/editor/data/globals/endpoints\";i:4306;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/editor/data/globals\";i:5349;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/editor/data\";i:5349;s:78:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/editor\";i:52414;s:79:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/schemes\";i:8972;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/logger/loggers\";i:4682;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/logger/items\";i:8662;s:78:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core/logger\";i:23510;s:71:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor/core\";i:883023;s:66:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/elementor\";i:37854390;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/ralouphie/getallheaders/src\";i:1640;s:114:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/ralouphie/getallheaders\";i:2720;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/ralouphie\";i:2720;s:125:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/phpseclib/phpseclib/phpseclib/Math\";i:126017;s:126:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/phpseclib/phpseclib/phpseclib/Crypt\";i:483247;s:130:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/phpseclib/phpseclib/phpseclib/File/ASN1\";i:870;s:125:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/phpseclib/phpseclib/phpseclib/File\";i:264527;s:137:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/phpseclib/phpseclib/phpseclib/System/SSH/Agent\";i:6238;s:131:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/phpseclib/phpseclib/phpseclib/System/SSH\";i:16474;s:127:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/phpseclib/phpseclib/phpseclib/System\";i:16474;s:129:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/phpseclib/phpseclib/phpseclib/Net/SFTP\";i:21793;s:124:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/phpseclib/phpseclib/phpseclib/Net\";i:356058;s:120:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/phpseclib/phpseclib/phpseclib\";i:1246859;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/phpseclib/phpseclib\";i:1249349;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/phpseclib\";i:1249349;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/firebase/php-jwt/src\";i:24387;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/firebase/php-jwt\";i:25907;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/firebase\";i:25907;s:128:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/monolog/monolog/src/Monolog/Formatter\";i:54283;s:123:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/monolog/monolog/src/Monolog/Test\";i:1867;s:132:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/monolog/monolog/src/Monolog/Handler/Slack\";i:9791;s:141:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed\";i:3562;s:136:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/monolog/monolog/src/Monolog/Handler/SyslogUdp\";i:1592;s:131:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/monolog/monolog/src/Monolog/Handler/Curl\";i:1819;s:126:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/monolog/monolog/src/Monolog/Handler\";i:249947;s:128:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/monolog/monolog/src/Monolog/Processor\";i:19634;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/monolog/monolog/src/Monolog\";i:368841;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/monolog/monolog/src\";i:368841;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/monolog/monolog\";i:403873;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/monolog\";i:403873;s:123:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/apiclient/src/Google/Task\";i:11707;s:124:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/apiclient/src/Google/Utils\";i:9446;s:123:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/apiclient/src/Google/Http\";i:22013;s:130:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/apiclient/src/Google/AccessToken\";i:9724;s:126:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/apiclient/src/Google/Service\";i:11804;s:130:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/apiclient/src/Google/AuthHandler\";i:7798;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/apiclient/src/Google\";i:121641;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/apiclient/src\";i:121641;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/apiclient\";i:131897;s:117:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/auth/src/Middleware\";i:12518;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/auth/src/HttpHandler\";i:9417;s:112:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/auth/src/Cache\";i:14296;s:117:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/auth/src/Subscriber\";i:11944;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/auth/src/Credentials\";i:43244;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/auth/src\";i:181691;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/auth\";i:210586;s:151:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/apiclient-services/src/Google/Service/Oauth2/Resource\";i:3244;s:142:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/apiclient-services/src/Google/Service/Oauth2\";i:7842;s:135:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/apiclient-services/src/Google/Service\";i:11647;s:127:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/apiclient-services/src/Google\";i:11647;s:120:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/apiclient-services/src\";i:11647;s:116:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google/apiclient-services\";i:21903;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/google\";i:364386;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/composer\";i:51291;s:122:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/guzzlehttp/guzzle/src/Exception\";i:7764;s:120:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/guzzlehttp/guzzle/src/Handler\";i:63061;s:119:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/guzzlehttp/guzzle/src/Cookie\";i:27923;s:112:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/guzzlehttp/guzzle/src\";i:206004;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/guzzlehttp/guzzle\";i:342452;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/guzzlehttp/psr7/src\";i:145828;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/guzzlehttp/psr7\";i:154138;s:114:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/guzzlehttp/promises/src\";i:43658;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/guzzlehttp/promises\";i:46093;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/guzzlehttp\";i:542683;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/psr/cache/src\";i:8603;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/psr/cache\";i:10429;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/psr/http-message/src\";i:46455;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/psr/http-message\";i:48615;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/psr/http-client/src\";i:1915;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/psr/http-client\";i:3377;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/psr/log/Psr/Log/Test\";i:9427;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/psr/log/Psr/Log\";i:20877;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/psr/log/Psr\";i:20877;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/psr/log\";i:21962;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor/psr\";i:84383;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/vendor\";i:2724770;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/admin/images\";i:12327;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/admin/js\";i:1121;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/admin/css\";i:3962;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/admin\";i:17410;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/view\";i:455510;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/tipso\";i:51911;s:122:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/offcanvas\";i:7669;s:126:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/jquery.resize\";i:6361;s:121:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/waypoint\";i:17813;s:117:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/gsap\";i:162899;s:121:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/flipster\";i:14641;s:130:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/jquery.event.move\";i:19973;s:128:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/jquery-parallax\";i:374;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/tippy\";i:106946;s:125:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/twentytwenty\";i:7923;s:117:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/gmap\";i:97945;s:123:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/nicescroll\";i:119786;s:122:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/particles\";i:65662;s:125:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/progress-bar\";i:2262;s:125:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/table-sorter\";i:196797;s:119:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/popper\";i:41222;s:130:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/vertical-timeline\";i:3602;s:130:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/interactive-cards\";i:5231;s:126:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/jquery.cookie\";i:4388;s:121:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/odometer\";i:21285;s:121:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view/jarallax\";i:30818;s:112:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/lib-view\";i:985508;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js/edit\";i:36812;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/js\";i:1477830;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/img\";i:6167;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/css/view\";i:915818;s:121:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/css/lib-view/animate\";i:71752;s:122:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/css/lib-view/flipster\";i:15355;s:119:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/css/lib-view/tippy\";i:25786;s:126:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/css/lib-view/twentytwenty\";i:10513;s:125:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/css/lib-view/social-feed\";i:10344;s:131:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/css/lib-view/interactive-cards\";i:20768;s:122:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/css/lib-view/odometer\";i:6857;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/css/lib-view\";i:161375;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end/css\";i:1077193;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets/front-end\";i:2561190;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/assets\";i:2578600;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/includes/Template/Content-Timeline\";i:6115;s:115:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/includes/Template/Woo-Thank-You\";i:43968;s:117:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/includes/Template/Woo-Cross-Sells\";i:5915;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/includes/Template/Post-List\";i:26537;s:112:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/includes/Template/Post-Block\";i:18084;s:115:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/includes/Template/Post-Carousel\";i:18004;s:120:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/includes/Template/Woo-Product-Slider\";i:22736;s:128:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/includes/Template/Dynamic-Filterable-Gallery\";i:13873;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/includes/Template\";i:155232;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/includes/Elements\";i:1834075;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/includes/Extensions\";i:122630;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/includes/Skins\";i:288965;s:114:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/includes/Classes/License/views\";i:5167;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/includes/Classes/License\";i:21374;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/includes/Classes\";i:61442;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/includes/templates/ld-courses\";i:21489;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/includes/templates\";i:21489;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/includes/Traits\";i:248402;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/includes\";i:2732235;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor/languages\";i:322760;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/essential-addons-elementor\";i:8471523;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/images/browser-icons\";i:10795;s:82:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/images/logos\";i:2763;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/images/datepicker\";i:1643;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/images/template-library\";i:86777;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/images/theme/chosen\";i:1276;s:82:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/images/theme\";i:1754;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/images/doctypes\";i:5255;s:76:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/images\";i:645316;s:75:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/fonts\";i:1901923;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/legacy/images/datepicker\";i:17872;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/legacy/images\";i:17872;s:80:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/legacy/css\";i:364886;s:76:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/legacy\";i:382758;s:120:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/js/components/form_editor/conditional_flyout/views\";i:4515;s:114:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/js/components/form_editor/conditional_flyout\";i:57449;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/js/components/form_editor\";i:57449;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/js/components\";i:57449;s:79:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/js/vendor\";i:345372;s:72:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/js\";i:1202127;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/assets/js/dist\";i:1673685;s:79:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/assets/js\";i:1673685;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/assets/img/base\";i:3792;s:80:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/assets/img\";i:3792;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/assets/css/dist\";i:3099213;s:80:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/assets/css\";i:3099213;s:76:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/assets\";i:4776690;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/orders/summaries/views\";i:8500;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/orders/summaries\";i:11206;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/orders/factories\";i:13846;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/orders/exporters\";i:5234;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/orders/items\";i:4855;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/orders\";i:41727;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/merge-tags/config\";i:702;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/merge-tags\";i:2416;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/external-api\";i:5165;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/fields\";i:686057;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/setup-wizard/endpoints\";i:7272;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/setup-wizard/config\";i:16205;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/setup-wizard\";i:28910;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/transients\";i:757;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/form-editor/renderer\";i:772;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/form-editor/save-form/endpoints\";i:1510;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/form-editor/save-form/config\";i:3864;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/form-editor/save-form\";i:5374;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/form-editor/choices-ui/config\";i:1622;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/form-editor/choices-ui\";i:1622;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/form-editor\";i:13210;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/honeypot/config\";i:601;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/honeypot\";i:11430;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/logging/includes\";i:4162;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/logging\";i:31068;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/query/json-handlers\";i:3282;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/query/batch-processing\";i:4686;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/query\";i:79220;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/environment-config\";i:8061;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/addon/images\";i:3432;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/addon/js\";i:60706;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/addon/css\";i:25347;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/addon\";i:566823;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/legacy\";i:93040;s:84:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/async\";i:7203;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/telemetry\";i:8298;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/blocks/config\";i:2385;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/blocks\";i:25675;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/theme-layers/api/fluent/layers\";i:2660;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/theme-layers/api/fluent\";i:6047;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/theme-layers/api/json/rules\";i:1202;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/theme-layers/api/json/layers\";i:5032;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/theme-layers/api/json\";i:6851;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/theme-layers/api/views\";i:1347;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/theme-layers/api\";i:15795;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/theme-layers/framework/factories\";i:2726;s:128:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/theme-layers/framework/engines/definition-engines\";i:1936;s:124:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/theme-layers/framework/engines/output-engines\";i:14416;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/theme-layers/framework/engines\";i:16352;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/theme-layers/framework/traits\";i:4651;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/theme-layers/framework\";i:26838;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/theme-layers\";i:50682;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/system-status/js\";i:10286;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/system-status\";i:79572;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/save-form/endpoints\";i:5075;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/save-form/config\";i:2900;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/save-form\";i:26621;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/config/items\";i:8083;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/config\";i:25798;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/duplicate-submissions\";i:5235;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/templates\";i:4513;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/settings/fields\";i:145728;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/settings/config\";i:4147;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/settings/js\";i:9201;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/settings\";i:227959;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/assets/theme-dependencies\";i:772;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/assets/admin-dependencies\";i:2441;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/assets\";i:12882;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/messages\";i:7528;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/wizard/steps\";i:15621;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/wizard\";i:25935;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/webapi/v2/includes/controllers\";i:126914;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/webapi/v2/includes\";i:150677;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/webapi/v2\";i:231350;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/webapi/js\";i:19488;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/webapi/includes\";i:4404;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/webapi/css\";i:112;s:85:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/webapi\";i:332134;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/updates\";i:7385;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/embed-form/endpoints\";i:3285;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/embed-form/config\";i:9572;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/embed-form/dom\";i:561;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/embed-form\";i:18011;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/template-library/endpoints\";i:3458;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/template-library/config\";i:6064;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/template-library/templates\";i:428056;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/template-library\";i:444014;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/splash-page\";i:22976;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/libraries\";i:29727;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/locking/images\";i:365;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/locking/js\";i:15609;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/locking/css\";i:790;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/locking\";i:41288;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/license\";i:21158;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/phpqrcode\";i:125415;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/util/colors\";i:6922;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/util\";i:8683;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/form-display/block-styles/views\";i:3022;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/form-display/block-styles\";i:13764;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/form-display/full-screen/views\";i:230;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/form-display/full-screen\";i:6231;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes/form-display\";i:24557;s:78:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/includes\";i:3439154;s:73:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/css\";i:56521;s:79:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms/languages\";i:380855;s:69:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/gravityforms\";i:14943411;s:80:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/base\";i:4777;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/lib/astra-notices\";i:14800;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/lib/MaxMind/Db/Reader\";i:15535;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/lib/MaxMind/Db\";i:27581;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/lib/MaxMind\";i:27581;s:79:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/lib\";i:42381;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/classes\";i:160748;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/timeline/widgets\";i:120351;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/timeline\";i:121298;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/how-to/widgets\";i:56250;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/how-to\";i:57189;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/offcanvas/widgets\";i:73890;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/offcanvas\";i:74846;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/woocommerce/widgets\";i:274223;s:111:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/woocommerce/template-blocks\";i:28294;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/woocommerce/templates/loop\";i:3127;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/woocommerce/templates\";i:63879;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/woocommerce/skins\";i:71651;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/woocommerce\";i:452981;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/business-hours/widgets\";i:21136;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/business-hours\";i:22105;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/image-gallery/widgets\";i:75810;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/image-gallery\";i:76776;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/cf-styler/widgets\";i:51776;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/cf-styler\";i:52793;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/welcome-music/widgets\";i:12389;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/welcome-music\";i:13356;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/nav-menu/widgets\";i:85984;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/nav-menu\";i:86940;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/content-toggle/widgets\";i:40534;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/content-toggle\";i:41510;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/marketing-button/widgets\";i:26553;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/marketing-button\";i:27534;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/hotspot/widgets\";i:69916;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/hotspot\";i:70854;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/modal-popup/widgets\";i:85895;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/modal-popup\";i:86852;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/caf-styler/widgets\";i:52640;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/caf-styler\";i:53756;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/buttons/widgets\";i:29776;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/buttons\";i:30719;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/posts/widgets\";i:19929;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/posts/template-blocks\";i:84116;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/posts/templates\";i:14329;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/posts/skins\";i:244920;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/posts\";i:374328;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/section-divider\";i:4924;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/video/widgets\";i:86279;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/video\";i:91186;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/team-member/widgets\";i:53314;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/team-member\";i:54275;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/google-map/widgets\";i:29038;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/google-map\";i:29990;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/particles\";i:19711;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/video-gallery/widgets\";i:82978;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/video-gallery\";i:89117;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/ba-slider/widgets\";i:23940;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/ba-slider\";i:24899;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/faq/widgets\";i:41552;s:87:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/faq\";i:45150;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/table/widgets\";i:87519;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/table\";i:88520;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/party-propz-extension\";i:49807;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/instagram-feed/widgets\";i:56358;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/instagram-feed\";i:57323;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/business-reviews/widgets\";i:23016;s:116:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/business-reviews/template-blocks\";i:38621;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/business-reviews/templates\";i:9267;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/business-reviews/skins\";i:41992;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/business-reviews\";i:113877;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/wpf-styler/widgets\";i:57933;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/wpf-styler\";i:58984;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/retina-image/widgets\";i:21889;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/retina-image\";i:23362;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/headings/widgets\";i:123674;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/headings\";i:124663;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/registration-form/widgets\";i:88347;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/registration-form\";i:105250;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/ff-styler/widgets\";i:54574;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/ff-styler\";i:55604;s:113:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/display-conditions/conditions\";i:50057;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/display-conditions\";i:66388;s:109:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/table-of-contents/widgets\";i:32690;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/table-of-contents\";i:33674;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/widgets\";i:99113;s:138:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/ralouphie/getallheaders/src\";i:1686;s:134:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/ralouphie/getallheaders\";i:4393;s:120:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/ralouphie\";i:4393;s:145:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/phpseclib/phpseclib/phpseclib/Math\";i:129804;s:146:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/phpseclib/phpseclib/phpseclib/Crypt\";i:496064;s:150:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/phpseclib/phpseclib/phpseclib/File/ASN1\";i:917;s:145:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/phpseclib/phpseclib/phpseclib/File\";i:271437;s:157:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/phpseclib/phpseclib/phpseclib/System/SSH/Agent\";i:6113;s:151:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/phpseclib/phpseclib/phpseclib/System/SSH\";i:15200;s:147:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/phpseclib/phpseclib/phpseclib/System\";i:15200;s:149:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/phpseclib/phpseclib/phpseclib/Net/SFTP\";i:22588;s:144:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/phpseclib/phpseclib/phpseclib/Net\";i:364898;s:140:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/phpseclib/phpseclib/phpseclib\";i:1277961;s:130:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/phpseclib/phpseclib\";i:1285636;s:120:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/phpseclib\";i:1285636;s:131:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/firebase/php-jwt/src\";i:15040;s:127:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/firebase/php-jwt\";i:25501;s:119:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/firebase\";i:25501;s:148:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/monolog/monolog/src/Monolog/Formatter\";i:50245;s:152:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/monolog/monolog/src/Monolog/Handler/Slack\";i:8719;s:161:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/monolog/monolog/src/Monolog/Handler/FingersCrossed\";i:3461;s:156:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/monolog/monolog/src/Monolog/Handler/SyslogUdp\";i:1457;s:151:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/monolog/monolog/src/Monolog/Handler/Curl\";i:1554;s:146:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/monolog/monolog/src/Monolog/Handler\";i:238245;s:148:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/monolog/monolog/src/Monolog/Processor\";i:18276;s:138:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/monolog/monolog/src/Monolog\";i:353714;s:130:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/monolog/monolog/src\";i:353714;s:126:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/monolog/monolog\";i:385458;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/monolog\";i:385458;s:143:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/apiclient/src/Google/Task\";i:8928;s:144:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/apiclient/src/Google/Utils\";i:9779;s:143:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/apiclient/src/Google/Http\";i:22626;s:150:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/apiclient/src/Google/AccessToken\";i:9962;s:146:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/apiclient/src/Google/Service\";i:12438;s:150:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/apiclient/src/Google/AuthHandler\";i:6954;s:138:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/apiclient/src/Google\";i:120173;s:131:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/apiclient/src\";i:120173;s:132:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/apiclient/docs\";i:50497;s:127:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/apiclient\";i:199938;s:137:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/auth/src/Middleware\";i:12253;s:138:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/auth/src/HttpHandler\";i:8055;s:132:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/auth/src/Cache\";i:14923;s:137:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/auth/src/Subscriber\";i:11846;s:138:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/auth/src/Credentials\";i:38488;s:126:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/auth/src\";i:162496;s:122:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/auth\";i:196803;s:171:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/apiclient-services/src/Google/Service/Oauth2/Resource\";i:3368;s:162:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/apiclient-services/src/Google/Service/Oauth2\";i:11243;s:155:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/apiclient-services/src/Google/Service\";i:15959;s:147:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/apiclient-services/src/Google\";i:15959;s:140:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/apiclient-services/src\";i:15959;s:142:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/apiclient-services/tests\";i:2355;s:136:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google/apiclient-services\";i:32564;s:117:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/google\";i:429305;s:119:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/composer\";i:49316;s:142:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/guzzlehttp/guzzle/src/Exception\";i:8762;s:140:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/guzzlehttp/guzzle/src/Handler\";i:61009;s:139:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/guzzlehttp/guzzle/src/Cookie\";i:28123;s:132:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/guzzlehttp/guzzle/src\";i:200709;s:128:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/guzzlehttp/guzzle\";i:338440;s:130:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/guzzlehttp/psr7/src\";i:151035;s:126:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/guzzlehttp/psr7\";i:185285;s:134:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/guzzlehttp/promises/src\";i:45221;s:130:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/guzzlehttp/promises\";i:64377;s:121:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/guzzlehttp\";i:588102;s:124:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/psr/cache/src\";i:8869;s:120:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/psr/cache\";i:11554;s:131:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/psr/http-message/src\";i:47704;s:127:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/psr/http-message\";i:50936;s:131:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/psr/log/Psr/Log/Test\";i:9563;s:126:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/psr/log/Psr/Log\";i:21488;s:122:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/psr/log/Psr\";i:21488;s:118:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/psr/log\";i:24583;s:114:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor/psr\";i:87073;s:110:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes/vendor\";i:2854969;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form/includes\";i:2854969;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/login-form\";i:2969596;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/gf-styler/widgets\";i:70350;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/gf-styler\";i:71444;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/price-list/widgets\";i:44121;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/price-list\";i:45074;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/twitter/widgets\";i:97094;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/twitter\";i:98041;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/social-share/widgets\";i:76360;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/social-share\";i:77323;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/price-table/widgets\";i:142994;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/price-table\";i:143946;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/infobox/widgets\";i:95509;s:91:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/infobox\";i:96447;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/presets-select/controls\";i:3001;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/presets-select\";i:5268;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/query-post/controls\";i:2688;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/query-post\";i:7563;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/countdown/widgets\";i:45221;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/countdown\";i:46176;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/control-query/types\";i:2743;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules/control-query\";i:9870;s:83:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/modules\";i:6351289;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/compatibility/modules\";i:21266;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/compatibility\";i:50287;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/editor-assets/fonts\";i:196098;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/editor-assets/js\";i:5773;s:93:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/editor-assets/css\";i:7066;s:89:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/editor-assets\";i:208937;s:115:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin/bsf-analytics/assets/css/minified\";i:608;s:117:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin/bsf-analytics/assets/css/unminified\";i:778;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin/bsf-analytics/assets/css\";i:1386;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin/bsf-analytics/assets\";i:1386;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin/bsf-analytics/bin\";i:471;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin/bsf-analytics\";i:208359;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin/assets/images\";i:16487;s:88:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin/assets\";i:45491;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin/bsf-core/classes\";i:13216;s:102:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin/bsf-core/auto-update\";i:23435;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin/bsf-core/assets/images\";i:25559;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin/bsf-core/assets/fonts\";i:7049;s:100:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin/bsf-core/assets/js\";i:37466;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin/bsf-core/assets/css\";i:38635;s:97:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin/bsf-core/assets\";i:108709;s:105:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin/bsf-core/includes/views\";i:3378;s:99:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin/bsf-core/includes\";i:24277;s:107:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin/bsf-core/plugin-installer\";i:10481;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin/bsf-core\";i:296464;s:81:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/admin\";i:550323;s:90:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/assets/presets\";i:99087;s:103:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/assets/lib/justifiedgallery\";i:18517;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/assets/lib/typed\";i:6823;s:92:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/assets/lib/slick\";i:115409;s:94:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/assets/lib/isotope\";i:132928;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/assets/lib/jquery-datatables\";i:85288;s:101:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/assets/lib/infinitescroll\";i:3664;s:106:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/assets/lib/jquery-twentytwenty\";i:7948;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/assets/lib/tooltipster\";i:164306;s:96:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/assets/lib/js-cookie\";i:4869;s:108:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/assets/lib/jquery-element-resize\";i:9437;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/assets/lib/rvticker\";i:9552;s:95:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/assets/lib/fancybox\";i:122803;s:104:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/assets/lib/jquery-event-move\";i:21445;s:86:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/assets/lib\";i:702989;s:98:\"/home/ldstage/public_html/astra-theme/wp-content/plugins/ultimate-elementor/assets/min-css/modules\";i:130686